/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerPipeSwitcher;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericHashtable;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Sort;
import java.util.Map;
import java.util.Vector;

public class NumericToNumericMap
extends NumericMap {
    private Vector numericPipes = new Vector();
    private int sortType;
    private double stride = 0.0;
    private double start = 0.0;
    private NumericVector combinedUniqueValues = new NumericVector();
    private NumericHashtable combinedUniqueValuesToCategory = new NumericHashtable();
    private NumericHashtable valueToCategoryTable;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    private ReusableDouble tempRD = new ReusableDouble();
    public final IntegerPipe category = this.categorySwitcher;

    public NumericToNumericMap() {
        this.categorySwitcher.setOwner(this);
    }

    @Override
    public void init(AInitAction ia) {
        boolean beenInitialized = false;
        beenInitialized = this.multiPipeInit(ia);
        int labelCount = this.combinedUniqueValues.size();
        ia.setValueCount(labelCount);
        if (beenInitialized) {
            return;
        }
        Formatter labelFormatter = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.uniqueValueVector.setSize(labelCount);
        this.labelVector.setSize(labelCount);
        int keyIndex = 0;
        double mappedValue = this.start;
        while (keyIndex < labelCount) {
            block4: {
                String key;
                try {
                    key = labelFormatter.format(new Double(this.combinedUniqueValues.getValue(keyIndex)));
                    this.labelVector.setValueAt(key, keyIndex);
                }
                catch (MissingValueException e) {
                    if (!this.isLabelMissingValuesAny()) break block4;
                    key = this.getMissingValueLabel(e.getMissingValue());
                    this.labelVector.setValueAt(key, keyIndex);
                }
            }
            this.uniqueValueVector.setValueAt(mappedValue, keyIndex);
            ++keyIndex;
            mappedValue += this.stride;
        }
    }

    private boolean multiPipeInit(AInitAction ia) {
        int pipeIndex;
        boolean beenInitialized = true;
        int pipeCount = this.numericPipes.size();
        NumericVector[] uniqueValueVectors = new NumericVector[pipeCount];
        for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
            NumericPipe np = (NumericPipe)this.numericPipes.elementAt(pipeIndex);
            ia.setCategoryRequest(true);
            ia.pushValueCount();
            np.init(ia);
            uniqueValueVectors[pipeIndex] = (NumericVector)ia.getUniqueValueVector();
            ia.popValueCount();
            beenInitialized &= ia.beenInitialized(this);
        }
        if (!beenInitialized) {
            Formatter labelFormatter = this.getOwnerFormatter();
            this.combinedUniqueValues.removeAllValues();
            this.combinedUniqueValuesToCategory.removeAllValues();
            int category = 0;
            for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                NumericVector nv = uniqueValueVectors[pipeIndex];
                if (nv == null) continue;
                int valueCount = nv.size();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    MissingValues key;
                    try {
                        this.tempRD.value = nv.getValue(valueIndex);
                        key = this.tempRD;
                    }
                    catch (MissingValueException e) {
                        if (this.isReplaceMissingValuesAny()) {
                            this.tempRD.value = this.getMissingReplacement(e.getMissingValue());
                            key = this.tempRD;
                        }
                        key = e.getMissingValue();
                    }
                    if (this.combinedUniqueValuesToCategory.containsKey(key)) continue;
                    if (this.sortType == 0) {
                        if (key instanceof MissingValues) {
                            this.combinedUniqueValues.addValue(key);
                        } else {
                            this.combinedUniqueValues.addValue(this.tempRD.value);
                        }
                    }
                    this.combinedUniqueValuesToCategory.putIndex(key, category++);
                }
            }
            if (this.sortType != 0) {
                Sort.NumericComparator comparator = new Sort.NumericComparator(this.sortType, ia.getLocale(), ia.getSortStrategy());
                Sort.sortCategoryTable(this.combinedUniqueValuesToCategory.table, this.sortType, comparator);
                Sort.makeOrderedVector(this.combinedUniqueValues, (Map)this.combinedUniqueValuesToCategory.table);
            }
        }
        this.categorySwitcher.connectFrom(this.combinedUniqueValuesToCategory);
        this.valueToCategoryTable = this.combinedUniqueValuesToCategory;
        return beenInitialized;
    }

    public double getValue(double d) throws MissingValueException {
        if (this.valueToCategoryTable == null) {
            throw new MissingValueException();
        }
        this.tempRD.value = d;
        return this.uniqueValueVector.getValue(this.valueToCategoryTable.getIndex(this.tempRD));
    }

    @Override
    public double getOutputMin() {
        if (this.stride > 0.0) {
            return this.start;
        }
        AInitAction ia = new AInitAction(null);
        this.init(ia);
        return this.start + this.stride * (double)(ia.getValueCount() - 1);
    }

    @Override
    public double getOutputMax() {
        if (this.stride < 0.0) {
            return this.start;
        }
        AInitAction ia = new AInitAction(null);
        this.init(ia);
        return this.start + this.stride * (double)(ia.getValueCount() - 1);
    }

    public int getUniqueValueCount() {
        AInitAction ia = new AInitAction(null);
        this.uniqueValue.init(ia);
        return ia.getValueCount();
    }

    public double getStrideValue() {
        return this.stride;
    }

    public double getStartValue() {
        return this.start;
    }

    public void setStrideValue(double value) {
        this.stride = value;
        this.setModified();
    }

    public void setStartValue(double value) {
        this.start = value;
        this.setModified();
    }

    public void addNumericPipe(NumericPipe pipe) {
        if (!this.numericPipes.contains(pipe)) {
            this.numericPipes.addElement(pipe);
            this.setModified();
        }
    }

    public void removeAllNumericPipes() {
        this.numericPipes.removeAllElements();
    }

    public void removeNumericPipe(NumericPipe pipe) {
        this.numericPipes.removeElement(pipe);
    }

    public int getNumericPipeCount() {
        return this.numericPipes.size();
    }

    public NumericPipe getNumericPipe(int i) {
        return (NumericPipe)this.numericPipes.elementAt(i);
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.setModified();
    }

    public int getSortType() {
        return this.sortType;
    }
}

