/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.PropertyContainer;

public class NumericCache
extends PropertyContainer
implements NumericPipe {
    private NumericPipe cachePipe;
    private NumericVector cache = new NumericVector();
    public final NumericProperty input = new NumericProperty(this, true);
    public final NumericPipe value = this;

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        if (initAction.beenInitialized(this)) {
            return;
        }
        int n = initAction.getValueCount();
        if (n == -1) {
            this.cachePipe = this.input;
        } else {
            n = initAction.getValueCount();
            this.cache.setSize(n);
            for (int i = 0; i < n; ++i) {
                try {
                    double d = this.input.getValue(i);
                    this.cache.setValueAt(d, i);
                    continue;
                }
                catch (MissingValueException e) {
                    this.cache.setValueAt(e.getMissingValue(), i);
                }
            }
            this.cachePipe = this.cache;
        }
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        return this.cachePipe.getValue(index);
    }
}

