/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.AnimationConnection;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericPipeSwitcher;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringPipeSwitcher;
import com.sas.graphics.util.gtk.Variable;
import java.util.List;

public class NumericAnimationVariable
extends NumericVariable {
    private NumericVariable connectionVariable;
    private NumericAnimationConnection connection = new NumericAnimationConnection(this);
    private final NumericPipeSwitcher uniqueValueSwitcher = new NumericPipeSwitcher();
    public final NumericPipe uniqueValue = this.uniqueValueSwitcher;
    private final StringPipeSwitcher formattedUniqueValueSwitcher = new StringPipeSwitcher();
    public final StringPipe formattedUniqueValue = this.formattedUniqueValueSwitcher;
    private boolean interpolationEnabled;

    public NumericAnimationVariable(boolean interpolationEnabled) {
        this.interpolationEnabled = interpolationEnabled;
        this.uniqueValueSwitcher.setOwner(this.connection);
        this.formattedUniqueValueSwitcher.setOwner(this.connection);
    }

    @Override
    public void connectFrom(NumericVariable nv) {
        this.connectFrom(nv, this.interpolationEnabled);
    }

    public void connectFrom(NumericVariable nv, boolean doInterpolation) {
        this.connectionVariable = nv;
        super.connectFrom(nv);
        this.connectFrom(doInterpolation);
    }

    protected void connectFrom(boolean doInterpolation) {
        this.setRawValuePipe(this.connection, -1);
        this.connection.setConnection(this.connectionVariable);
        this.connection.setDoInterpolation(doInterpolation);
        this.uniqueValueSwitcher.connectFrom(this.connectionVariable.uniqueValue);
        this.formattedUniqueValueSwitcher.connectFrom(this.connectionVariable.formattedUniqueValue);
        super.connectFrom();
    }

    @Override
    public double getSum() {
        return ((NumericVariable)this.getConnection()).getSum();
    }

    @Override
    public double getMin() {
        return ((NumericVariable)this.getConnection()).getMin();
    }

    @Override
    public double getMean() {
        return ((NumericVariable)this.getConnection()).getMean();
    }

    @Override
    public double getMax() {
        return ((NumericVariable)this.getConnection()).getMax();
    }

    void setFrame(List valueIndexToByGroupPair, int pairCount, double interploationPercentage) {
        this.connection.setFrame(valueIndexToByGroupPair, pairCount, interploationPercentage);
    }

    void setAnimationIdVariable(Variable v) {
        this.connection.setAnimationIdVariable(v);
    }

    @Override
    protected int getRawValueCount() {
        return this.connectionVariable.getValueCount();
    }

    @Override
    public boolean isModified() {
        return this.connection.isModified();
    }

    private static class NumericAnimationConnection
    extends AnimationConnection
    implements NumericPipe {
        private boolean doInterpolation = false;

        public NumericAnimationConnection(Variable v) {
            super(v);
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            int[] pair = this.getKeyFramePair(i);
            if (pair != null) {
                double d;
                double d1 = Double.NaN;
                double d2 = Double.NaN;
                try {
                    d1 = this.getNumericConnection().value.getValue(pair[0]);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (this.doInterpolation) {
                    if (pair[1] < 0) {
                        d = d1;
                    } else {
                        try {
                            d2 = this.getNumericConnection().value.getValue(pair[1]);
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                        d = !Double.isNaN(d1) && !Double.isNaN(d2) ? this.interpolate(d1, d2) : (Double.isNaN(d1) ? d2 : d1);
                    }
                } else {
                    d = d1;
                }
                return d;
            }
            throw MissingValueException.getDefaultMissingValueExeption();
        }

        private double interpolate(double d1, double d2) {
            return d1 + (d2 - d1) * this.getInterpolationPercentage();
        }

        public boolean isMissing(int i) {
            try {
                double d = this.getValue(i);
                return d != d;
            }
            catch (MissingValueException e) {
                return true;
            }
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.getNumericConnection().reset(resetAction);
        }

        public void setDoInterpolation(boolean doInterpolation) {
            this.doInterpolation = doInterpolation;
        }
    }
}

