/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringPipeSwitcher;
import com.sas.graphics.util.gtk.ValueMap;

public abstract class Mapper
extends PropertyContainer
implements Pipe {
    protected StringPipeSwitcher labelSwitcher = new StringPipeSwitcher();
    public final StringPipe label = this.labelSwitcher;
    protected ValueMap map;

    public void setMap(ValueMap valueMap) {
        this.map = valueMap;
    }

    public static double[] adjustMinMax(double valueCount, double vMin, double vMax) {
        double step;
        double intervals = valueCount - 1.0;
        double logTen = Math.log(10.0);
        if (vMin == vMax) {
            vMax = vMin == 0.0 ? 0.125 / intervals : (vMax *= vMin < 0.0 ? 0.99 : 1.01);
        }
        double[] newValues = new double[]{vMin, vMax};
        double rawInterval = (vMax - vMin) / intervals;
        double logInterval = Math.floor(Math.log(rawInterval) / logTen);
        if (logInterval == 0.0) {
            step = 0.25;
            newValues[0] = Math.floor(vMin);
        } else {
            step = Math.pow(10.0, logInterval);
            newValues[0] = step * Math.floor(vMin / step);
        }
        double cleanInterval = step * Math.ceil(rawInterval / step);
        newValues[1] = newValues[0] + cleanInterval * intervals;
        return newValues;
    }

    protected abstract ValueMap getValueMap();

    public void setFormat(GTKFormat format) {
        this.getValueMap().setFormat(format);
    }

    public GTKFormat getFormat() {
        return this.getValueMap().getFormat();
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        ia.pushValueCount();
        this.getValueMap().init(ia);
        ia.popValueCount();
    }

    @Override
    public Formatter getFormatter() {
        ValueMap vm = this.getValueMap();
        Formatter f = vm.isUserSetFormat() ? vm.getFormatter() : super.getFormatter();
        return f;
    }

    public void setMissingValueLabel(String s) {
        this.getValueMap().setMissingValueLabel(s);
        this.setModified();
    }

    public String getMissingValueLabel() {
        return this.getValueMap().getMissingValueLabel();
    }

    public void setMissingValueLabel(String s, MissingValues mv) {
        this.getValueMap().setMissingValueLabel(s, mv);
        this.setModified();
    }

    public String getMissingValueLabel(MissingValues mv) {
        return this.getValueMap().getMissingValueLabel(mv);
    }

    protected void setReplaceMissingValues(boolean b) {
        this.map.setReplaceMissingValues(b);
    }

    protected void setReplaceMissingValues(boolean b, MissingValues mv) {
        this.map.setReplaceMissingValues(b, mv);
    }

    public boolean isReplaceMissingValues() {
        return this.map.isReplaceMissingValues();
    }

    public boolean isLabelMissingValues() {
        return this.map.isLabelMissingValues();
    }

    public boolean isLabelMissingValues(MissingValues mv) {
        return this.map.isLabelMissingValues(mv);
    }

    public void setLabelMissingValues(boolean b) {
        this.map.setLabelMissingValues(b);
    }

    public void setLabelMissingValues(boolean b, MissingValues missingValue) {
        this.map.setLabelMissingValues(b, missingValue);
    }
}

