/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.Style;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;

public class LegendStyle
extends Style {
    private static final Color defaultBackgroundColor = Color.black;
    public static final int LINE = 0;
    public static final int BLOCK = 1;
    public static final int SHADOW = 2;
    public static final int SHAPE_POLICY_AUTOMATIC = 0;
    public static final int SHAPE_POLICY_MAXIMUM_COLUMNS = 1;
    public static final int SHAPE_POLICY_MAXIMUM_ROWS = 2;
    protected boolean borderOn;
    protected boolean titleOn;
    protected boolean labelsOn;
    protected boolean backgroundOn;
    protected Color backgroundColor;
    protected Color borderColor;
    protected Color borderLineColor;
    protected int titlePosition;
    protected int borderStyle;
    protected double borderOffset;
    protected int borderVerticalJustification;
    protected int borderHorizontalJustification;
    protected float borderLineWidth;
    protected Color markerEdgeColor;
    protected TextStyle labelStyle;
    protected TextStyle titleStyle;
    protected int minimumLabelFontSize = 8;
    protected Color shadowColor;
    protected int shadowOffsetX;
    protected int shadowOffsetY;
    protected float shadowSoftness;
    protected int shapePolicy = 0;
    private double horizontalMargin;
    private double verticalMargin;
    private int titleMarkerId;
    private boolean titleMarkerVisible = false;
    private int titleMarkerSize;
    private double titleMarkerSpace = 4.0;
    private LineStyle continuousEdgeStyle = new LineStyle();
    private boolean continuousEdgeColorLinkedToLabelColor = true;
    private double continuousColorBarThickness = 1.0;

    public LegendStyle() {
        this.borderOn = true;
        this.titleOn = true;
        this.labelsOn = true;
        this.backgroundOn = false;
        this.shadowColor = Color.black;
        this.shadowOffsetX = 3;
        this.shadowOffsetY = 3;
        this.backgroundColor = defaultBackgroundColor;
        this.borderColor = null;
        this.borderLineColor = null;
        this.titlePosition = 0;
        this.borderStyle = 0;
        this.borderOffset = 3.0;
        this.borderVerticalJustification = 3;
        this.borderHorizontalJustification = 2;
        this.borderLineWidth = 1.0f;
        this.labelStyle = new TextStyle();
        this.titleStyle = new TextStyle();
        this.titleStyle.setHorizontalJustification(1);
        this.titleStyle.setVerticalJustification(3);
        this.horizontalMargin = 1.0;
        this.verticalMargin = 0.5;
    }

    public LegendStyle(LegendStyle ls) {
        this.borderOn = ls.borderOn;
        this.titleOn = ls.titleOn;
        this.labelsOn = ls.labelsOn;
        this.backgroundOn = ls.backgroundOn;
        this.backgroundColor = ls.backgroundColor;
        this.labelStyle = new TextStyle(ls.labelStyle);
        this.titleStyle = new TextStyle(ls.titleStyle);
        this.borderStyle = ls.borderStyle;
        this.borderOffset = ls.borderOffset;
        this.borderVerticalJustification = ls.borderVerticalJustification;
        this.borderHorizontalJustification = ls.borderHorizontalJustification;
        this.borderLineWidth = ls.borderLineWidth;
        this.markerEdgeColor = ls.markerEdgeColor;
        this.shadowColor = ls.shadowColor;
        this.shadowOffsetX = ls.shadowOffsetX;
        this.shadowOffsetY = ls.shadowOffsetY;
        this.shadowSoftness = ls.shadowSoftness;
        this.horizontalMargin = ls.horizontalMargin;
        this.verticalMargin = ls.verticalMargin;
    }

    public void setBorderOn(boolean trueOrFalse) {
        this.borderOn = trueOrFalse;
    }

    public void setTitleOn(boolean trueOrFalse) {
        this.titleOn = trueOrFalse;
    }

    public void setLabelsOn(boolean trueOrFalse) {
        this.labelsOn = trueOrFalse;
    }

    public void setBackgroundOn(boolean trueOrFalse) {
        this.backgroundOn = trueOrFalse;
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.backgroundColor = color;
        }
    }

    public void setTitlePosition(int position) {
        if (position >= 0 && position <= 2) {
            this.titlePosition = position;
        }
    }

    public void setLabelStyle(TextStyle style) {
        if (style != null) {
            this.labelStyle = style;
        }
    }

    public void setTitleStyle(TextStyle style) {
        if (style != null) {
            this.titleStyle = style;
        }
    }

    public void setBorderStyle(int borderStyle) {
        switch (borderStyle) {
            case 0: 
            case 1: 
            case 2: {
                this.borderStyle = borderStyle;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid border style.");
            }
        }
    }

    public void setBorderOffset(double offset) {
        if (offset > 0.0) {
            this.borderOffset = offset;
        }
    }

    public void setBorderVerticalJustification(int justification) {
        if (justification >= 0 && justification <= 3) {
            this.borderVerticalJustification = justification;
        }
    }

    public void setBorderHorizontalJustification(int justification) {
        if (justification >= 0 && justification <= 3) {
            this.borderHorizontalJustification = justification;
        }
    }

    public void setBorderLineWidth(float width) {
        if (width > 0.0f) {
            this.borderLineWidth = width;
        }
    }

    public void setMarkerEdgeColor(Color c) {
        this.markerEdgeColor = c;
    }

    public void setShadowColor(Color c) {
        this.shadowColor = c;
    }

    public void setShadowOffsetX(int offset) {
        this.shadowOffsetX = offset;
    }

    public void setShadowOffsetY(int offset) {
        this.shadowOffsetY = offset;
    }

    public void setShadowSoftness(float softness) {
        this.shadowSoftness = softness;
    }

    public boolean isBorderOn() {
        return this.borderOn;
    }

    public boolean isTitleOn() {
        return this.titleOn;
    }

    public boolean isLabelsOn() {
        return this.labelsOn;
    }

    public boolean isBackgroundOn() {
        return this.backgroundOn;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public double getBorderOffset() {
        return this.borderOffset;
    }

    public int getBorderVerticalJustification() {
        return this.borderVerticalJustification;
    }

    public int getBorderHorizontalJustification() {
        return this.borderHorizontalJustification;
    }

    public float getBorderLineWidth() {
        return this.borderLineWidth;
    }

    public Color getMarkerEdgeColor() {
        return this.markerEdgeColor;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public int getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public int getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public float getShadowSoftness() {
        return this.shadowSoftness;
    }

    public int getMinimumLabelFontSize() {
        return this.minimumLabelFontSize;
    }

    public void setMinimumLabelFontSize(int minimumLabelFontSize) {
        this.minimumLabelFontSize = minimumLabelFontSize;
    }

    public int getShapePolicy() {
        return this.shapePolicy;
    }

    public void setShapePolicy(int shapePolicy) {
        this.shapePolicy = shapePolicy;
    }

    public double getHorizontalMargin() {
        return this.horizontalMargin;
    }

    public double getVerticalMargin() {
        return this.verticalMargin;
    }

    public void setHorizontalMargin(double horizontalMargin) {
        this.horizontalMargin = horizontalMargin;
    }

    public void setVerticalMargin(double verticalMargin) {
        this.verticalMargin = verticalMargin;
    }

    public int getTitleMarkerId() {
        return this.titleMarkerId;
    }

    public int getTitleMarkerSize() {
        return this.titleMarkerSize;
    }

    public boolean isTitleMarkerVisible() {
        return this.titleMarkerVisible;
    }

    public void setTitleMarkerId(int titleMarkerId) {
        this.titleMarkerId = titleMarkerId;
    }

    public void setTitleMarkerSize(int titleMarkerSize) {
        this.titleMarkerSize = titleMarkerSize;
    }

    public void setTitleMarkerVisible(boolean titleMarkerVisible) {
        this.titleMarkerVisible = titleMarkerVisible;
    }

    public double getTitleMarkerSpace() {
        return this.titleMarkerSpace;
    }

    public void setTitleMarkerSpace(double space) {
        this.titleMarkerSpace = space;
    }

    public LineStyle getContinuousEdgeStyle() {
        return this.continuousEdgeStyle;
    }

    public void setContinuousEdgeStyle(LineStyle continuousEdgeStyle) {
        if (continuousEdgeStyle != null) {
            this.continuousEdgeStyle = continuousEdgeStyle;
        }
    }

    public boolean isContinuousEdgeColorLinkedToLabelColor() {
        return this.continuousEdgeColorLinkedToLabelColor;
    }

    public void setContinuousEdgeColorLinkedToLabelColor(boolean continuousEdgeColorLinkedToLabelColor) {
        this.continuousEdgeColorLinkedToLabelColor = continuousEdgeColorLinkedToLabelColor;
    }

    public void setContinuousColorBarThickness(double continuousColorBarThickness) {
        this.continuousColorBarThickness = continuousColorBarThickness;
    }

    public double getContinuousColorBarThickness() {
        return this.continuousColorBarThickness;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderLineColor() {
        return this.borderLineColor;
    }

    public void setBorderLineColor(Color borderLineColor) {
        this.borderLineColor = borderLineColor;
    }
}

