/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.RB;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.pie.GTKPieChartRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public abstract class GTKAPie
extends Element {
    public final NumericProperty radius = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final ColorProperty highlightFillColor = new ColorProperty(this, true);
    public final ColorProperty highlightEdgeColor = new ColorProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final NumericProperty highlightPercentage = new NumericProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final IntegerProperty precision = new IntegerProperty(this, true);
    protected int insideLabelContent;
    protected int outsideLabelContent;
    protected int outlineWidth;
    protected double startAngle;
    protected int sliceDirection;
    protected int sliceOrder;
    protected boolean twoD = true;
    protected double otherThresholdPct;
    protected int otherThresholdNum;
    protected Color otherColor;
    protected String otherLabel;
    protected String subgroupTitle;
    protected TextStyle insideLabelStyle;
    protected TextStyle outsideLabelStyle;
    protected double donutSize;
    protected String donutLabel;
    protected TextStyle donutLabelStyle;
    protected String[] invisibleArray;
    protected String[] explodeArray;
    protected double explodeAmount = 0.2;
    protected TextStyle subgroupLabelStyle = new TextStyle();
    protected TextStyle subgroupTitleStyle = new TextStyle();
    protected TextStyle responseTitleStyle = new TextStyle();
    protected int outsideLabelPlacement;
    protected int insideLabelPlacement;
    protected int subgroupLabelPlacement;
    protected int titleMarkerId = 0;
    protected int titleMarkerSize = 1;
    protected boolean titleMarkerVisible = false;
    protected boolean shrinkableFonts = false;
    protected Dimension size = new Dimension(400, 300);
    protected String responseLabel = "";
    protected Point2D.Double responseTitleAdjustment = new Point2D.Double();
    protected Dimension gridLayout = new Dimension(1, 1);
    protected double ringGap = 0.0;
    protected boolean explodeOtherSlice = false;
    protected boolean otherSliceVisible = true;
    protected RendererUtil.GroupGapDimension gapDimension;
    protected static final int CCW = -1;
    protected static final int CW = 1;
    public static final int SLICE_ORDER_DATA = 0;
    public static final int SLICE_ORDER_ASCENDING_CATEGORY = 1;
    public static final int SLICE_ORDER_DESCENDING_CATEGORY = 2;
    public static final int SLICE_ORDER_ASCENDING_STATISTIC = 3;
    public static final int SLICE_ORDER_DESCENDING_STATISTIC = 4;
    public static final int SLICE_ORDER_DESCENDING_STATISTIC_WITHIN_GROUP = 5;
    private static final int _DATA_LABEL_ = 10600;
    public static final int LABEL_AUTOMATIC = 10600;
    public static final int LABEL_NONE = 10601;
    public static final int LABEL_CATEGORY = 10602;
    public static final int LABEL_RESPONSE = 10603;
    public static final int LABEL_PERCENT = 10608;
    public static final int LABEL_CATEGORY_RESPONSE = 10609;
    public static final int LABEL_CATEGORY_PERCENT = 10610;
    public static final int LABEL_CATEGORY_RESPONSE_PERCENT = 10611;
    public static final int LABEL_RESPONSE_PERCENT = 10612;
    public static final int PLACEMENT_DEFAULT = 0;
    public static final int PLACEMENT_ARROW_JUSTIFIED = 1;
    public static final int PLACEMENT_LEFT = 2;
    public static final int PLACEMENT_RIGHT = 3;
    public static final int PLACEMENT_IF_FIT = 4;
    public static final int PLACEMENT_BEST = 5;
    public static final int PLACEMENT_NONE = 6;
    private static final DecimalFormat pctf = new DecimalFormat("##0.##%");
    protected DecimalFormat percentFormat = pctf;
    protected GTKPieChartRenderer renderer;
    protected int skinWidth;
    protected int skinHeight;

    public GTKAPie(ATransform transform) {
        super(transform);
        this.precision.setValue(16);
        this.radius.setValue(1.0);
        this.highlightFillColor.setValue(Color.yellow);
        this.highlightEdgeColor.setValue(Color.white);
        this.highlightOn.setValue(false);
        this.highlightPercentage.setValue(1.0);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
        this.startAngle = 0.0;
        this.sliceDirection = -1;
        this.sliceOrder = 0;
        this.insideLabelContent = 10601;
        this.outsideLabelContent = 10601;
        this.otherThresholdPct = 0.04;
        this.otherThresholdNum = -1;
        this.otherColor = Color.black;
        this.otherLabel = RB.getStringResource("otherLabel.txt");
        this.subgroupTitle = "";
        this.insideLabelStyle = new TextStyle();
        this.outsideLabelStyle = new TextStyle();
        this.donutSize = 0.0;
        this.donutLabelStyle = new TextStyle();
        this.subgroupLabelStyle = new TextStyle();
        this.subgroupTitleStyle = new TextStyle();
        this.responseTitleStyle = new TextStyle();
        this.donutLabel = "";
        this.invisibleArray = new String[0];
        this.explodeArray = new String[0];
        this.explodeAmount = 0.2;
        this.outsideLabelPlacement = 0;
        this.insideLabelPlacement = 0;
        this.subgroupLabelPlacement = 0;
        this.size = new Dimension(400, 300);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double rad = this.radius.getValue(index);
        size.set(rad * 2.0, rad * 2.0, 0.0);
        center.set(0.0, 0.0, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    public void setEdgeWidth(int aWidth) {
        if (aWidth >= 0) {
            this.outlineWidth = aWidth;
        }
    }

    public int getEdgeWidth() {
        return this.outlineWidth;
    }

    public void setStartAngle(double aStart) {
        this.startAngle = aStart;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setSliceDirection(int aDirection) {
        if (aDirection == -1 || aDirection == 1) {
            this.sliceDirection = aDirection;
        }
    }

    public int getSliceDirection() {
        return this.sliceDirection;
    }

    public void setSliceOrder(int anOrder) {
        switch (anOrder) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.sliceOrder = anOrder;
            }
        }
    }

    public int getSliceOrder() {
        return this.sliceOrder;
    }

    public void setOtherThresholdPct(double aThreshold) {
        if (aThreshold >= 0.0 && aThreshold <= 1.0) {
            this.otherThresholdPct = aThreshold;
        }
    }

    public double getOtherThresholdPct() {
        return this.otherThresholdPct;
    }

    public void setOtherThresholdNum(int aThreshold) {
        if (aThreshold >= 0) {
            this.otherThresholdNum = aThreshold;
        }
    }

    public int getOtherThresholdNum() {
        return this.otherThresholdNum;
    }

    public void setLabelStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.setInsideLabelStyle(aStyle);
            this.setOutsideLabelStyle(aStyle);
        }
    }

    public TextStyle getLabelStyle() {
        return this.outsideLabelStyle;
    }

    public void setInsideLabelStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.insideLabelStyle = aStyle;
        }
    }

    public TextStyle getInsideLabelStyle() {
        return this.insideLabelStyle;
    }

    public void setOutsideLabelStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.outsideLabelStyle = aStyle;
        }
    }

    public TextStyle getOutsideLabelStyle() {
        return this.outsideLabelStyle;
    }

    public void setOtherColor(Color aColor) {
        this.otherColor = aColor;
    }

    public Color getOtherColor() {
        return this.otherColor;
    }

    public void setOtherLabel(String aLabel) {
        if (aLabel != null) {
            this.otherLabel = aLabel;
        }
    }

    public String getOtherLabel() {
        return this.otherLabel;
    }

    public void setSubgroupTitle(String aLabel) {
        if (aLabel != null) {
            this.subgroupTitle = aLabel;
        }
    }

    public String getSubgroupTitle() {
        return this.subgroupTitle;
    }

    public int getOutsideLabelContent() {
        return this.outsideLabelContent;
    }

    public void setOutsideLabelContent(RendererUtil.DataLabel aContent) {
        this.setOutsideLabelContent(this.getDataLabelContent(aContent));
    }

    public void setOutsideLabelContent(int aContent) {
        if (aContent >= 0 && aContent <= 10619) {
            this.outsideLabelContent = aContent;
        }
    }

    public int getInsideLabelContent() {
        return this.insideLabelContent;
    }

    private int getDataLabelContent(RendererUtil.DataLabel label) {
        if (label == RendererUtil.DataLabel.CATEGORY) {
            return 10602;
        }
        if (label == RendererUtil.DataLabel.RESPONSE) {
            return 10603;
        }
        if (label == RendererUtil.DataLabel.PERCENT) {
            return 10608;
        }
        if (label == RendererUtil.DataLabel.CATEGORY_RESPONSE) {
            return 10609;
        }
        if (label == RendererUtil.DataLabel.CATEGORY_PERCENT) {
            return 10610;
        }
        if (label == RendererUtil.DataLabel.CATEGORY_RESPONSE_PERCENT) {
            return 10611;
        }
        if (label == RendererUtil.DataLabel.RESPONSE_PERCENT) {
            return 10612;
        }
        if (label == RendererUtil.DataLabel.AUTOMATIC) {
            return 10600;
        }
        return 10601;
    }

    public void setInsideLabelContent(RendererUtil.DataLabel aContent) {
        this.setInsideLabelContent(this.getDataLabelContent(aContent));
    }

    public void setInsideLabelContent(int aContent) {
        if (aContent >= 0 && aContent <= 10619) {
            this.insideLabelContent = aContent;
        }
    }

    public TextStyle getDonutLabelStyle() {
        return this.donutLabelStyle;
    }

    public TextStyle getSubgroupLabelStyle() {
        return this.subgroupLabelStyle;
    }

    public TextStyle getSubgroupTitleStyle() {
        return this.subgroupTitleStyle;
    }

    public String getDonutLabel() {
        return this.donutLabel;
    }

    public double getDonutSize() {
        return this.donutSize;
    }

    public void setDonutLabelStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.donutLabelStyle = aStyle;
        }
    }

    public void setSubgroupLabelStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.subgroupLabelStyle = aStyle;
        }
    }

    public void setSubgroupTitleStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.subgroupTitleStyle = aStyle;
        }
    }

    public void setDonutLabel(String aLabel) {
        if (aLabel != null) {
            this.donutLabel = aLabel;
        }
    }

    public void setDonutSize(double aSize) {
        if (aSize > 0.0 && aSize < 100.0) {
            this.donutSize = aSize;
        }
    }

    public String[] getExplodeArray() {
        return this.explodeArray;
    }

    public String[] getInvisibleArray() {
        return this.invisibleArray;
    }

    public void setExplodeArray(String[] explodeArray) {
        this.explodeArray = explodeArray;
    }

    public void setInvisibleArray(String[] invisibleArray) {
        this.invisibleArray = invisibleArray;
    }

    public int getInsideLabelPlacement() {
        return this.insideLabelPlacement;
    }

    public int getOutsideLabelPlacement() {
        return this.outsideLabelPlacement;
    }

    public int getSubgroupLabelPlacement() {
        return this.subgroupLabelPlacement;
    }

    public void setInsideLabelPlacement(int insideLabelMode) {
        this.insideLabelPlacement = insideLabelMode;
    }

    public void setOutsideLabelPlacement(int outsideLabelMode) {
        this.outsideLabelPlacement = outsideLabelMode;
    }

    public void setSubgroupLabelPlacement(int subgroupLabelPlacement) {
        this.subgroupLabelPlacement = subgroupLabelPlacement;
    }

    public boolean isTwoD() {
        return this.twoD;
    }

    public void setTwoD(boolean twoD) {
        this.twoD = twoD;
    }

    public void setTitleMarkerId(int id) {
        if (id >= 0) {
            this.titleMarkerId = id;
        }
    }

    public int getTitleMarkerId() {
        return this.titleMarkerId;
    }

    public void setTitleMarkerSize(int size) {
        if (size >= 0) {
            this.titleMarkerSize = size;
        }
    }

    public int getTitleMarkerSize() {
        return this.titleMarkerSize;
    }

    public void setTitleMarkerVisible(boolean visible) {
        this.titleMarkerVisible = visible;
    }

    public boolean isTitleMarkerVisible() {
        return this.titleMarkerVisible;
    }

    public void setShrinkableFonts(boolean shrink) {
        this.shrinkableFonts = shrink;
    }

    public boolean isShrinkableFonts() {
        return this.shrinkableFonts;
    }

    public void setSize(Dimension newSize) {
        if (this.size != null) {
            this.size = newSize;
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setResponseLabel(String newLabel) {
        if (this.responseLabel != null) {
            this.responseLabel = newLabel;
        }
    }

    public String getResponseLabel() {
        return this.responseLabel;
    }

    public void setResponseTitleStyle(TextStyle aStyle) {
        if (aStyle != null) {
            this.responseTitleStyle = aStyle;
        }
    }

    public TextStyle getResponseTitleStyle() {
        return this.responseTitleStyle;
    }

    public void setResponseTitleAdjustment(Point2D.Double aPoint) {
        if (aPoint != null) {
            this.responseTitleAdjustment = aPoint;
        }
    }

    public Point2D.Double getResponseTitleAdjustment() {
        return this.responseTitleAdjustment;
    }

    public Dimension getGridLayout() {
        return this.gridLayout;
    }

    public void setGridLayout(Dimension dim) {
        if (dim != null) {
            this.gridLayout = dim;
        }
    }

    public void setRingGap(double gap) {
        this.ringGap = gap;
    }

    public boolean isExplodingOtherSlice() {
        return this.explodeOtherSlice;
    }

    public void setExplodeOtherSice(boolean b) {
        this.explodeOtherSlice = b;
    }

    public void setPercentFormat(DecimalFormat df) {
        this.percentFormat = df;
    }

    public void setVisibleOtherSlice(boolean b) {
        this.otherSliceVisible = b;
    }

    public void setGroupGapDimension(RendererUtil.GroupGapDimension dim) {
        this.gapDimension = dim;
    }

    public void setRenderer(GTKPieChartRenderer renderer) {
        this.renderer = renderer;
    }

    public void setSkinWidth(int sw) {
        this.skinWidth = sw;
    }

    public void setSkinHeight(int sh) {
        this.skinHeight = sh;
    }
}

