/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;

public class FrequencyVariable
extends NumericVariable {
    FrequencyConnection connection = new FrequencyConnection();

    public FrequencyVariable() {
        this.connectFrom();
        this.setName("Frequency");
    }

    public void setDefaultFrequency(int defaultValue) {
        this.connection.setDefaultFrequency(defaultValue);
    }

    @Override
    public int getRawValueCount() {
        return this.connection.getValueCount();
    }

    @Override
    public boolean isRawValueMissing(int i) {
        return false;
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        super.connectFrom();
    }

    private static class FrequencyConnection
    implements NumericPipe {
        private int defaultValue = 0;

        private FrequencyConnection() {
        }

        public void setDefaultFrequency(int value) {
            this.defaultValue = value;
        }

        @Override
        public double getValue(int index) throws MissingValueException {
            return this.defaultValue;
        }

        public int getValueCount() {
            return -1;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(-1);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }
}

