/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.text.FormatDescription;
import com.sas.text.SASFormat;
import com.sas.text.SASUserDefinedFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Formatter {
    private GTKFormat format;
    private boolean isNumericSASUserDefinedFormat;
    private boolean isStringSASUserDefinedFormat;
    private Map valueToFormattedValue = new HashMap();
    public static Formatter defaultFormatter = new Formatter();

    public Formatter() {
        this.format = null;
    }

    public Formatter(GTKFormat format) {
        this.format = format;
        this.isNumericSASUserDefinedFormat = false;
        if (format != null) {
            Format f = format.getFormats()[0];
            this.isNumericSASUserDefinedFormat = false;
            this.isStringSASUserDefinedFormat = false;
            this.isNumericSASUserDefinedFormat = f instanceof SASUserDefinedFormat;
            if (this.isNumericSASUserDefinedFormat) {
                this.isStringSASUserDefinedFormat = ((SASFormat)f).getName().startsWith("$");
                this.isNumericSASUserDefinedFormat = !this.isStringSASUserDefinedFormat;
            }
        }
    }

    public Formatter getMaxWidthFormatter() {
        Format[] fmtArr = this.format.getFormats();
        Format fmt = fmtArr[0];
        if (!(fmt instanceof SASFormat)) {
            return this;
        }
        SASFormat originalSF = (SASFormat)fmt;
        FormatDescription fd = originalSF.getFormatDescription();
        if (fd.isDecimalWidthSupported()) {
            String baseFormat = originalSF.getBaseFormatName();
            int maxWidth = fd.getMaxWidth();
            Locale loc = originalSF.getLocale();
            int sfDecWidth = originalSF.getDecimalWidth();
            SASFormat newSF = SASFormat.getInstance((String)baseFormat, (int)maxWidth, (int)sfDecWidth, (Locale)loc);
            newSF.setInsertBlanks(false);
            GTKFormat newGTKFmt = new GTKFormat((Format)newSF);
            Formatter maxWidthFmtr = new Formatter(newGTKFmt);
            return maxWidthFmtr;
        }
        return this;
    }

    public String format(Object argument) {
        return this.doFormat(argument);
    }

    private String doFormat(Object argument) {
        String result = this.isNumericSASUserDefinedFormat ? this.format.format(argument) : (this.format == null ? (argument instanceof MissingValues ? ValueMap.getDefaultMissingValueLabel((MissingValues)argument) : argument.toString()) : (argument instanceof MissingValues ? (MissingValues._BLANK_.equals(argument) ? this.format.format(" ").trim() : ValueMap.getDefaultMissingValueLabel((MissingValues)argument)) : this.format.format(argument)));
        return result;
    }

    public String format(Object[] arguments) {
        String result;
        if (this.format != null) {
            result = this.format.format(arguments);
        } else {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < arguments.length; ++i) {
                str.append(arguments[i].toString());
                str.append(' ');
            }
            result = str.toString();
        }
        return result;
    }
}

