/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.util.NumericRangeSegment;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DiscreteRangeToNumericMap
extends NumericMap {
    protected double[] numericValues;
    protected double[] rangeValues;
    protected NumericRangeSegment[] rangeSegments;
    private Vector pipes = new Vector(4, 2);
    private boolean lowerExclude;
    private Hashtable table = new Hashtable(101, 0.85f);

    @Override
    public void init(AInitAction ia) {
        int i;
        if (ia.beenInitialized(this)) {
            return;
        }
        if (this.rangeSegments == null || this.rangeSegments.length == 0) {
            if (this.table != null && !this.table.isEmpty()) {
                this.createRangeSegments2();
            } else {
                if (this.rangeValues == null || this.numericValues == null) {
                    return;
                }
                this.createRangeSegments();
            }
        }
        this.sortRangeSegments();
        this.uniqueValueVector.setSize(this.rangeSegments.length);
        this.labelVector.setSize(this.rangeSegments.length);
        Formatter labelFormat = this.getOwnerFormatter();
        for (i = 0; i < this.rangeSegments.length; ++i) {
            String str = this.rangeSegments[i].getMin() == Double.NEGATIVE_INFINITY ? (this.rangeSegments[i].getMaxExclude() ? "   < " + labelFormat.format(new Double(this.rangeSegments[i].getMax())).trim() : "   <= " + labelFormat.format(new Double(this.rangeSegments[i].getMax())).trim()) : (this.rangeSegments[i].getMax() == Double.POSITIVE_INFINITY ? (this.rangeSegments[i].getMinExclude() ? "   > " + labelFormat.format(new Double(this.rangeSegments[i].getMin())).trim() : "   >= " + labelFormat.format(new Double(this.rangeSegments[i].getMin())).trim()) : this.formatRange(labelFormat, this.rangeSegments[i].getMin(), this.rangeSegments[i].getMax()));
            this.labelVector.setValueAt(str, i);
        }
        for (i = 0; i < this.rangeSegments.length; ++i) {
            this.uniqueValueVector.setValueAt((Double)this.rangeSegments[i].getValue(null), i);
        }
        if (this.isReplaceMissingValuesAny() && this.isLabelMissingValuesAny()) {
            int pipeCount = this.pipes.size();
            for (int pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                NumericPipe np = (NumericPipe)this.pipes.elementAt(pipeIndex);
                ia.setCategoryRequest(true);
                ia.pushValueCount();
                np.init(ia);
                ia.popValueCount();
                NumericVector nv = (NumericVector)ia.getUniqueValueVector();
                if (nv == null) continue;
                int count = nv.size();
                for (i = 0; i < count; ++i) {
                    try {
                        nv.getValue(i);
                        continue;
                    }
                    catch (MissingValueException e) {
                        MissingValues mv = e.getMissingValue();
                        if (!this.isLabelMissingValues(mv) || !this.isReplaceMissingValues(mv) || this.uniqueValueVector.contains(this.getMissingReplacement(mv))) continue;
                        this.labelVector.addValue(this.getMissingValueLabel(mv));
                        this.uniqueValueVector.addValue(this.getMissingReplacement(mv));
                    }
                }
            }
        }
    }

    public double getValue(int index, NumericPipe input) throws MissingValueException {
        double value = 0.0;
        try {
            value = input.getValue(index);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (this.isReplaceMissingValues(mv)) {
                return this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        int i = 0;
        boolean found = false;
        int low = 0;
        int high = this.rangeSegments.length - 1;
        int inRange = 0;
        while (low <= high && !found) {
            int middle = (low + high) / 2;
            inRange = this.rangeSegments[middle].inRange(value);
            if (inRange == -1) {
                high = middle - 1;
                continue;
            }
            if (inRange == 1) {
                low = middle + 1;
                continue;
            }
            found = true;
            i = middle;
        }
        if (!found) {
            throw new RuntimeException("The value " + value + " is not in any of the specified ranges.");
        }
        return (Double)this.rangeSegments[i].getValue(null);
    }

    @Override
    public double getOutputMin() {
        if (this.uniqueValueVector.size() != 0) {
            double min = Double.MAX_VALUE;
            for (int i = 0; i < this.uniqueValueVector.size(); ++i) {
                try {
                    min = Math.min(min, this.uniqueValueVector.getValue(i));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return min;
        }
        throw new Error("No values exist in the uniqueValueVector of the RangeToNumMapper, hence cannot give Output Min value");
    }

    @Override
    public double getOutputMax() {
        if (this.uniqueValueVector.size() != 0) {
            double max = Double.MIN_VALUE;
            for (int i = 0; i < this.uniqueValueVector.size(); ++i) {
                try {
                    max = Math.max(max, this.uniqueValueVector.getValue(i));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return max;
        }
        throw new Error("No values exist in the uniqueValueVector of the RangeToNumMapper, hence cannot give Output Min value");
    }

    public NumericRangeSegment[] getRangeSegments() {
        return this.rangeSegments;
    }

    public double[] getRangeValue() {
        return this.rangeValues;
    }

    public double[] getNumericValue() {
        return this.numericValues;
    }

    public void setRangeSegments(NumericRangeSegment[] rs) {
        this.rangeSegments = new NumericRangeSegment[rs.length];
        for (int i = 0; i < this.rangeSegments.length; ++i) {
            this.rangeSegments[i] = new NumericRangeSegment(rs[i].getMin(), rs[i].getMax(), rs[i].getMinExclude(), rs[i].getMaxExclude(), rs[i].getValue(null));
        }
    }

    public void setRangeValue(double[] value) {
        if (value.length == 0) {
            throw new Error("No numeric values specified for the Numeric array in the RangeToNumMapper.");
        }
        this.rangeValues = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.rangeValues[i] = value[i];
        }
        this.setModified();
    }

    public void setNumericValue(double[] value) {
        if (value.length == 0) {
            throw new Error("No numeric values specified for the Numeric array in the RangeToNumMapper.");
        }
        this.numericValues = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.numericValues[i] = value[i];
        }
        this.setModified();
    }

    public void setLowerExclude(boolean trueOrFalse) {
        this.lowerExclude = trueOrFalse;
    }

    public boolean isLowerExclude() {
        return this.lowerExclude;
    }

    public void addNumericPipe(NumericPipe pipe) {
        if (!this.pipes.contains(pipe)) {
            this.pipes.addElement(pipe);
            this.setModified();
        }
    }

    public void removeAllNumericPipes() {
        this.pipes.removeAllElements();
        this.setModified();
    }

    public void removeNumericPipe(NumericPipe pipe) {
        this.pipes.removeElement(pipe);
        this.setModified();
    }

    public int getNumericPipeCount() {
        return this.pipes.size();
    }

    public NumericPipe getNumericPipe(int i) {
        return (NumericPipe)this.pipes.elementAt(i);
    }

    @Override
    public void setReplaceMissingValues(boolean replace) {
        super.setReplaceMissingValues(replace);
    }

    @Override
    public void setReplaceMissingValues(boolean replace, MissingValues missingValue) {
        super.setReplaceMissingValues(replace, missingValue);
    }

    private String formatRange(Formatter labelFormat, double value1, double value2) {
        String result = null;
        result = value1 == value2 ? labelFormat.format(new Double(value1)) : labelFormat.format(new Double(value1)).trim() + " - " + labelFormat.format(new Double(value2)).trim();
        return result;
    }

    private void createRangeSegments() {
        block4: {
            block5: {
                block3: {
                    if (this.numericValues.length >= this.rangeValues.length) break block3;
                    this.rangeSegments = new NumericRangeSegment[this.numericValues.length];
                    for (int i = 0; i < this.numericValues.length; ++i) {
                        this.rangeSegments[i] = new NumericRangeSegment(this.rangeValues[i], this.rangeValues[i + 1], this.lowerExclude, !this.lowerExclude, (Object)new Double(this.numericValues[i]));
                    }
                    break block4;
                }
                if (this.numericValues.length != this.rangeValues.length) break block5;
                this.rangeSegments = new NumericRangeSegment[this.numericValues.length];
                this.rangeSegments[0] = new NumericRangeSegment(Double.NEGATIVE_INFINITY, this.rangeValues[0], false, !this.lowerExclude, (Object)new Double(this.numericValues[0]));
                for (int i = 1; i < this.numericValues.length; ++i) {
                    this.rangeSegments[i] = new NumericRangeSegment(this.rangeValues[i - 1], this.rangeValues[i], this.lowerExclude, !this.lowerExclude, (Object)new Double(this.numericValues[i]));
                }
                break block4;
            }
            if (this.numericValues.length <= this.rangeValues.length) break block4;
            this.rangeSegments = new NumericRangeSegment[this.rangeValues.length + 1];
            this.rangeSegments[0] = new NumericRangeSegment(Double.NEGATIVE_INFINITY, this.rangeValues[0], false, !this.lowerExclude, (Object)new Double(this.numericValues[0]));
            this.rangeSegments[this.rangeValues.length] = new NumericRangeSegment(this.rangeValues[this.rangeValues.length - 1], Double.POSITIVE_INFINITY, this.lowerExclude, false, (Object)new Double(this.numericValues[this.rangeValues.length]));
            for (int i = 1; i < this.rangeValues.length; ++i) {
                this.rangeSegments[i] = new NumericRangeSegment(this.rangeValues[i - 1], this.rangeValues[i], this.lowerExclude, !this.lowerExclude, (Object)new Double(this.numericValues[i]));
            }
        }
    }

    private void sortRangeSegments() {
        for (int pass = 1; pass < this.rangeSegments.length; ++pass) {
            for (int i = 0; i < this.rangeSegments.length - 1; ++i) {
                if (!(this.rangeSegments[i].getMin() > this.rangeSegments[i + 1].getMin()) && (this.rangeSegments[i].getMin() != this.rangeSegments[i + 1].getMin() || !(this.rangeSegments[i].getMax() > this.rangeSegments[i + 1].getMax()))) continue;
                NumericRangeSegment temp = this.rangeSegments[i];
                this.rangeSegments[i] = this.rangeSegments[i + 1];
                this.rangeSegments[i + 1] = temp;
            }
        }
    }

    public void add(double key, Number value) {
        if (!Double.isNaN(key) && value != null) {
            this.table.put(new Double(key), value);
            this.setModified();
        }
    }

    public void remove(double key) {
        this.table.remove(new Double(key));
        this.setModified();
    }

    public void removeAll() {
        this.table.clear();
        this.setModified();
    }

    private void createRangeSegments2() {
        int size = this.table.size();
        this.rangeSegments = new NumericRangeSegment[size];
        Enumeration keys = this.table.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            Object K = keys.nextElement();
            Object N = this.table.get(K);
            double k = (Double)K;
            this.rangeSegments[i] = new NumericRangeSegment(k, k, false, false, N);
            ++i;
        }
    }
}

