/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Barnes74;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericPipeSwitcher;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;
import java.util.HashMap;

public class DataGridder
extends PropertyContainer
implements Pipe {
    public static final int GRID_BY_BARNES74_INTERPOLATION = 0;
    public static final int GRID_BY_UNIQUE_VALUE = 1;
    private int gridAlgorithm = 0;
    private NumericVariable xVariable;
    private NumericVariable yVariable;
    private NumericVariable zVariable;
    private NumericVariable response2Variable;
    private final NumericPipeSwitcher outXSwitcher = new NumericPipeSwitcher();
    public final NumericPipe outX = this.outXSwitcher;
    private final NumericPipeSwitcher outYSwitcher = new NumericPipeSwitcher();
    public final NumericPipe outY = this.outYSwitcher;
    private final NumericPipeSwitcher outZSwitcher = new NumericPipeSwitcher();
    public final NumericPipe outZ = this.outZSwitcher;
    private final NumericPipeSwitcher outResponse2Switcher = new NumericPipeSwitcher();
    public final NumericPipe outResponse2 = this.outResponse2Switcher;
    private double[] xa;
    private double[] ya;
    private double[] za;
    private double[] aa;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private double minResponse2;
    private double maxResponse2;
    private Plane preferredGridPlane = Plane.XZ;
    private Plane gridPlane;
    private int preferredMajorGridCount = 20;
    private int preferredMinorGridCount = 20;
    private int majorGridCount;
    private int minorGridCount;
    private double[] gridMajor;
    private double[] gridMinor;
    private double[] gridResponse;
    private double[] gridResponse2;
    private int rawValueCount;
    private int valueCount;
    private boolean automaticGridDetectionEnabled = true;
    private HashMap tempIUVHashMap = new HashMap();
    private boolean inputGridded;

    public void setPreferredGridPlane(Plane plane) {
        if (plane == null) {
            throw new IllegalArgumentException("Preferred plane cannot be null.");
        }
        if (plane != Plane.XY && plane != Plane.XZ) {
            throw new IllegalArgumentException("Preferred plane currently supports Plane.XY or Plane.XZ");
        }
        this.preferredGridPlane = plane;
        this.setModified();
    }

    public Plane getPreferredGridPlane() {
        return this.preferredGridPlane;
    }

    public Plane getGridPlane() {
        this.init();
        return this.gridPlane;
    }

    public boolean isInputGridded() {
        this.init();
        return this.inputGridded;
    }

    public void setXVariable(NumericVariable variable) {
        this.xVariable = variable;
        this.setModified();
    }

    public NumericVariable getXVariable() {
        return this.xVariable;
    }

    public void setYVariable(NumericVariable variable) {
        this.yVariable = variable;
        this.setModified();
    }

    public NumericVariable getYVariable() {
        return this.yVariable;
    }

    public void setZVariable(NumericVariable variable) {
        this.zVariable = variable;
        this.setModified();
    }

    public NumericVariable getZVariable() {
        return this.zVariable;
    }

    public void setResponse2Variable(NumericVariable variable) {
        this.response2Variable = variable;
        this.setModified();
    }

    public NumericVariable getResponse2Variable() {
        return this.response2Variable;
    }

    public void setGriddingAlgorithm(int gridAlgorithm) {
        switch (gridAlgorithm) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal gridAlgorithm.");
            }
        }
        if (this.gridAlgorithm != gridAlgorithm) {
            this.setModified();
        }
        this.gridAlgorithm = gridAlgorithm;
    }

    public void setPreferredMajorGridCount(int count) {
        this.preferredMajorGridCount = count;
        this.setModified();
    }

    public int getPreferredMajorGridCount() {
        return this.preferredMajorGridCount;
    }

    public void setPreferredMinorGridCount(int count) {
        this.preferredMinorGridCount = count;
        this.setModified();
    }

    public int getPreferredMinorGridCount() {
        return this.preferredMajorGridCount;
    }

    @Override
    public void init(AInitAction initAction) {
        if (this.xVariable == null || this.yVariable == null || this.zVariable == null) {
            throw new IllegalStateException("DataGridder requires X, Y, Z input variables to be set.");
        }
        boolean beenInitialized = true;
        this.xVariable.value.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.yVariable.value.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.zVariable.value.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        if (this.response2Variable != null) {
            this.response2Variable.value.init(initAction);
            beenInitialized &= initAction.beenInitialized(this);
        }
        if (beenInitialized) {
            return;
        }
        this.rawValueCount = initAction.getValueCount();
        Plane rawGridPlane = null;
        if (this.isAutomaticGridDetectionEnabled()) {
            rawGridPlane = this.determineInputGridding();
        }
        this.inputGridded = false;
        if (rawGridPlane != null) {
            this.inputGridded = true;
            this.connectToPregriddedInput(rawGridPlane);
        } else {
            this.doGridding();
        }
    }

    private void connectToPregriddedInput(Plane rawGridPlane) {
        this.minX = this.xVariable.getMin();
        this.maxX = this.xVariable.getMax();
        this.minY = this.yVariable.getMin();
        this.maxY = this.yVariable.getMax();
        this.minZ = this.zVariable.getMin();
        this.maxZ = this.zVariable.getMax();
        this.outXSwitcher.connectFrom(this.xVariable.value);
        this.outYSwitcher.connectFrom(this.yVariable.value);
        this.outZSwitcher.connectFrom(this.zVariable.value);
        this.gridPlane = rawGridPlane;
        if (this.gridPlane == Plane.XY || this.gridPlane == Plane.XZ) {
            this.majorGridCount = this.xVariable.getUniqueValueCount();
        } else if (this.gridPlane == Plane.YX || this.gridPlane == Plane.YZ) {
            this.majorGridCount = this.yVariable.getUniqueValueCount();
        } else if (rawGridPlane == Plane.ZX || this.gridPlane == Plane.ZY) {
            this.majorGridCount = this.zVariable.getUniqueValueCount();
        } else {
            throw new IllegalStateException("Unknown grid plane.");
        }
        if (this.response2Variable != null) {
            this.minResponse2 = this.response2Variable.getMin();
            this.maxResponse2 = this.response2Variable.getMax();
            this.outResponse2Switcher.connectFrom(this.response2Variable.value);
        }
        this.valueCount = this.rawValueCount;
    }

    private void dump() {
        AInitAction ia = new AInitAction();
        this.outX.init(ia);
        int n = ia.getValueCount();
        System.out.println("ValueCount=" + n);
        for (int i = 0; i < n; ++i) {
            StringBuffer sb = new StringBuffer();
            try {
                sb.append("x=");
                double x = this.outX.getValue(i);
                sb.append(x);
            }
            catch (MissingValueException e) {
                sb.append(".");
            }
            try {
                sb.append(" y=");
                double y = this.outY.getValue(i);
                sb.append(y);
            }
            catch (MissingValueException e) {
                sb.append(".");
            }
            try {
                sb.append(" z=");
                double z = this.outZ.getValue(i);
                sb.append(z);
            }
            catch (MissingValueException e) {
                sb.append(".");
            }
            System.out.println(sb.toString());
        }
        System.out.println("ValueCount=" + n);
    }

    private void doGridding() {
        switch (this.gridAlgorithm) {
            case 0: {
                this.doBarnes74Gridding();
                break;
            }
            default: {
                this.doUniqueValueGridding();
            }
        }
    }

    private Plane determineInputGridding() {
        Plane result = null;
        if (this.rawValueCount > 0) {
            result = this.checkXMajor();
            if (result == null) {
                result = this.checkYMajor();
            } else if (result == null) {
                result = this.checkZMajor();
            }
        }
        return result;
    }

    private Plane checkXMajor() {
        int ixuvc;
        Plane result = null;
        int xuvc = this.xVariable.getUniqueValueCount();
        if (xuvc <= this.rawValueCount / 2 && (ixuvc = this.countInitialUniqueValues(this.xVariable, xuvc)) == xuvc) {
            int izuvc;
            int zuvc;
            int iyuvc;
            int yuvc = this.yVariable.getUniqueValueCount();
            if (this.rawValueCount % (xuvc * yuvc) == 0 && (iyuvc = this.countInitialUniqueValues(this.yVariable, xuvc)) == 1) {
                this.majorGridCount = xuvc;
                this.minorGridCount = yuvc;
                result = Plane.XY;
            }
            if (result == null && this.rawValueCount % (xuvc * (zuvc = this.zVariable.getUniqueValueCount())) == 0 && (izuvc = this.countInitialUniqueValues(this.zVariable, xuvc)) == 1) {
                this.majorGridCount = xuvc;
                this.minorGridCount = zuvc;
                result = Plane.XZ;
            }
        }
        return result;
    }

    private Plane checkYMajor() {
        int iyuvc;
        Plane result = null;
        int yuvc = this.yVariable.getUniqueValueCount();
        if (yuvc <= this.rawValueCount / 2 && yuvc == (iyuvc = this.countInitialUniqueValues(this.yVariable, yuvc))) {
            int izuvc;
            int zuvc;
            int ixuvc;
            int xuvc = this.xVariable.getUniqueValueCount();
            if (this.rawValueCount % (yuvc * xuvc) == 0 && (ixuvc = this.countInitialUniqueValues(this.xVariable, yuvc)) == 1) {
                this.majorGridCount = yuvc;
                this.minorGridCount = xuvc;
                result = Plane.YX;
            }
            if (result == null && this.rawValueCount % (yuvc * (zuvc = this.zVariable.getUniqueValueCount())) == 0 && (izuvc = this.countInitialUniqueValues(this.zVariable, yuvc)) == 1) {
                this.majorGridCount = yuvc;
                this.minorGridCount = zuvc;
                result = Plane.YZ;
            }
        }
        return result;
    }

    private Plane checkZMajor() {
        int izuvc;
        Plane result = null;
        int zuvc = this.zVariable.getUniqueValueCount();
        if (zuvc <= this.rawValueCount / 2 && zuvc == (izuvc = this.countInitialUniqueValues(this.zVariable, zuvc))) {
            int iyuvc;
            int yuvc;
            int ixuvc;
            int xuvc = this.xVariable.getUniqueValueCount();
            if (this.rawValueCount % (zuvc * xuvc) == 0 && (ixuvc = this.countInitialUniqueValues(this.xVariable, zuvc)) == 1) {
                this.majorGridCount = zuvc;
                this.minorGridCount = xuvc;
                result = Plane.ZX;
            }
            if (result == null && this.rawValueCount % (zuvc * (yuvc = this.yVariable.getUniqueValueCount())) == 0 && (iyuvc = this.countInitialUniqueValues(this.yVariable, zuvc)) == 1) {
                this.majorGridCount = zuvc;
                this.minorGridCount = yuvc;
                result = Plane.ZY;
            }
        }
        return result;
    }

    private int countInitialUniqueValues(NumericVariable nv, int maxIndex) {
        this.tempIUVHashMap.clear();
        for (int i = 0; i < maxIndex; ++i) {
            try {
                double d = nv.value.getValue(i);
                this.tempIUVHashMap.put(new Double(d), null);
                continue;
            }
            catch (MissingValueException e) {
                this.tempIUVHashMap.put(e.getMissingValue(), null);
            }
        }
        return this.tempIUVHashMap.size();
    }

    private void doUniqueValueGridding() {
        GriddedDataPipe z;
        GriddedDataPipe y;
        GriddedDataPipe x;
        double d;
        int i;
        NumericVariable responseVar;
        NumericVariable minorVar;
        NumericVariable majorVar;
        NumericVariable tempXvariable = new NumericVariable();
        NumericVariable tempYVariable = new NumericVariable();
        NumericVariable tempZVariable = new NumericVariable();
        tempXvariable.connectFrom(this.xVariable);
        tempXvariable.setUniqueValueSort(1);
        tempYVariable.connectFrom(this.zVariable);
        tempYVariable.setUniqueValueSort(1);
        tempZVariable.connectFrom(this.yVariable);
        if (this.preferredGridPlane == Plane.XY) {
            majorVar = tempXvariable;
            minorVar = tempYVariable;
            responseVar = tempZVariable;
        } else {
            majorVar = tempXvariable;
            minorVar = tempZVariable;
            responseVar = tempZVariable;
        }
        this.majorGridCount = majorVar.getUniqueValueCount();
        this.minorGridCount = minorVar.getUniqueValueCount();
        this.reallocGridArrays();
        for (i = 0; i < this.majorGridCount; ++i) {
            try {
                d = majorVar.uniqueValue.getValue(i);
            }
            catch (MissingValueException e) {
                d = Double.NaN;
            }
            this.gridMajor[i] = d;
        }
        for (i = 0; i < this.minorGridCount; ++i) {
            try {
                d = minorVar.uniqueValue.getValue(i);
            }
            catch (MissingValueException e) {
                d = Double.NaN;
            }
            this.gridMinor[i] = d;
        }
        this.valueCount = this.majorGridCount * this.minorGridCount;
        for (i = 0; i < this.valueCount; ++i) {
            this.gridResponse[i] = Double.NaN;
            if (this.response2Variable == null) continue;
            this.gridResponse2[i] = Double.NaN;
        }
        int majorIndex = -1;
        int minorIndex = -1;
        double d2 = Double.NaN;
        for (i = 0; i < this.rawValueCount; ++i) {
            try {
                majorIndex = tempXvariable.category.getValue(i);
                minorIndex = tempYVariable.category.getValue(i);
                d = responseVar.value.getValue(i);
                if (this.response2Variable != null) {
                    d2 = this.response2Variable.value.getValue(i);
                }
            }
            catch (MissingValueException e) {
                d = Double.NaN;
                d2 = Double.NaN;
            }
            this.gridResponse[majorIndex * this.minorGridCount + minorIndex] = d;
            if (this.response2Variable == null) continue;
            this.gridResponse2[majorIndex * this.minorGridCount + minorIndex] = d2;
        }
        if (this.preferredGridPlane == Plane.XY) {
            x = new GriddedDataPipe(this.gridMajor, this.xVariable.value, 0);
            y = new GriddedDataPipe(this.gridMinor, this.yVariable.value, 1);
            z = new GriddedDataPipe(this.gridResponse, this.zVariable.value, 2);
        } else {
            x = new GriddedDataPipe(this.gridMajor, this.xVariable.value, 0);
            y = new GriddedDataPipe(this.gridResponse, this.yVariable.value, 2);
            z = new GriddedDataPipe(this.gridMinor, this.zVariable.value, 1);
        }
        this.outXSwitcher.connectFrom(x);
        this.outYSwitcher.connectFrom(y);
        this.outZSwitcher.connectFrom(z);
    }

    private void doBarnes74Gridding() {
        this.majorGridCount = this.preferredMajorGridCount;
        this.minorGridCount = this.preferredMinorGridCount;
        this.gridPlane = this.preferredGridPlane;
        this.reallocGridArrays();
        this.valueCount = this.preferredMajorGridCount * this.preferredMinorGridCount;
        this.copyVertices(this.rawValueCount);
        this.createRegularGrid();
        if (this.gridPlane == Plane.XY) {
            Barnes74.grid((double[])this.xa, (double[])this.ya, (double[])this.za, (int)this.rawValueCount, (double[])this.gridResponse, (double[])this.gridMajor, (int)this.majorGridCount, (double[])this.gridMinor, (int)this.minorGridCount, (int)0, (int)0, (double)0.3, (double)0.8, (double)0.5, (boolean)true);
            if (this.response2Variable != null) {
                Barnes74.grid((double[])this.xa, (double[])this.ya, (double[])this.aa, (int)this.rawValueCount, (double[])this.gridResponse2, (double[])this.gridMajor, (int)this.majorGridCount, (double[])this.gridMinor, (int)this.minorGridCount, (int)0, (int)0, (double)0.3, (double)0.8, (double)0.5, (boolean)true);
            }
        } else {
            Barnes74.grid((double[])this.xa, (double[])this.za, (double[])this.ya, (int)this.rawValueCount, (double[])this.gridResponse, (double[])this.gridMajor, (int)this.majorGridCount, (double[])this.gridMinor, (int)this.minorGridCount, (int)0, (int)0, (double)0.3, (double)0.8, (double)0.5, (boolean)true);
            if (this.response2Variable != null) {
                Barnes74.grid((double[])this.xa, (double[])this.za, (double[])this.aa, (int)this.rawValueCount, (double[])this.gridResponse2, (double[])this.gridMajor, (int)this.majorGridCount, (double[])this.gridMinor, (int)this.minorGridCount, (int)0, (int)0, (double)0.3, (double)0.8, (double)0.5, (boolean)true);
            }
        }
        this.connectOutputPipes();
        this.updateResponseRangeAfterInterpolation();
    }

    private void updateResponseRangeAfterInterpolation() {
        int i;
        if (this.gridPlane == Plane.XY || this.gridPlane == Plane.YX) {
            this.minZ = Double.POSITIVE_INFINITY;
            this.maxZ = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.valueCount; ++i) {
                try {
                    double dv = this.outZ.getValue(i);
                    this.minZ = Math.min(this.minZ, dv);
                    this.maxZ = Math.max(this.maxZ, dv);
                    continue;
                }
                catch (MissingValueException dv) {
                    // empty catch block
                }
            }
        } else if (this.gridPlane == Plane.XZ || this.gridPlane == Plane.ZX) {
            this.minY = Double.POSITIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.valueCount; ++i) {
                try {
                    double dv = this.outY.getValue(i);
                    this.minY = Math.min(this.minY, dv);
                    this.maxY = Math.max(this.maxY, dv);
                    continue;
                }
                catch (MissingValueException dv) {
                    // empty catch block
                }
            }
        } else {
            this.minX = Double.POSITIVE_INFINITY;
            this.maxX = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.valueCount; ++i) {
                try {
                    double dv = this.outX.getValue(i);
                    this.minX = Math.min(this.minX, dv);
                    this.maxX = Math.max(this.maxX, dv);
                    continue;
                }
                catch (MissingValueException dv) {
                    // empty catch block
                }
            }
        }
        if (this.response2Variable != null) {
            this.minResponse2 = Double.POSITIVE_INFINITY;
            this.maxResponse2 = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.valueCount; ++i) {
                try {
                    double dv = this.outResponse2.getValue(i);
                    this.minResponse2 = Math.min(this.minResponse2, dv);
                    this.maxResponse2 = Math.max(this.maxResponse2, dv);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    private void reallocGridArrays() {
        this.gridMajor = new double[this.majorGridCount];
        this.gridMinor = new double[this.minorGridCount];
        this.gridResponse = new double[this.majorGridCount * this.minorGridCount];
        if (this.response2Variable != null) {
            this.gridResponse2 = new double[this.majorGridCount * this.minorGridCount];
        }
    }

    private void createRegularGrid() {
        int i;
        double step = (this.maxX - this.minX) / (double)(this.majorGridCount - 1);
        for (i = 0; i < this.majorGridCount; ++i) {
            this.gridMajor[i] = this.minX + (double)i * step;
        }
        if (this.gridPlane == Plane.XY) {
            step = (this.maxY - this.minY) / (double)(this.minorGridCount - 1);
            for (i = 0; i < this.minorGridCount; ++i) {
                this.gridMinor[i] = this.minY + (double)i * step;
            }
        } else {
            step = (this.maxZ - this.minZ) / (double)(this.minorGridCount - 1);
            for (i = 0; i < this.minorGridCount; ++i) {
                this.gridMinor[i] = this.minZ + (double)i * step;
            }
        }
    }

    private void connectOutputPipes() {
        GriddedDataPipe z;
        GriddedDataPipe y;
        GriddedDataPipe x = new GriddedDataPipe(this.gridMajor, this.xVariable.value, 0);
        if (this.gridPlane == Plane.XY) {
            y = new GriddedDataPipe(this.gridMinor, this.yVariable.value, 1);
            z = new GriddedDataPipe(this.gridResponse, this.zVariable.value, 2);
        } else {
            y = new GriddedDataPipe(this.gridResponse, this.yVariable.value, 2);
            z = new GriddedDataPipe(this.gridMinor, this.zVariable.value, 1);
        }
        this.outXSwitcher.connectFrom(x);
        this.outYSwitcher.connectFrom(y);
        this.outZSwitcher.connectFrom(z);
        if (this.response2Variable != null) {
            GriddedDataPipe a = new GriddedDataPipe(this.gridResponse2, this.response2Variable.value, 2);
            this.outResponse2Switcher.connectFrom(a);
        }
    }

    private void copyVertices(int vc) {
        this.xa = new double[vc];
        this.ya = new double[vc];
        this.za = new double[vc];
        if (this.response2Variable != null) {
            this.aa = new double[vc];
        }
        this.minResponse2 = Double.POSITIVE_INFINITY;
        this.minZ = Double.POSITIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxResponse2 = Double.NEGATIVE_INFINITY;
        this.maxZ = Double.NEGATIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vc; ++i) {
            double d;
            try {
                d = this.xVariable.value.getValue(i);
                if (d < this.minX) {
                    this.minX = d;
                }
                if (d > this.maxX) {
                    this.maxX = d;
                }
                this.xa[i] = d;
            }
            catch (MissingValueException e) {
                this.xa[i] = Double.NaN;
            }
            try {
                d = this.yVariable.value.getValue(i);
                if (d < this.minY) {
                    this.minY = d;
                }
                if (d > this.maxY) {
                    this.maxY = d;
                }
                this.ya[i] = d;
            }
            catch (MissingValueException e) {
                this.ya[i] = Double.NaN;
            }
            try {
                double d2 = this.zVariable.value.getValue(i);
                if (d2 < this.minZ) {
                    this.minZ = d2;
                }
                if (d2 > this.maxZ) {
                    this.maxZ = d2;
                }
                this.za[i] = d2;
            }
            catch (MissingValueException e) {
                this.za[i] = Double.NaN;
            }
            if (this.response2Variable == null) continue;
            try {
                double d3 = this.response2Variable.value.getValue(i);
                if (d3 < this.minResponse2) {
                    this.minResponse2 = d3;
                }
                if (d3 > this.maxResponse2) {
                    this.maxResponse2 = d3;
                }
                this.aa[i] = d3;
                continue;
            }
            catch (MissingValueException e) {
                this.aa[i] = Double.NaN;
            }
        }
    }

    private void init() {
        this.init(new AInitAction());
    }

    public double getXMax() {
        this.init();
        return this.maxX;
    }

    public double getXMin() {
        this.init();
        return this.minX;
    }

    public double getYMax() {
        this.init();
        return this.maxY;
    }

    public double getYMin() {
        this.init();
        return this.minY;
    }

    public double getZMax() {
        this.init();
        return this.maxZ;
    }

    public double getZMin() {
        this.init();
        return this.minZ;
    }

    public double getResponse2Max() {
        this.init();
        return this.maxResponse2;
    }

    public double getResponse2Min() {
        this.init();
        return this.minResponse2;
    }

    public int getMajorGridCount() {
        this.init();
        return this.majorGridCount;
    }

    public boolean isAutomaticGridDetectionEnabled() {
        return this.automaticGridDetectionEnabled;
    }

    public void setAutomaticGridDetectionEnabled(boolean enableAutoGridDetection) {
        this.automaticGridDetectionEnabled = enableAutoGridDetection;
    }

    private class GriddedDataPipe
    implements NumericPipe {
        public static final int MAJOR = 0;
        public static final int MINOR = 1;
        public static final int RESPONSE = 2;
        private double[] data;
        private NumericPipe originalDataPipe;
        private int indexType;

        public GriddedDataPipe(double[] data, NumericPipe originalDataPipe, int indexType) {
            this.data = data;
            this.originalDataPipe = originalDataPipe;
            this.indexType = indexType;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.pushValueCount();
            DataGridder.this.init();
            initAction.popValueCount();
            initAction.setValueCount(DataGridder.this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return this.originalDataPipe.getFormatter();
        }

        @Override
        public double getValue(int index) throws MissingValueException {
            double d;
            int majorIndex = index % DataGridder.this.majorGridCount;
            int minorIndex = DataGridder.this.minorGridCount - 1 - index / DataGridder.this.majorGridCount;
            int responseIndex = minorIndex * DataGridder.this.majorGridCount + majorIndex;
            switch (this.indexType) {
                case 0: {
                    d = this.data[index % DataGridder.this.majorGridCount];
                    break;
                }
                case 1: {
                    d = this.data[minorIndex];
                    break;
                }
                case 2: {
                    d = this.data[responseIndex];
                    break;
                }
                default: {
                    d = Double.NaN;
                }
            }
            if (Double.isNaN(d)) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return d;
        }
    }
}

