/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.SplitDateTime;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.text.SASFormat;

public class ContinuousTimeToNumericMap
extends ContinuousRangeToNumericMap {
    protected double[] majorTickValues;
    protected double[] minorTickValues;
    protected boolean splitDateTime;
    protected SplitDateTime splitDT;
    protected NumericVector uniqueMinorValueVector = new NumericVector();
    public final NumericPipe uniqueMinorValue = this.uniqueMinorValueVector;
    protected StringVector secondaryLabelVector = new StringVector();
    public final StringPipe secondaryLabel = this.secondaryLabelVector;

    @Override
    public void init(AInitAction ia) {
        double outSize;
        Object labelPattern = null;
        if (ia.beenInitialized(this)) {
            return;
        }
        Formatter labelFormat = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.secondaryLabelVector.removeAllValues();
        this.uniqueMinorValueVector.removeAllValues();
        double inSize = this.inMax - this.inMin;
        if (inSize == 0.0) {
            Debug.println((String)"Input range is zero. Using OutputMin value for all incoming data points.");
        }
        if ((outSize = this.outMax - this.outMin) == 0.0) {
            Debug.println((String)"Output range is zero. Using InputMin value for all incoming data points.");
        }
        if (this.majorTickValues == null) {
            return;
        }
        String[] shortLabels = null;
        String[] longLabels = null;
        if (this.splitDateTime) {
            if (this.splitDT == null) {
                this.splitDT = new SplitDateTime();
            }
            SASFormat fmt = this.getFormat() == null ? null : (SASFormat)this.getFormat().getFormats()[0];
            this.splitDT.splitDateTimeFormat(fmt);
            if (this.splitDT.isSplittable()) {
                shortLabels = this.splitDT.getShortTermLabels(this.majorTickValues);
                longLabels = this.splitDT.getLongTermLabels(this.majorTickValues);
            }
        }
        if (this.majorTickValues.length >= 2) {
            for (int i = 0; i < this.majorTickValues.length; ++i) {
                if (this.splitDateTime && this.splitDT.isSplittable()) {
                    this.labelVector.addValue(shortLabels[i]);
                    this.secondaryLabelVector.addValue(longLabels[i]);
                } else {
                    this.labelVector.addValue(labelFormat.format(new Double(this.majorTickValues[i])).trim());
                }
                this.uniqueValueVector.addValue(this.outMin + (this.majorTickValues[i] - this.inMin) / (this.inMax - this.inMin) * outSize + this.margin);
            }
        } else if (this.majorTickValues.length == 1) {
            if (this.splitDateTime && this.splitDT.isSplittable()) {
                this.labelVector.addValue((String)shortLabels[0]);
                this.secondaryLabelVector.addValue((String)longLabels[0]);
            } else {
                this.labelVector.addValue(labelFormat.format(new Double(this.majorTickValues[0])).trim());
            }
            if (this.inMin != this.inMax) {
                this.uniqueValueVector.addValue(this.outMin + (this.majorTickValues[0] - this.inMin) / (this.inMax - this.inMin) * outSize + this.margin);
            } else {
                double out;
                switch (this.zeroRangeOutput) {
                    default: {
                        out = this.outMin;
                        break;
                    }
                    case 1: {
                        out = this.outMax;
                        break;
                    }
                    case 2: {
                        out = 0.5 * (this.outMin + this.outMax);
                    }
                }
                this.uniqueValueVector.addValue(out + this.margin);
            }
        }
        if (this.minorTickValues != null) {
            for (int i = 0; i < this.minorTickValues.length; ++i) {
                this.uniqueMinorValueVector.addValue(this.outMin + (this.minorTickValues[i] - this.inMin) / (this.inMax - this.inMin) * outSize + this.margin);
            }
        }
    }

    @Override
    public int getLabelCount() {
        return this.labelVector.size();
    }

    public int getMinorTickCount() {
        return this.uniqueMinorValueVector.size();
    }

    public void setMajorTickValues(double[] values) {
        this.majorTickValues = values;
    }

    public double[] getMajorTickValues() {
        return this.majorTickValues;
    }

    public void setMinorTickValues(double[] values) {
        this.minorTickValues = values;
    }

    public double[] getMinorTickValues() {
        return this.minorTickValues;
    }

    public void setSplitDateTime(boolean split) {
        this.splitDateTime = split;
    }

    public boolean isSplitDateTime() {
        return this.splitDateTime;
    }
}

