/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;

public class ContinuousRangeToLogarithmicMap
extends ContinuousRangeToNumericMap {
    protected double base = 10.0;
    protected boolean extractScale = false;
    protected int maxMajorTickCount = -1;
    protected int minorTickCount = -1;
    protected double thresholdMin = 1.0;
    protected double thresholdMax = 1.0;
    protected boolean minorTickMarksOn = false;
    protected boolean uniformTickValues = false;
    protected double[] majorTickValues;
    protected double[] minorTickValues;
    protected double[] logTickValues;
    protected double logMin;
    protected double logMax;
    protected NumericVector uniqueMinorValueVector = new NumericVector();
    public final NumericPipe uniqueMinorValue = this.uniqueMinorValueVector;

    @Override
    public void init(AInitAction ia) {
        int i;
        double outSize;
        Object labelPattern = null;
        if (ia.beenInitialized(this)) {
            return;
        }
        Formatter labelFormat = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.uniqueMinorValueVector.removeAllValues();
        double inSize = this.inMax - this.inMin;
        if (inSize == 0.0) {
            Debug.println((String)"Input range is zero. Using OutputMin value for all incoming data points.");
        }
        if ((outSize = this.outMax - this.outMin) == 0.0) {
            Debug.println((String)"Output range is zero. Using InputMin value for all incoming data points.");
        }
        if (this.majorTickValues == null) {
            this.computeMajorTickValues();
        }
        if (this.majorTickValues == null) {
            return;
        }
        if (this.majorTickValues.length >= 2) {
            for (i = 0; i < this.majorTickValues.length; ++i) {
                if (this.isUniformTickValues()) {
                    this.labelVector.addValue(labelFormat.format(new Double(this.majorTickValues[i])).trim());
                    this.uniqueValueVector.addValue(this.outMin + (Math.log(this.majorTickValues[i]) / Math.log(this.base) - this.logMin) / (this.logMax - this.logMin) * outSize + this.margin);
                    continue;
                }
                if (this.extractScale) {
                    this.labelVector.addValue(labelFormat.format(new Double(this.logTickValues[i])).trim());
                } else if (this.isBaseE()) {
                    this.labelVector.addValue("e^" + String.valueOf((int)Math.round(this.logTickValues[i])));
                } else {
                    this.labelVector.addValue(labelFormat.format(new Double(this.majorTickValues[i])).trim());
                }
                this.uniqueValueVector.addValue(this.outMin + (this.logTickValues[i] - this.logMin) / (this.logMax - this.logMin) * outSize + this.margin);
            }
        } else if (this.majorTickValues.length == 1) {
            if (this.isUniformTickValues()) {
                this.labelVector.addValue(labelFormat.format(new Double(this.majorTickValues[0])).trim());
            } else if (this.extractScale) {
                this.labelVector.addValue(labelFormat.format(new Double(this.logTickValues[0])).trim());
            } else if (this.isBaseE()) {
                this.labelVector.addValue("e^" + String.valueOf((int)Math.round(this.logTickValues[0])));
            } else {
                this.labelVector.addValue(labelFormat.format(new Double(this.majorTickValues[0])).trim());
            }
            if (this.logMin != this.logMax) {
                if (this.isUniformTickValues()) {
                    this.uniqueValueVector.addValue(this.outMin + (Math.log(this.majorTickValues[0]) / Math.log(this.base) - this.logMin) / (this.logMax - this.logMin) * outSize + this.margin);
                } else {
                    this.uniqueValueVector.addValue(this.outMin + (this.logTickValues[0] - this.logMin) / (this.logMax - this.logMin) * outSize + this.margin);
                }
            } else {
                double out;
                switch (this.zeroRangeOutput) {
                    default: {
                        out = this.outMin;
                        break;
                    }
                    case 1: {
                        out = this.outMax;
                        break;
                    }
                    case 2: {
                        out = 0.5 * (this.outMin + this.outMax);
                    }
                }
                this.uniqueValueVector.addValue(out + this.margin);
            }
        }
        if (this.minorTickValues != null) {
            for (i = 0; i < this.minorTickValues.length; ++i) {
                this.uniqueMinorValueVector.addValue(this.outMin + (Math.log(this.minorTickValues[i]) / Math.log(this.base) - this.logMin) / (this.logMax - this.logMin) * outSize + this.margin);
            }
        }
    }

    @Override
    public double getValue(double input) {
        double mappedValue;
        if (input <= 0.0) {
            throw new IllegalArgumentException("Non-positive value for logarithm.");
        }
        double denominator = this.logMax - this.logMin;
        if (denominator == 0.0) {
            switch (this.zeroRangeOutput) {
                default: {
                    mappedValue = this.outMin;
                    break;
                }
                case 1: {
                    mappedValue = this.outMax;
                    break;
                }
                case 2: {
                    mappedValue = 0.5 * (this.outMin + this.outMax);
                    break;
                }
            }
        } else {
            input = Math.log(input) / Math.log(this.base);
            double normalizedValue = (input - this.logMin) / denominator;
            mappedValue = this.outMin + (this.outMax - this.outMin) * normalizedValue;
        }
        return mappedValue + this.margin;
    }

    @Override
    public double getInverseValue(double output) {
        double mappedValue;
        double denominator = this.outMax - this.outMin;
        output -= this.margin;
        if (denominator == 0.0) {
            mappedValue = this.logMin;
        } else {
            double normalizedValue = (output - this.outMin) / denominator;
            mappedValue = this.logMin + (this.logMax - this.logMin) * normalizedValue;
            mappedValue = Math.pow(this.base, mappedValue);
        }
        return mappedValue;
    }

    @Override
    public int getLabelCount() {
        return this.labelVector.size();
    }

    public int getMinorTickCount() {
        return this.uniqueMinorValueVector.size();
    }

    @Override
    public void setInputMin(double min) {
        if (min <= 0.0) {
            throw new IllegalArgumentException("Non-positive value for logarithm.");
        }
        this.logMin = Math.log(min) / Math.log(this.base);
        super.setInputMin(min);
    }

    @Override
    public void setInputMax(double max) {
        if (max <= 0.0) {
            throw new IllegalArgumentException("Non-positive value for logarithm.");
        }
        this.logMax = Math.log(max) / Math.log(this.base);
        super.setInputMax(max);
    }

    public void setBase(double aBase) {
        if (aBase <= 0.0) {
            throw new IllegalArgumentException("Non-positive value for logarithm base.");
        }
        this.base = aBase;
    }

    public double getBase() {
        return this.base;
    }

    public void setExtractScale(boolean extract) {
        this.extractScale = extract;
    }

    public boolean isExtractScale() {
        return this.extractScale;
    }

    public void setMaximumMajorTickCount(int n) {
        this.maxMajorTickCount = n;
    }

    public int getMaximumMajorTickCount() {
        return this.maxMajorTickCount;
    }

    public void setThresholdMin(double threshold) {
        this.thresholdMin = threshold;
    }

    public double getThresholdMin() {
        return this.thresholdMin;
    }

    public void setThresholdMax(double threshold) {
        this.thresholdMax = threshold;
    }

    public double getThresholdMax() {
        return this.thresholdMax;
    }

    public void setMajorTickValues(double[] values) {
        if (values == null) {
            return;
        }
        if (values.length == 0) {
            this.majorTickValues = values;
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] <= 0.0)) continue;
            throw new IllegalArgumentException("Non-positive value for logarithm.");
        }
        this.majorTickValues = values;
        int n = this.majorTickValues.length;
        this.inMin = Math.min(this.inMin, this.majorTickValues[0]);
        this.inMax = Math.max(this.inMax, this.majorTickValues[n - 1]);
        this.logMin = Math.log(this.inMin) / Math.log(this.base);
        this.logMax = Math.log(this.inMax) / Math.log(this.base);
        this.logTickValues = new double[n];
        for (int i = 0; i < n; ++i) {
            this.logTickValues[i] = Math.log(this.majorTickValues[i]) / Math.log(this.base);
        }
        if (this.minorTickMarksOn && this.areUniformLogExponents(this.logTickValues)) {
            ZxAxis.LogarithmTicks logObject = new ZxAxis.LogarithmTicks();
            logObject.min = this.inMin;
            logObject.max = this.inMax;
            logObject.logMin = this.logMin;
            logObject.logMax = this.logMax;
            logObject.tickValues = this.majorTickValues;
            logObject.logTickValues = this.logTickValues;
            ZxAxis.zlogaxis_minor_10((ZxAxis.LogarithmTicks)logObject, (int)this.minorTickCount);
            this.minorTickValues = logObject.minorTickValues;
        }
    }

    public double[] getMajorTickValues() {
        if (this.majorTickValues == null) {
            this.computeMajorTickValues();
        }
        return this.majorTickValues;
    }

    public void setMinorTickValues(double[] values) {
        if (values == null) {
            this.minorTickValues = null;
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] <= 0.0)) continue;
            throw new IllegalArgumentException("Non-positive value for logarithm.");
        }
        this.minorTickValues = values;
    }

    public double[] getMinorTickValues() {
        if (this.majorTickValues == null) {
            this.computeMajorTickValues();
        }
        return this.minorTickValues;
    }

    public void setMinorTickMarksOn(boolean on) {
        this.minorTickMarksOn = on;
    }

    public boolean isMinorTickMarksOn() {
        return this.minorTickMarksOn;
    }

    public void setMinorTickCountPerInterval(int n) {
        this.minorTickCount = n;
    }

    public int getMinorTickCountPerInterval() {
        return this.minorTickCount;
    }

    public void setUniformTickValues(boolean uniform) {
        this.uniformTickValues = uniform;
    }

    public boolean isUniformTickValues() {
        return this.uniformTickValues;
    }

    public void computeMajorTickValues() {
        ZxAxis.LogarithmTicks logObject = ZxAxis.zlogaxis((double)this.inMin, (double)this.inMax, (double)this.base, (int)this.maxMajorTickCount, (double)this.thresholdMin, (double)this.thresholdMax, (boolean)this.minorTickMarksOn, (int)this.minorTickCount, (boolean)this.isUniformTickValues());
        this.inMin = logObject.min;
        this.inMax = logObject.max;
        this.logMin = logObject.logMin;
        this.logMax = logObject.logMax;
        this.majorTickValues = logObject.tickValues;
        this.logTickValues = logObject.logTickValues;
        this.minorTickValues = logObject.minorTickValues;
    }

    private boolean isBaseE() {
        return Math.abs(this.base - Math.E) < 1.0E-6;
    }

    private boolean areUniformLogExponents(double[] exponents) {
        if (exponents.length < 2 || this.base != 10.0) {
            return false;
        }
        double inc = exponents[1] - exponents[0];
        for (int i = 1; i < exponents.length - 1; ++i) {
            if (!(Math.abs(exponents[i + 1] - exponents[i] - inc) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }
}

