/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ContinuousRangeToColorMap
extends ColorMap {
    protected int numofSpectrums = 0;
    protected double inMin = 0.0;
    protected double inMax = 1.0;
    protected Color outMin;
    protected Color outMax;
    protected Color outHighColor;
    protected Color outLowColor;
    protected int labelCount = 11;
    protected Vector spectrumVector = new Vector();
    protected Vector realVector = new Vector();
    protected double spectrumMin = Double.MAX_VALUE;
    protected double spectrumMax = -1.7976931348623157E308;
    private float[] tempRGBA = new float[4];
    private List inputPipes = new ArrayList();

    public ContinuousRangeToColorMap() {
        this.outMin = Color.white;
        this.outMax = Color.blue;
        this.outHighColor = Color.black;
        this.outLowColor = Color.black;
    }

    public void addInputPipe(NumericPipe pipe) {
        if (this.indexOfInputPipe(pipe) < 0) {
            this.inputPipes.add(new InputPipeInfo(pipe));
        }
    }

    private int indexOfInputPipe(NumericPipe pipe) {
        int result = -1;
        for (int i = 0; i < this.inputPipes.size(); ++i) {
            InputPipeInfo ipi = (InputPipeInfo)this.inputPipes.get(i);
            if (ipi.pipe != pipe) continue;
            result = i;
            break;
        }
        return result;
    }

    public void removeAllInputPipes() {
        this.inputPipes.clear();
    }

    private boolean missingValuesInInputStream() {
        int n = this.inputPipes.size();
        for (int i = 0; i < n; ++i) {
            InputPipeInfo ipi = (InputPipeInfo)this.inputPipes.get(i);
            for (int j = 0; j < ipi.valueCount; ++j) {
                try {
                    ipi.pipe.getValue(j);
                    continue;
                }
                catch (MissingValueException e) {
                    return true;
                }
            }
        }
        return false;
    }

    private void initInputPipes(AInitAction ia) {
        int n = this.inputPipes.size();
        for (int i = 0; i < n; ++i) {
            InputPipeInfo ipi = (InputPipeInfo)this.inputPipes.get(i);
            ia.pushValueCount();
            ipi.pipe.init(ia);
            ipi.valueCount = ia.getValueCount();
            if (ipi.valueCount == -1) {
                ipi.valueCount = 1;
            }
            ia.popValueCount();
        }
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        this.initInputPipes(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        Formatter labelFormat = this.getOwnerFormatter();
        if (this.missingValuesInInputStream()) {
            this.initMissingValueVectors();
        }
        this.labelVector.removeAllValues();
        this.uniqueValueVector.removeAllValues();
        if (this.labelCount > 0) {
            this.numofSpectrums = this.realVector.size() < this.spectrumVector.size() ? this.realVector.size() : this.spectrumVector.size();
            if (this.numofSpectrums == 0) {
                this.setColorSpectrum(this.inMin, this.inMax, this.outMin, this.outMax);
                this.numofSpectrums = this.spectrumVector.size();
            }
            for (int i = 0; i < this.numofSpectrums; ++i) {
                double value = (Double)this.realVector.elementAt(i);
                Color color = (Color)this.spectrumVector.elementAt(i);
                String s = labelFormat.format(new Double(value)).trim();
                this.labelVector.addValue(s);
                this.uniqueValueVector.addValue(color);
            }
        }
    }

    private float[] calculateRGB(Color minColor, int num, double incRed, double incGreen, double incBlue, double incAlpha) {
        float alpha;
        float blue;
        float green;
        float[] rgb = this.tempRGBA;
        float red = (float)((double)minColor.getRed() / 255.0 + (double)num * incRed);
        if (red < 0.0f) {
            red = 0.0f;
        }
        if (red > 1.0f) {
            red = 1.0f;
        }
        if ((green = (float)((double)minColor.getGreen() / 255.0 + (double)num * incGreen)) < 0.0f) {
            green = 0.0f;
        }
        if (green > 1.0f) {
            green = 1.0f;
        }
        if ((blue = (float)((double)minColor.getBlue() / 255.0 + (double)num * incBlue)) < 0.0f) {
            blue = 0.0f;
        }
        if (blue > 1.0f) {
            blue = 1.0f;
        }
        if ((alpha = (float)((double)minColor.getAlpha() / 255.0 + (double)num * incAlpha)) < 0.0f) {
            alpha = 0.0f;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        rgb[0] = red;
        rgb[1] = green;
        rgb[2] = blue;
        rgb[3] = alpha;
        return rgb;
    }

    public Color getValue(MissingValues missingValue) {
        return this.getMissingReplacement(missingValue);
    }

    public Color getValue(double value) {
        this.init(new AInitAction());
        return this.getValueImpl(value);
    }

    private Color getValueImpl(double value) {
        Color mappedValue = null;
        if (value < this.spectrumMin) {
            mappedValue = this.outLowColor;
        } else if (value > this.spectrumMax) {
            mappedValue = this.outHighColor;
        } else {
            for (int j = 0; j < this.numofSpectrums - 1; ++j) {
                double spectrumValue1 = (Double)this.realVector.elementAt(j);
                double spectrumValue2 = (Double)this.realVector.elementAt(j + 1);
                if (!(spectrumValue2 >= value) || !(value >= spectrumValue1)) continue;
                Color color1 = (Color)this.spectrumVector.elementAt(j);
                Color color2 = (Color)this.spectrumVector.elementAt(j + 1);
                mappedValue = this.calculateMappedValue(value, spectrumValue1, spectrumValue2, color1, color2);
                break;
            }
        }
        return mappedValue;
    }

    public Color getValue(int index, NumericPipe input) throws MissingValueException {
        double actualValue = 0.0;
        try {
            actualValue = input.getValue(index);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (this.isReplaceMissingValues(mv)) {
                return this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        return this.getValueImpl(actualValue);
    }

    private Color calculateMappedValue(double actualValue, double value1, double value2, Color color1, Color color2) {
        double denominator = value2 - value1;
        if (denominator == 0.0) {
            return color1;
        }
        double normalizedValue = (actualValue - value1) / denominator;
        double incRed = normalizedValue * (double)(color2.getRed() - color1.getRed()) / 255.0;
        double incGreen = normalizedValue * (double)(color2.getGreen() - color1.getGreen()) / 255.0;
        double incBlue = normalizedValue * (double)(color2.getBlue() - color1.getBlue()) / 255.0;
        double incAlpha = normalizedValue * (double)(color2.getAlpha() - color1.getAlpha()) / 255.0;
        float[] rgb = this.calculateRGB(color1, 1, incRed, incGreen, incBlue, incAlpha);
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
    }

    public void setColorSpectrum(double value1, double value2, Color color1, Color color2) {
        this.setColorSpectrumValues(new double[]{value1, value2});
        this.setColorSpectrumColors(new Color[]{color1, color2});
    }

    public void setColorSpectrum(Double value1, Double value2, Color color1, Color color2) {
        this.setColorSpectrum((double)value1, (double)value2, color1, color2);
    }

    public void setColorSpectrumValues(double[] values) {
        if (this.realVector.size() != 0) {
            this.realVector.removeAllElements();
        }
        this.spectrumMin = values[0];
        this.spectrumMax = values[values.length - 1];
        this.setInputMin(this.spectrumMin);
        this.setInputMax(this.spectrumMax);
        for (int i = 0; i < values.length; ++i) {
            this.realVector.insertElementAt(new Double(values[i]), i);
        }
        this.setModified();
    }

    public void setColorSpectrumColors(Color[] colors) {
        if (this.spectrumVector.size() != 0) {
            this.spectrumVector.removeAllElements();
        }
        for (int i = 0; i < colors.length; ++i) {
            this.spectrumVector.insertElementAt(colors[i], i);
        }
        this.setModified();
    }

    public double[] getColorSpectrumValues() {
        double[] values = null;
        if (this.realVector.size() > 0) {
            values = new double[this.realVector.size()];
            for (int i = 0; i < this.realVector.size(); ++i) {
                values[i] = (Double)this.realVector.elementAt(i);
            }
        }
        return values;
    }

    public Color[] getColorSpectrumColors() {
        Color[] colors = null;
        if (this.spectrumVector.size() > 0) {
            colors = new Color[this.spectrumVector.size()];
            for (int i = 0; i < this.spectrumVector.size(); ++i) {
                colors[i] = (Color)this.spectrumVector.elementAt(i);
            }
        }
        return colors;
    }

    public void setOutOfRangeHighColor(Color color) {
        if (color != null) {
            this.outHighColor = color;
            this.setModified();
        }
    }

    public Color getOutOfRangeHighColor() {
        return this.outHighColor;
    }

    public void setOutOfRangeLowColor(Color color) {
        if (color != null) {
            this.outLowColor = color;
            this.setModified();
        }
    }

    public Color getOutOfRangeLowColor() {
        return this.outLowColor;
    }

    public void setOutOfRangeColor(Color color) {
        this.setOutOfRangeHighColor(color);
        this.setOutOfRangeLowColor(color);
    }

    public Color getOutOfRangeColor() {
        return this.getOutOfRangeLowColor();
    }

    public double getInputMin() {
        return this.inMin;
    }

    public void setInputMin(double min) {
        if (!Double.isNaN(min)) {
            this.inMin = min;
            this.setModified();
        }
    }

    public double getInputMax() {
        return this.inMax;
    }

    public void setInputMax(double max) {
        if (!Double.isNaN(max)) {
            this.inMax = max;
            this.setModified();
        }
    }

    public Color getOutputMin() {
        return this.outMin;
    }

    public void setOutputMin(Color min) {
        if (min != null) {
            this.outMin = min;
            this.setModified();
        }
    }

    public Color getOutputMax() {
        return this.outMax;
    }

    public void setOutputMax(Color max) {
        if (max != null) {
            this.outMax = max;
            this.setModified();
        }
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public void setLabelCount(int n) {
        if (n >= 0) {
            this.labelCount = n;
            this.setModified();
        }
    }

    private static class InputPipeInfo {
        public NumericPipe pipe;
        public int valueCount;

        public InputPipeInfo(NumericPipe pipe) {
            this.pipe = pipe;
        }
    }
}

