/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Property;
import com.sas.graphics.util.gtk.PropertyContainer;
import java.awt.Color;

public class ColorProperty
extends Property
implements ColorPipe {
    private static final Color defaultColor = new Color(0.2f, 0.2f, 0.2f);
    private Color color = defaultColor;
    private ColorPipe pipe;

    public ColorProperty() {
    }

    public ColorProperty(PropertyContainer aContainer, boolean initByContainer) {
        super(aContainer, initByContainer);
        this.pipe = null;
    }

    public static Color getDefaultColor() {
        return defaultColor;
    }

    @Override
    protected Pipe getPipe() {
        return this.pipe;
    }

    public void connectFrom(ColorPipe aPipe) {
        if (aPipe == null) {
            throw new IllegalArgumentException("Attempt to connect a null pipe.");
        }
        this.pipe = aPipe;
        this.setModified();
    }

    @Override
    public void disconnect() {
        this.pipe = null;
        this.setModified();
    }

    public ColorPipe getConnection() {
        return this.pipe;
    }

    @Override
    public Color getValue(int index) throws MissingValueException {
        if (this.pipe != null) {
            return this.pipe.getValue(index);
        }
        if (this.color == null) {
            throw MissingValueException.getDefaultMissingValueExeption();
        }
        return this.color;
    }

    public void setValue(Color aColor) {
        this.disconnect();
        this.color = aColor;
        this.setModified();
    }

    public Color getValue() {
        return this.color;
    }
}

