/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.MissingValueException;
import java.awt.Color;

public class ColorIterater
extends ColorVector {
    private int colorIndex = 0;

    public ColorIterater() {
    }

    public ColorIterater(Color[] clist) {
        for (int i = 0; i < clist.length; ++i) {
            this.addValue(clist[i]);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        if (this.owner != null) {
            this.owner.init(initAction);
        }
        initAction.popValueCount();
        initAction.setValueCount(-1);
        this.colorIndex = 0;
    }

    @Override
    public void reset(AResetAction resetAction) {
        if (this.owner != null) {
            this.owner.reset(resetAction);
        }
        this.colorIndex = 0;
    }

    @Override
    public Color getValue(int index) throws MissingValueException {
        Color result;
        if (!this.isEmpty()) {
            if (this.colorIndex >= this.size()) {
                this.colorIndex = 0;
            }
            result = super.getValue(this.colorIndex);
            ++this.colorIndex;
        } else {
            result = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        }
        return result;
    }

    public void setColors(Color[] clist) {
        this.removeAllValues();
        this.colorIndex = 0;
        for (int i = 0; i < clist.length; ++i) {
            this.addValue(clist[i]);
        }
    }
}

