/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PropertyContainer;
import java.awt.Color;

public class ColorCache
extends PropertyContainer
implements ColorPipe {
    private ColorPipe cachePipe;
    private ColorVector cache = new ColorVector();
    public final ColorProperty input = new ColorProperty(this, true);
    public final ColorPipe value = this;

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        if (initAction.beenInitialized(this)) {
            return;
        }
        int n = initAction.getValueCount();
        if (n == -1) {
            this.cachePipe = this.input;
        } else {
            this.cache.setSize(n);
            for (int i = 0; i < n; ++i) {
                try {
                    Color c = this.input.getValue(i);
                    this.cache.setValueAt(c, i);
                    continue;
                }
                catch (MissingValueException e) {
                    this.cache.setValueAt(e.getMissingValue(), i);
                }
            }
            this.cachePipe = this.cache;
        }
    }

    @Override
    public Color getValue(int index) throws MissingValueException {
        return this.cachePipe.getValue(index);
    }
}

