/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PrimitiveVector;

public class BooleanVector
extends PrimitiveVector
implements BooleanPipe {
    public final BooleanPipe value = this;

    public BooleanVector() {
        super(20, 10);
    }

    public BooleanVector(int initialCapacity) {
        super(initialCapacity, 10);
    }

    public BooleanVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    @Override
    public boolean getValue(int index) throws MissingValueException {
        return this.doubleToBoolean(this.get(index));
    }

    public void insertValueAt(boolean value, int index) {
        this.insert(this.booleanToDouble(value), index);
    }

    public void addValue(boolean value) {
        this.add(this.booleanToDouble(value));
    }

    public void setValueAt(boolean value, int index) {
        this.set(this.booleanToDouble(value), index);
    }

    public boolean removeValue(boolean value) {
        return this.remove(this.booleanToDouble(value));
    }

    public boolean contains(boolean value) {
        return this.contains(this.booleanToDouble(value));
    }

    public boolean getFirstValue() throws MissingValueException {
        return this.getValue(0);
    }

    public int getIndexOf(boolean value) {
        return this.indexOf(this.booleanToDouble(value), 0);
    }

    public int getIndexOf(boolean value, int startIndex) {
        return this.indexOf(this.booleanToDouble(value), startIndex);
    }

    public int getLastIndexOf(boolean value) {
        return this.lastIndexOf(this.booleanToDouble(value), this.size() - 1);
    }

    public int getLastIndexOf(boolean value, int startIndex) {
        return this.lastIndexOf(this.booleanToDouble(value), startIndex);
    }

    public boolean getLastValue() throws MissingValueException {
        return this.getValue(this.size() - 1);
    }

    private double booleanToDouble(boolean v) {
        return v ? 1.0 : 0.0;
    }

    private boolean doubleToBoolean(double v) {
        return (int)v > 0;
    }
}

