/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BarClusterer
extends PropertyContainer
implements NumericPipe {
    public final StringProperty category = new StringProperty(this, true);
    public final StringProperty subgroup = new StringProperty(this, true);
    public final NumericProperty inputCategoryPosition = new NumericProperty(this, true);
    public final NumericProperty response = new NumericProperty(this, true);
    public final NumericPipe outputCategoryPosition = this;
    public final BooleanProperty verticalOn = new BooleanProperty(this, true);
    private double barThickness = 0.0;
    private int maxClusterCount = 0;
    private HashMap catMap = new HashMap();

    public int getMaxSubgroupCountPerCategory() {
        this.init(new AInitAction());
        return this.maxClusterCount;
    }

    public double getBarThickness() {
        return this.barThickness;
    }

    public void setBarThickness(double barThickness) {
        this.barThickness = barThickness;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        String c = this.category.getValue(index);
        String s = this.subgroup.getValue(index);
        double p = this.inputCategoryPosition.getValue(index);
        this.response.getValue(index);
        List subList = (List)this.catMap.get(c);
        if (subList == null) {
            throw new InternalError();
        }
        int clusterCount = subList.size();
        int clusterIndex = subList.indexOf(s);
        if (clusterIndex < 0) {
            throw new InternalError();
        }
        boolean vo = this.verticalOn.getValue(index);
        double clusterSpan = this.barThickness * (double)(clusterCount - 1);
        double outPosition = vo ? p - clusterSpan / 2.0 + (double)clusterIndex * this.barThickness : p + clusterSpan / 2.0 - (double)clusterIndex * this.barThickness;
        return outPosition;
    }

    @Override
    public Formatter getFormatter() {
        return this.inputCategoryPosition.getFormatter();
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        if (!initAction.beenInitialized(this)) {
            this.catMap.clear();
            this.maxClusterCount = 0;
            int vc = initAction.getValueCount();
            for (int i = 0; i < vc; ++i) {
                try {
                    String c = this.category.getValue(i);
                    String s = this.subgroup.getValue(i);
                    this.inputCategoryPosition.getValue(i);
                    this.response.getValue(i);
                    ArrayList<String> subList = (ArrayList<String>)this.catMap.get(c);
                    if (subList == null) {
                        subList = new ArrayList<String>();
                        this.catMap.put(c, subList);
                    }
                    subList.add(s);
                    if (subList.size() <= this.maxClusterCount) continue;
                    this.maxClusterCount = subList.size();
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        this.inputCategoryPosition.reset(resetAction);
    }
}

