/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericAnimationVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringAnimationVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AnimationProcessor {
    private static final String CONSTANT_ANIMATION_ID = "constantAnimationID";
    private List tempValueIndices = new ArrayList();
    private Map keyFrameToIndexList;
    private Variable animationVariable;
    private Variable animationIdVariable;
    private Object byGroup1;
    private Object byGroup2;
    private Object lastByGroup1;
    private Object lastByGroup2;
    private int lastByGroup1IndexCount = 0;
    private double interpolationPercentage = 0.0;
    private ArrayList valueIndexToByGroupPair = new ArrayList();
    private boolean frameModified = false;
    private boolean idsSorted;
    private IndexIDComparator indexIDComparator = new IndexIDComparator();

    AnimationProcessor() {
    }

    void setAnimationFrame(Object byGroup1, Object byGroup2, double interpolationPercentage) {
        this.byGroup1 = byGroup1;
        this.byGroup2 = byGroup2;
        this.interpolationPercentage = interpolationPercentage;
        this.frameModified = true;
    }

    void animationFrameUpdate(List allVariables) {
        if (this.frameModified) {
            if (this.byGroup1 != this.lastByGroup1 || this.byGroup2 != this.lastByGroup2) {
                this.lastByGroup1 = this.byGroup1;
                this.lastByGroup2 = this.byGroup2;
                List byGroup1Index = (List)this.keyFrameToIndexList.get(this.byGroup1);
                List byGroup2Index = (List)this.keyFrameToIndexList.get(this.byGroup2);
                int byGroup1IndexCount = 0;
                this.lastByGroup1IndexCount = 0;
                if (byGroup1Index != null) {
                    this.lastByGroup1IndexCount = byGroup1IndexCount = byGroup1Index.size();
                    int n = byGroup1Index.size();
                    block0: for (int i = 0; i < n; ++i) {
                        int[] pair;
                        if (this.valueIndexToByGroupPair.size() <= i) {
                            pair = new int[]{-1, -1};
                            this.valueIndexToByGroupPair.add(pair);
                        } else {
                            pair = (int[])this.valueIndexToByGroupPair.get(i);
                            pair[0] = -1;
                            pair[1] = -1;
                        }
                        pair[0] = (Integer)byGroup1Index.get(i);
                        Object id1 = this.getUnByGroupedAnimationValue(pair[0], this.animationIdVariable);
                        if (byGroup2Index == null) continue;
                        int temp = -1;
                        Object id2 = null;
                        if (i < byGroup2Index.size()) {
                            temp = (Integer)byGroup2Index.get(i);
                            id2 = this.getUnByGroupedAnimationValue(temp, this.animationIdVariable);
                        }
                        if (id2 != null && id1.equals(id2)) {
                            pair[1] = temp;
                            continue;
                        }
                        if (this.idsSorted) {
                            temp = Collections.binarySearch(byGroup2Index, id1, this.indexIDComparator);
                            if (temp < 0) continue;
                            pair[1] = (Integer)byGroup2Index.get(temp);
                            continue;
                        }
                        int n2 = byGroup2Index.size();
                        for (int j = 0; j < n2; ++j) {
                            temp = (Integer)byGroup2Index.get(j);
                            id2 = this.getUnByGroupedAnimationValue(temp, this.animationIdVariable);
                            if (!id1.equals(id2)) continue;
                            pair[1] = temp;
                            continue block0;
                        }
                    }
                }
            }
            int n = allVariables.size();
            for (int i = 0; i < n; ++i) {
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)allVariables.get(i);
                if (ve.variable instanceof NumericAnimationVariable) {
                    NumericAnimationVariable nv = (NumericAnimationVariable)ve.variable;
                    nv.setFrame(this.valueIndexToByGroupPair, this.lastByGroup1IndexCount, this.interpolationPercentage);
                    nv.setProcessedValueCount(this.lastByGroup1IndexCount);
                    continue;
                }
                if (!(ve.variable instanceof StringAnimationVariable)) continue;
                StringAnimationVariable sv = (StringAnimationVariable)ve.variable;
                sv.setFrame(this.valueIndexToByGroupPair, this.lastByGroup1IndexCount, this.interpolationPercentage);
                sv.setProcessedValueCount(this.lastByGroup1IndexCount);
            }
            this.frameModified = false;
        }
    }

    private List getGroupToIndex(Map groupToIndex, Object byGroup) {
        List l = (List)this._getGroupToIndex(groupToIndex, byGroup);
        return l;
    }

    private Object _getGroupToIndex(Map groupToIndex, Object byGroup) {
        Object o = groupToIndex.get(byGroup);
        if (o instanceof List) {
            return o;
        }
        return this._getGroupToIndex((Map)o, byGroup);
    }

    public void setKeyFrameVariable(Variable v) {
        this.animationVariable = v;
    }

    public Variable getAnimationVariable() {
        return this.animationVariable;
    }

    public void setIdentificationVariable(Variable v) {
        this.animationIdVariable = v;
    }

    public Variable getAnimationIdVariable() {
        return this.animationIdVariable;
    }

    private Object getUnByGroupedAnimationValue(int i, Variable v) {
        Object result = CONSTANT_ANIMATION_ID;
        if (v != null) {
            try {
                if (v instanceof NumericVariable) {
                    double d = ((NumericVariable)v.getConnection()).value.getValue(i);
                    result = new Double(d);
                } else {
                    result = ((StringVariable)v.getConnection()).value.getValue(i);
                }
            }
            catch (MissingValueException e) {
                result = e.getMissingValue();
            }
        }
        return result;
    }

    private Object getAnimationValue(int i, Variable v) {
        Object result = CONSTANT_ANIMATION_ID;
        if (v != null) {
            try {
                if (v instanceof NumericVariable) {
                    double d = ((NumericVariable)v).value.getValue(i);
                    result = new Double(d);
                } else {
                    result = ((StringVariable)v).value.getValue(i);
                }
            }
            catch (MissingValueException e) {
                result = e.getMissingValue();
            }
        }
        return result;
    }

    private void verifyVariables(List allVariables) {
        int n = allVariables.size();
        for (int i = 0; i < n; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)allVariables.get(i);
            Variable v = ve.variable;
            if (v instanceof StringAnimationVariable || v instanceof NumericAnimationVariable) continue;
            throw new IllegalStateException("Animation VariableProcessor can only contain StringAnimationVariable or NumericAnimationVariable");
        }
    }

    public int process(List allVariables, int aValueCount) {
        if (!this.isAnimationEnabled()) {
            return aValueCount;
        }
        this.verifyVariables(allVariables);
        this.lastByGroup1 = null;
        this.lastByGroup2 = null;
        int vc = this.animationVariable.getRawValueCount();
        Object firstByGroup = this.byGroup1;
        Object secondByGroup = this.byGroup2;
        if (this.keyFrameToIndexList == null) {
            this.keyFrameToIndexList = new HashMap();
        } else {
            this.keyFrameToIndexList.clear();
        }
        for (int i = 0; i < vc; ++i) {
            Object keyFrame = this.getUnByGroupedAnimationValue(i, this.animationVariable);
            ArrayList<Integer> indices = (ArrayList<Integer>)this.keyFrameToIndexList.get(keyFrame);
            if (indices == null) {
                if (firstByGroup == null) {
                    firstByGroup = keyFrame;
                } else if (secondByGroup == null) {
                    secondByGroup = keyFrame;
                }
                indices = new ArrayList<Integer>();
                this.keyFrameToIndexList.put(keyFrame, indices);
            }
            indices.add(new Integer(i));
            if (this.animationIdVariable != null || indices.size() <= 1) continue;
            throw new IllegalStateException("Error in animation settings.  There is no animationIdentificationVariable but there is more than one observation per animationKeyFrame.");
        }
        this.idsSorted = false;
        if (this.getAnimationIdVariable() != null && this.getAnimationIdVariable() instanceof StringVariable) {
            this.idsSorted = true;
            Collection c = this.keyFrameToIndexList.values();
            for (List l : c) {
                Collections.sort(l, this.indexIDComparator);
            }
        }
        this.setAnimationFrame(firstByGroup, secondByGroup, this.interpolationPercentage);
        this.animationFrameUpdate(allVariables);
        return 0;
    }

    public List getValueIndices(int valueIndex) {
        this.tempValueIndices.clear();
        Object id = this.getAnimationValue(valueIndex, this.animationIdVariable);
        Collection c = this.keyFrameToIndexList.values();
        for (List indices : c) {
            int n = indices.size();
            for (int i = 0; i < n; ++i) {
                int vi = (Integer)indices.get(i);
                Object testId = this.getUnByGroupedAnimationValue(vi, this.getAnimationIdVariable());
                if (!id.equals(testId)) continue;
                this.tempValueIndices.add(new Integer(vi));
            }
        }
        return this.tempValueIndices;
    }

    public boolean isAnimationEnabled() {
        return this.animationVariable != null;
    }

    private class IndexIDComparator
    implements Comparator {
        private IndexIDComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                Integer i1 = (Integer)o1;
                o1 = AnimationProcessor.this.getUnByGroupedAnimationValue(i1, AnimationProcessor.this.animationIdVariable);
            }
            if (o2 instanceof Integer) {
                Integer i2 = (Integer)o2;
                o2 = AnimationProcessor.this.getUnByGroupedAnimationValue(i2, AnimationProcessor.this.animationIdVariable);
            }
            int result = ((String)o1).compareTo((String)o2);
            return result;
        }
    }
}

