/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import java.util.List;

abstract class AnimationConnection
implements Pipe {
    private List valueIndexToByGroupPair;
    private double interpolationPercentage;
    private int valueCount = 0;
    private Variable animationIdVariable;
    private Variable connection;
    private Variable variable;
    private AInitAction tempAction = new AInitAction();

    public AnimationConnection(Variable variable) {
        this.variable = variable;
    }

    public void setAnimationIdVariable(Variable v) {
        this.animationIdVariable = v;
    }

    public static Object getAnimationIdValue(int i, Variable v) {
        Object result;
        try {
            if (v instanceof NumericVariable) {
                double d = ((NumericVariable)v).value.getValue(i);
                result = new Integer((int)d);
            } else {
                result = ((StringVariable)v).value.getValue(i);
            }
        }
        catch (MissingValueException e) {
            result = e.getMissingValue();
        }
        return result;
    }

    public Object getAnimationIdValue(int i) {
        return AnimationConnection.getAnimationIdValue(i, this.animationIdVariable);
    }

    protected void setConnection(Variable v) {
        this.connection = v;
    }

    protected NumericVariable getNumericConnection() {
        return (NumericVariable)this.connection;
    }

    protected StringVariable getStringConnection() {
        return (StringVariable)this.connection;
    }

    void setFrame(List valueIndexToByGroupPair, int pairCount, double interploationPercentage) {
        this.valueIndexToByGroupPair = valueIndexToByGroupPair;
        this.interpolationPercentage = interploationPercentage;
        this.valueCount = pairCount;
    }

    protected int[] getKeyFramePair(int i) {
        int[] result = null;
        if (this.valueIndexToByGroupPair != null && this.valueIndexToByGroupPair.size() > i) {
            result = (int[])this.valueIndexToByGroupPair.get(i);
        }
        return result;
    }

    protected double getInterpolationPercentage() {
        return this.interpolationPercentage;
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
        if (initAction.isAnimationInitRequired()) {
            initAction.setDataChangedTime(AInitAction.getTimeStamp());
        }
    }

    public boolean isModified() {
        this.tempAction.pushValueCount();
        this.connection.init(this.tempAction);
        this.tempAction.popValueCount();
        long connectionModifiedTime = this.tempAction.getDataChangedTime();
        return connectionModifiedTime > this.variable.getModifiedTime();
    }

    @Override
    public Formatter getFormatter() {
        return this.connection.getFormatter();
    }

    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void reset(AResetAction resetAction) {
    }
}

