/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Accumulator;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;

public class AccumulatorByCategory
extends Accumulator {
    public final IntegerProperty category = new IntegerProperty(this, true);
    private double[] lowerRunningTotals;
    private double[] runningTotals;
    private BidirectionalAccumulatorByCategory.BidirectionalAccumulationInfo accumulationInfo = new BidirectionalAccumulatorByCategory.BidirectionalAccumulationInfo();
    private int categoryCount;
    private boolean negativeTotalsEnabled = false;

    public AccumulatorByCategory() {
    }

    protected AccumulatorByCategory(boolean negativeTotalsEnabled) {
        this.negativeTotalsEnabled = negativeTotalsEnabled;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double result;
        if (this.lastIndex == index) {
            return this.lastValue;
        }
        int cat = this.category.getValue(index);
        double v = this.input.getValue(index);
        if (this.negativeTotalsEnabled) {
            if (v >= this.getStartValue()) {
                v = Math.abs(v);
                if (this.getPostAccumulate()) {
                    result = this.runningTotals[cat];
                    int n = cat;
                    this.runningTotals[n] = this.runningTotals[n] + v;
                } else {
                    int n = cat;
                    this.runningTotals[n] = this.runningTotals[n] + v;
                    result = this.runningTotals[cat];
                }
            } else {
                v = Math.abs(v);
                if (this.getPostAccumulate()) {
                    result = this.lowerRunningTotals[cat];
                    int n = cat;
                    this.lowerRunningTotals[n] = this.lowerRunningTotals[n] - v;
                } else {
                    int n = cat;
                    this.lowerRunningTotals[n] = this.lowerRunningTotals[n] - v;
                    result = this.lowerRunningTotals[cat];
                }
            }
        } else if (this.getPostAccumulate()) {
            result = this.runningTotals[cat];
            int n = cat;
            this.runningTotals[n] = this.runningTotals[n] + v;
        } else {
            int n = cat;
            this.runningTotals[n] = this.runningTotals[n] + v;
            result = this.runningTotals[cat];
        }
        this.lastIndex = index;
        this.lastValue = result;
        return result;
    }

    @Override
    protected void reset() {
        if (this.runningTotals != null) {
            double sv = this.getStartValue();
            for (int i = 0; i < this.runningTotals.length; ++i) {
                this.runningTotals[i] = sv;
            }
            this.lastIndex = -1;
            System.arraycopy(this.runningTotals, 0, this.lowerRunningTotals, 0, this.runningTotals.length);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        this.categoryCount = 0;
        super.init(initAction);
        if (initAction.beenInitialized(this)) {
            return;
        }
        try {
            int n = initAction.getValueCount();
            for (int i = 0; i < n; ++i) {
                int c = this.category.getValue(i);
                if (c <= this.categoryCount) continue;
                this.categoryCount = c;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        ++this.categoryCount;
        if (this.runningTotals == null || this.runningTotals.length < this.categoryCount) {
            this.runningTotals = new double[this.categoryCount];
        }
        if (this.lowerRunningTotals == null || this.lowerRunningTotals.length < this.runningTotals.length) {
            this.lowerRunningTotals = new double[this.runningTotals.length];
        }
        this.calculateMinMaxAccumulations(initAction);
        this.reset();
    }

    private void calculateMinMaxAccumulations(AInitAction initAction) {
        int i;
        int n = initAction.getValueCount();
        for (i = 0; i < n; ++i) {
            try {
                this.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        double minimumNegativeTotal = Double.POSITIVE_INFINITY;
        double maximumPositiveTotal = Double.NEGATIVE_INFINITY;
        for (i = 0; i < this.categoryCount; ++i) {
            if (this.lowerRunningTotals[i] < minimumNegativeTotal) {
                minimumNegativeTotal = this.lowerRunningTotals[i];
            }
            if (!(this.runningTotals[i] > maximumPositiveTotal)) continue;
            maximumPositiveTotal = this.runningTotals[i];
        }
        this.accumulationInfo.setMinimumNegativeTotal(minimumNegativeTotal);
        this.accumulationInfo.setMaximumPositiveTotal(maximumPositiveTotal);
        this.accumulationInfo.setNegativeTotals((double[])this.lowerRunningTotals.clone());
        this.accumulationInfo.setPositiveTotals((double[])this.runningTotals.clone());
    }

    protected double getMinimumNegativeTotal() {
        return this.accumulationInfo.getMinimumNegativeTotal();
    }

    protected double getMaximumPositiveTotal() {
        return this.accumulationInfo.getMaximumPositiveTotal();
    }

    protected BidirectionalAccumulatorByCategory.BidirectionalAccumulationInfo getAccumulationInfo() {
        return this.accumulationInfo;
    }
}

