/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import java.awt.Color;

public abstract class ATriangleConnector
extends Element {
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, false);
    public final ColorProperty color = new ColorProperty(this, false);
    public final NumericProperty pointX = new NumericProperty(this, false);
    public final NumericProperty pointY = new NumericProperty(this, false);
    public final NumericProperty pointZ = new NumericProperty(this, false);
    protected int width = 0;

    public ATriangleConnector(ATransform transform) {
        super(transform);
        this.color.setValue(Color.red);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setMajorGridCount(int count) {
        this.setWidth(count);
    }

    public int getMajorGridCount() {
        return this.getWidth();
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int index = bBoxAction.getValueIndex();
        Vec3d point = bBoxAction.pt1;
        try {
            point.x = this.pointX.getValue(index);
            point.y = this.pointY.getValue(index);
            point.z = this.pointZ.getValue(index);
            BoundingBox box = bBoxAction.getElementBoundingBox();
            box.union(point);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

