/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;

public abstract class APointSet
extends Element {
    public final NumericProperty coordX = new NumericProperty(this, false);
    public final NumericProperty coordY = new NumericProperty(this, false);
    public final NumericProperty coordZ = new NumericProperty(this, false);
    public final ColorProperty color = new ColorProperty(this, true);
    public final IntegerProperty pointSize = new IntegerProperty(this, true);
    protected int pointCount;

    protected APointSet(ATransform transform) {
        super(transform);
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.coordX.init(initAction);
        this.coordY.init(initAction);
        this.coordZ.init(initAction);
        this.pointCount = initAction.getValueCount();
        initAction.popValueCount();
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d pt = bBoxAction.pt1;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        boolean coordI = false;
        for (int i = 0; i < this.pointCount; ++i) {
            try {
                pt.x = this.coordX.getValue(i);
                pt.y = this.coordY.getValue(i);
                pt.z = this.coordZ.getValue(i);
                box.union(pt);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }
}

