/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MismatchedValueCountException;
import com.sas.graphics.util.gtk.PipedHashtable;
import com.sas.graphics.util.gtk.PipedVector;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.Sort;
import java.util.Locale;

public class AInitAction
extends Action {
    private int topValueCount;
    private int valueCountStackSize = 10;
    private int valueCountStackIncrement = 10;
    private int valueCountTopIndex = -1;
    private int[] valueCountStack = new int[this.valueCountStackSize];
    private boolean categoryRequest;
    private IntegerPipe categoryPipe;
    private PipedVector uniqueValueVector;
    private PipedHashtable valueToCategoryTable;
    private Locale locale = Locale.getDefault();
    private int sortStrategy = Sort.getDefaultSortStrategy();
    private boolean animationInitRequired = false;
    private long currentTime;
    private long dataChangedTime;
    public static final int CONSTANT_VALUE_COUNT = -1;
    public static final Integer CVCobj = new Integer(-1);

    public AInitAction() {
        this(null);
    }

    public AInitAction(Object graphicsContext) {
        super(graphicsContext);
        this.pushValueCount();
        this.categoryPipe = null;
        this.uniqueValueVector = null;
        this.categoryRequest = false;
        this.currentTime = Action.getTimeStamp();
    }

    @Override
    public void apply(Element element) {
        this.currentTime = Action.getTimeStamp();
        this.clearVisits();
        this.topValueCount = -1;
        this.pushValueCount();
        element.init(this);
        this.popValueCount();
    }

    public void setConstantValueCount() {
        this.valueCountStackPop();
        this.valueCountStackPush(this.topValueCount);
    }

    public void setValueCount(int v) {
        if (v == -1) {
            return;
        }
        if (this.topValueCount != -1 && this.topValueCount != v) {
            throw new MismatchedValueCountException(this.topValueCount + " != " + v);
        }
        this.valueCountStackPop();
        this.topValueCount = v;
        this.valueCountStackPush(this.topValueCount);
    }

    public int getValueCount() {
        return this.topValueCount;
    }

    public void pushValueCount() {
        this.topValueCount = -1;
        this.valueCountStackPush(-1);
    }

    public void popValueCount() {
        this.valueCountStackPop();
        this.topValueCount = this.valueCountStackPeek();
    }

    public void setCategoryRequest(boolean trueOrFalse) {
        this.categoryRequest = trueOrFalse;
    }

    public boolean isCategoryRequest() {
        return this.categoryRequest;
    }

    public IntegerPipe getCategoryPipe() {
        return this.categoryPipe;
    }

    public void setCategoryPipe(IntegerPipe aCategoryPipe) {
        this.categoryPipe = aCategoryPipe;
    }

    public PipedVector getUniqueValueVector() {
        return this.uniqueValueVector;
    }

    public void setUniqueValueVector(PipedVector aUniqueValueVector) {
        this.uniqueValueVector = aUniqueValueVector;
    }

    public void setValueToCategoryTable(PipedHashtable table) {
        this.valueToCategoryTable = table;
    }

    public PipedHashtable getValueToCategoryTable() {
        return this.valueToCategoryTable;
    }

    public boolean beenInitialized(PropertyContainer container) {
        long wasInitialized = container.getInitTime();
        if (wasInitialized == 0L || wasInitialized < this.dataChangedTime && wasInitialized < this.currentTime) {
            this.dataChangedTime = this.currentTime;
            container.setInitTime(this.currentTime);
            return false;
        }
        this.dataChangedTime = wasInitialized;
        return true;
    }

    public void setDataChangedTime(long t) {
        this.dataChangedTime = t;
    }

    public long getDataChangedTime() {
        return this.dataChangedTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    private void valueCountStackPop() {
        --this.valueCountTopIndex;
    }

    private void valueCountStackPush(int valueCount) {
        if (this.valueCountTopIndex + 1 >= this.valueCountStackSize) {
            this.valueCountStackRealloc();
        }
        ++this.valueCountTopIndex;
        this.valueCountStack[this.valueCountTopIndex] = valueCount;
    }

    private int valueCountStackPeek() {
        return this.valueCountStack[this.valueCountTopIndex];
    }

    private void valueCountStackRealloc() {
        int newSize = this.valueCountStackSize + this.valueCountStackIncrement;
        int[] newStack = new int[newSize];
        System.arraycopy(this.valueCountStack, 0, newStack, 0, this.valueCountStackSize);
        this.valueCountStack = newStack;
        this.valueCountStackSize = newSize;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getSortStrategy() {
        return this.sortStrategy;
    }

    public void setSortStrategy(int sortStrategy) {
        this.sortStrategy = sortStrategy;
    }

    public boolean isAnimationInitRequired() {
        return this.animationInitRequired;
    }

    public void setAnimationInitRequired(boolean animationInitRequired) {
        this.animationInitRequired = animationInitRequired;
    }
}

