/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import java.awt.Color;

public abstract class AGrid
extends Element {
    public final NumericProperty horizontalLineOffset = new NumericProperty(this, false);
    public final NumericProperty verticalLineOffset = new NumericProperty(this, false);
    public final NumericProperty yClipStart = new NumericProperty(this, false);
    public final NumericProperty yClipEnd = new NumericProperty(this, false);
    public final NumericProperty width = new NumericProperty(this, true);
    public final NumericProperty height = new NumericProperty(this, true);
    protected Vec3d normal = Vec3d.getZAxis();
    protected GridStyle style;
    protected int verticalLineCount;
    protected int horizontalLineCount;
    protected double horizontalOrigin;
    protected double verticalOrigin;
    protected double backgroundHorizontalOrigin;
    protected double backgroundVerticalOrigin;

    protected AGrid(ATransform transform) {
        super(transform);
        this.width.setValue(1.0);
        this.height.setValue(1.0);
        this.style = new GridStyle();
        this.horizontalOrigin = 0.0;
        this.verticalOrigin = 0.0;
        this.backgroundHorizontalOrigin = 0.0;
        this.backgroundVerticalOrigin = 0.0;
        this.yClipStart.setValue(Double.NEGATIVE_INFINITY);
        this.yClipEnd.setValue(Double.POSITIVE_INFINITY);
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.verticalLineOffset.init(initAction);
        this.verticalLineCount = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.horizontalLineOffset.init(initAction);
        this.horizontalLineCount = initAction.getValueCount();
        initAction.popValueCount();
    }

    public void setNormal(Vec3d normal) {
        if (!ATransform.isZero(normal.x) && ATransform.isZero(normal.y) && ATransform.isZero(normal.z) || !ATransform.isZero(normal.y) && ATransform.isZero(normal.x) && ATransform.isZero(normal.z) || !ATransform.isZero(normal.z) && ATransform.isZero(normal.x) && ATransform.isZero(normal.y)) {
            this.normal = normal;
        }
    }

    public Vec3d getNormal() {
        return this.normal;
    }

    public void setWidth(double width) {
        if (!Double.isNaN(width)) {
            this.width.setValue(width);
        }
    }

    public void setHeight(double height) {
        if (!Double.isNaN(height)) {
            this.height.setValue(height);
        }
    }

    public void setStyle(GridStyle style) {
        if (style != null) {
            this.style = style;
        }
    }

    public void setHorizontalOrigin(double horizontal) {
        this.horizontalOrigin = horizontal;
    }

    public double getHorizontalOrigin() {
        return this.horizontalOrigin;
    }

    public void setBackgroundHorizontalOrigin(double origin) {
        this.backgroundHorizontalOrigin = origin;
    }

    public double getBackgroundHorizontalOrigin() {
        return this.backgroundHorizontalOrigin;
    }

    public void setVerticalOrigin(double vertical) {
        this.verticalOrigin = vertical;
    }

    public double getVerticalOrigin() {
        return this.verticalOrigin;
    }

    public void setBackgroundVerticalOrigin(double origin) {
        this.backgroundVerticalOrigin = origin;
    }

    public double getBackgroundVerticalOrigin() {
        return this.backgroundVerticalOrigin;
    }

    public double getWidth() {
        try {
            return this.width.getValue(0);
        }
        catch (MissingValueException e) {
            return Double.NaN;
        }
    }

    public double getHeight() {
        try {
            return this.height.getValue(0);
        }
        catch (MissingValueException e) {
            return Double.NaN;
        }
    }

    public GridStyle getStyle() {
        return this.style;
    }

    protected abstract void drawVerticalMajorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawVerticalMinorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawHorizontalMajorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawHorizontalMinorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawBackground(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, GridStyle var19);
}

