/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import java.awt.Color;
import java.awt.Image;

public abstract class AEllipse
extends Element {
    public final NumericProperty xRadius = new NumericProperty(this, true);
    public final NumericProperty yRadius = new NumericProperty(this, true);
    public final NumericProperty angle = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    public final NumericProperty stipplePattern = new NumericProperty(this, true);
    public final NumericProperty stippleFactor = new NumericProperty(this, true);
    protected final NumericProperty xCenter = new NumericProperty(this, true);
    protected final NumericProperty yCenter = new NumericProperty(this, true);
    public final BooleanProperty fillPatternOn = new BooleanProperty(this, true);
    public final IntegerProperty fillPatternType = new IntegerProperty(this, true);
    public final ColorProperty fillPatternColor = new ColorProperty(this, true);
    public final NumericProperty fillPatternWidth = new NumericProperty(this, true);
    public final NumericProperty fillPatternScaleFactor = new NumericProperty(this, true);
    protected Color highlightColor;
    protected int highlightWidth;
    protected boolean highlightOnly;
    protected boolean SVGRender;
    protected Image skin;
    protected int skinType = 0;
    protected Image[] pixelBenderImages = null;
    protected float DPIScaleFactor = 1.0f;
    protected double stippleScaleFactor = 1.0;

    public AEllipse(ATransform transform) {
        super(transform);
        this.xCenter.setValue(0.0);
        this.yCenter.setValue(0.0);
        this.xRadius.setValue(1.0);
        this.yRadius.setValue(1.0);
        this.angle.setValue(0.0);
        this.edgeOn.setValue(true);
        this.fillOn.setValue(false);
        this.highlightOn.setValue(false);
        this.highlightColor = null;
        this.highlightWidth = 1;
        this.highlightOnly = false;
        this.SVGRender = false;
        this.skin = null;
        this.fillPatternOn.setValue(false);
        this.fillPatternType.setValue(-1);
        this.fillPatternColor.setValue(Color.black);
        this.fillPatternWidth.setValue(1.0);
        this.fillPatternScaleFactor.setValue(1.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double xo = this.xCenter.getValue(index);
        double yo = this.yCenter.getValue(index);
        double xrad = this.xRadius.getValue(index);
        double yrad = this.yRadius.getValue(index);
        size.set(xrad * 2.0, yrad * 2.0, 0.0);
        center.set(xo, yo, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightWidth(int w) {
        this.highlightWidth = w;
    }

    public int getHighlightWidth() {
        return this.highlightWidth;
    }

    public void setHighlightOnly(boolean b) {
        this.highlightOnly = b;
    }

    public boolean isHighlighOnly() {
        return this.highlightOnly;
    }

    public void setSVGRender(boolean b) {
        this.SVGRender = b;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    public void setSkin(Image newImage) {
        this.skin = newImage;
    }

    public Image getSkin() {
        return this.skin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public float getDPIScaleFactor() {
        return this.DPIScaleFactor;
    }

    public void setPixelBenderImages(Image[] newImages) {
        this.pixelBenderImages = newImages;
    }

    public Image[] getPixelBenderImages() {
        return this.pixelBenderImages;
    }
}

