/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.Element;
import java.awt.geom.Rectangle2D;

public abstract class AComputeBoundingBoxAction
extends Action {
    private BoundingBox elementBox;
    private BoundingBox networkBox;
    public Vec3d pt1 = new Vec3d();
    public Vec3d pt2 = new Vec3d();
    public double[] matrix = new double[16];
    private Rectangle2D projectedBounds = null;

    protected AComputeBoundingBoxAction(AResetAction ra, Object graphicsContext) {
        super(graphicsContext, ra);
        this.elementBox = new BoundingBox();
        this.networkBox = new BoundingBox();
    }

    @Override
    public void apply(Element element) {
        this.setValueIndex(0);
        element.computeBoundingBox(this);
    }

    public BoundingBox getElementBoundingBox() {
        return this.elementBox;
    }

    public void setElementBoundingBox(BoundingBox bbox) {
        this.elementBox = bbox;
    }

    public BoundingBox getNetworkBoundingBox() {
        return this.networkBox;
    }

    public void setNetworkBoundingBox(BoundingBox bbox) {
        this.networkBox = bbox;
    }

    public abstract void unionProjection(BoundingBox var1);

    public Rectangle2D getProjectedBounds() {
        return this.projectedBounds;
    }

    public void clearProjection() {
        this.projectedBounds = null;
    }

    public void unionRectangle(Rectangle2D r) {
        if (r != null) {
            if (this.projectedBounds == null) {
                this.projectedBounds = new Rectangle2D.Double();
                this.projectedBounds.setFrame(r);
            } else {
                Rectangle2D.union(r, this.projectedBounds, this.projectedBounds);
            }
        }
    }
}

