/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AAxis;
import com.sas.graphics.util.gtk.ABox;
import com.sas.graphics.util.gtk.AGrid;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ANetworkRoot;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.gl.Axis;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import java.awt.Color;
import java.awt.Font;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public abstract class AAxisSet {
    public static final int PROJECTION_PERSPECTIVE = 0;
    public static final int PROJECTION_ORTHOGRAPHIC = 1;
    public static final int PROJECTION_OBLIQUE = 2;
    private static final int xOriginFlag = 2;
    private static final int yOriginFlag = 4;
    private static final int zOriginFlag = 1;
    protected AAxis xAxis;
    protected AAxis yAxis;
    protected AAxis zAxis;
    protected AAxis x2Axis = null;
    protected AAxis y2Axis = null;
    protected AAxis z2Axis = null;
    protected AGrid floorGrid;
    protected AGrid sideGrid;
    protected AGrid backGrid;
    protected AGrid floorGrid2 = null;
    protected AGrid sideGrid2 = null;
    protected AGrid backGrid2 = null;
    protected ABox wireBox;
    private Vec3d xAxisNormal = Vec3d.getXAxis();
    private Vec3d negativeXAxisNormal = Vec3d.getNegativeXAxis();
    private Vec3d yAxisNormal = Vec3d.getYAxis();
    private Vec3d negativeYAxisNormal = Vec3d.getNegativeYAxis();
    private Vec3d zAxisNormal = Vec3d.getZAxis();
    private Vec3d negativeZAxisNormal = Vec3d.getNegativeZAxis();
    protected static double radians2degrees = 57.29577951308232;
    protected static double degrees2radians = Math.PI / 180;
    private static final double fov = 45.0;
    protected double obliqueAngle = 45.0;
    protected double obliqueFactor = 0.8;
    private double azimuth;
    private double incline;
    private double distance;
    private Vec3d focalPoint = new Vec3d(0.0, 0.0, 0.0);
    protected ANetworkRoot networkRoot;
    protected Vec3d origin;
    protected Vec3d size = new Vec3d();
    private NumericProperty sizeX = new NumericProperty();
    private NumericProperty sizeY = new NumericProperty();
    private NumericProperty sizeZ = new NumericProperty();
    private NumericProperty halfSizeX = new NumericProperty();
    private NumericProperty halfSizeY = new NumericProperty();
    private NumericProperty halfSizeZ = new NumericProperty();
    private final ContinuousRangeToNumericMap defaultMap = new ContinuousRangeToNumericMap();
    private NumericMap xMap = this.defaultMap;
    private NumericMap yMap = this.defaultMap;
    private NumericMap zMap = this.defaultMap;
    private NumericMap x2Map = this.defaultMap;
    private NumericMap y2Map = this.defaultMap;
    private NumericMap z2Map = this.defaultMap;
    protected BoundingBox bbox;
    protected int prevAzimuthZone;
    protected int prevInclineZone;
    static final int INITIAL_ZONE = -1;
    private int projectionType;
    private boolean usingDisplayList = false;
    private Font titleFont;
    private Font labelFont;
    private Color titleColor;
    private Color labelColor;
    private GridStyle gridStyle;
    private boolean fitScreen = false;
    private boolean cartesian = false;
    private Vec3d cartesianOrigin;
    private Color ticColorX;
    private Color ticColorY;
    private Color ticColorZ;
    private ZoneDataModel xZoneDataModel = new XZoneDataModel();
    private ZoneDataModel yZoneDataModel = new YZoneDataModel();
    private ZoneDataModel zZoneDataModel = new ZZoneDataModel();
    private String[] axisFittingAlgorithm = new String[]{"thinkeepend"};
    private double zoom = 1.0;
    private boolean displayZAxis = false;
    private static final int VP_TYPCIAL_MIN = 200;
    private static final int VP_TYPICAL_MAX = 400;

    public AAxisSet() {
        this(null);
        this.setProjection(0);
    }

    public AAxisSet(ANetworkRoot networkRoot) {
        this.networkRoot = networkRoot;
        this.origin = new Vec3d(0.0, 0.0, 0.0);
        this.setSize(1.0, 1.0, 1.0);
        this.prevAzimuthZone = -1;
        this.prevInclineZone = -1;
        this.setProjection(0);
        this.titleFont = FontManager.getDefaultFont();
        this.labelFont = FontManager.getDefaultFont();
        this.titleColor = Color.BLACK;
        this.labelColor = Color.BLACK;
        this.gridStyle = new GridStyle();
        this.gridStyle.setLinkedLineAttributes(false);
        this.cartesianOrigin = new Vec3d(0.0, 0.0, 0.0);
        this.defaultMap.setLabelCount(1);
    }

    protected double getAzimuth() {
        return this.azimuth;
    }

    protected double getDistance() {
        return this.distance;
    }

    protected double getIncline() {
        return this.incline;
    }

    protected double getFieldOfView() {
        return 45.0;
    }

    public ANetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    private void applyStyle(AAxis axis) {
        TextStyle ts = axis.getStyle().getTitleStyle();
        ts.setFont(this.titleFont);
        ts.setColor(this.titleColor);
        ts = axis.getStyle().getLabelStyle();
        ts.setFont(this.labelFont);
        ts.setColor(this.labelColor);
        axis.labelColor.setValue(this.labelColor);
        ((Axis)axis).setFitAlgorithm(this.getAxisFittingAlgorithm());
        ((Axis)axis).setUse3DFitting(true);
    }

    protected void newXAxis(AAxis axis, NumericMap map) {
        this.xAxis = axis;
        axis.setOrigin(this.origin.x);
        this.xAxis.setLabelOrientation(2);
        this.xAxis.getStyle().getTitleStyle().setVerticalJustification(0);
        this.applyStyle(axis);
        this.connectAxisAndGridPipes();
    }

    protected void newYAxis(AAxis axis, NumericMap map) {
        this.yAxis = axis;
        axis.setOrigin(this.origin.y);
        axis.setTitlePosition(2);
        this.applyStyle(axis);
        this.connectAxisAndGridPipes();
    }

    protected void newZAxis(AAxis axis, NumericMap map) {
        this.zAxis = axis;
        axis.setOrigin(this.origin.z);
        axis.setLabelOrientation(2);
        this.applyStyle(axis);
        this.connectAxisAndGridPipes();
    }

    protected void newX2Axis(AAxis axis, NumericMap map) {
        this.x2Axis = axis;
        axis.setOrigin(this.origin.x);
        axis.setLabelOrientation(2);
        axis.getStyle().getTitleStyle().setVerticalJustification(3);
        this.applyStyle(axis);
        this.connectAxisAndGridPipes();
    }

    protected void newY2Axis(AAxis axis, NumericMap map) {
        this.y2Axis = axis;
        axis.setOrigin(this.origin.y);
        axis.setTitlePosition(2);
        this.applyStyle(axis);
        this.connectAxisAndGridPipes();
    }

    protected void newZ2Axis(AAxis axis, NumericMap map) {
        this.z2Axis = axis;
        axis.setOrigin(this.origin.z);
        axis.setLabelOrientation(2);
        this.applyStyle(axis);
        this.connectAxisAndGridPipes();
    }

    protected void newFloorGrid(AGrid grid, NumericMap horizMap, NumericMap vertMap) {
        this.floorGrid = grid;
        grid.selectEnabled.setValue(false);
        GridStyle floorStyle = new GridStyle(this.gridStyle);
        floorStyle.setBackgroundOn(true);
        floorStyle.setBorderOn(true);
        grid.setStyle(floorStyle);
        grid.setNormal(this.yAxisNormal);
        this.connectAxisAndGridPipes();
    }

    protected void newSideGrid(AGrid grid, NumericMap horizMap, NumericMap vertMap) {
        this.sideGrid = grid;
        grid.selectEnabled.setValue(false);
        GridStyle sideGridStyle = new GridStyle(this.gridStyle);
        sideGridStyle.setBackgroundOn(true);
        sideGridStyle.setBorderOn(true);
        grid.setStyle(sideGridStyle);
        grid.setNormal(this.xAxisNormal);
        this.connectAxisAndGridPipes();
    }

    protected void newBackGrid(AGrid grid, NumericMap horizMap, NumericMap vertMap) {
        this.backGrid = grid;
        grid.selectEnabled.setValue(false);
        GridStyle backGridStyle = new GridStyle(this.gridStyle);
        backGridStyle.setBackgroundOn(true);
        backGridStyle.setBorderOn(true);
        grid.setStyle(backGridStyle);
        grid.setNormal(this.zAxisNormal);
        this.connectAxisAndGridPipes();
    }

    protected void newFloorGrid2(AGrid grid, NumericMap horizMap, NumericMap vertMap) {
        this.floorGrid2 = grid;
        grid.selectEnabled.setValue(false);
        GridStyle floorStyle = new GridStyle(this.gridStyle);
        floorStyle.setBackgroundOn(true);
        floorStyle.setBorderOn(true);
        grid.setStyle(floorStyle);
        grid.setNormal(this.yAxisNormal);
        this.connectAxisAndGridPipes();
    }

    protected void newSideGrid2(AGrid grid, NumericMap horizMap, NumericMap vertMap) {
        this.sideGrid2 = grid;
        grid.selectEnabled.setValue(false);
        GridStyle sideGridStyle = new GridStyle(this.gridStyle);
        sideGridStyle.setBackgroundOn(true);
        sideGridStyle.setBorderOn(true);
        grid.setStyle(sideGridStyle);
        grid.setNormal(this.xAxisNormal);
        this.connectAxisAndGridPipes();
    }

    protected void newBackGrid2(AGrid grid, NumericMap horizMap, NumericMap vertMap) {
        this.backGrid2 = grid;
        grid.selectEnabled.setValue(false);
        GridStyle backGridStyle = new GridStyle(this.gridStyle);
        backGridStyle.setBackgroundOn(true);
        backGridStyle.setBorderOn(true);
        grid.setStyle(backGridStyle);
        grid.setNormal(this.zAxisNormal);
        this.connectAxisAndGridPipes();
    }

    protected void newWireBox(ABox box) {
        this.wireBox = box;
        box.sizeX.connectFrom(this.sizeX);
        box.sizeY.connectFrom(this.sizeY);
        box.sizeZ.connectFrom(this.sizeZ);
        box.transform.translateX.connectFrom(this.halfSizeX);
        box.transform.translateY.connectFrom(this.halfSizeX);
        box.transform.translateZ.connectFrom(this.halfSizeX);
        box.origin.setValue(0);
        box.fillOn.setValue(false);
        box.edgeOn.setValue(true);
    }

    public void swapXandY() {
    }

    public void swapXandZ() {
    }

    public void swapYandZ() {
    }

    private int zone(double angle) {
        double a;
        return (int)((a += (a = angle % 360.0) < 0.0 ? 540.0 : 180.0) / 45.0) % 8;
    }

    protected double angle(int zone) {
        return 180 + 45 * zone;
    }

    public void setView(Vec3d eye, Vec3d focal) {
        double dx = eye.x - focal.x;
        double dy = eye.y - focal.y;
        double dz = eye.z - focal.z;
        this.setView(Math.atan2(dz, dx) * radians2degrees, Math.atan2(Math.sqrt(dx * dx + dz * dz), eye.y - focal.y) * radians2degrees, Math.sqrt(dx * dx + dy * dy + dz * dz));
    }

    public void setView(double azimuth, double incline, double distance) {
        this.azimuth = azimuth;
        this.incline = incline;
        this.distance = distance;
        switch (this.projectionType) {
            case 2: {
                this.setViewOblique();
                break;
            }
            case 0: 
            case 1: {
                this.setViewPerspectiveOrOrthographic(azimuth, incline, distance);
            }
        }
    }

    private void setViewOblique() {
        int aZone = 1;
        int iZone = 2;
        if (this.getObliqueAngle() < 90.0) {
            aZone = 4;
            iZone = 3;
        } else {
            aZone = 3;
            iZone = 3;
        }
        this.reconfigure(aZone, iZone);
    }

    private void setViewPerspectiveOrOrthographic(double azimuth, double incline, double distance) {
        int aZone = this.zone(azimuth);
        int iZone = this.zone(incline);
        if (aZone != this.prevAzimuthZone || iZone != this.prevInclineZone) {
            this.reconfigure(aZone, iZone);
            this.prevAzimuthZone = aZone;
            this.prevInclineZone = iZone;
        }
    }

    public void setBoundingBox(BoundingBox bb) {
        this.bbox = bb;
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    private void reconfigure(int azimuthZone, int inclineZone) {
        boolean flip;
        if (azimuthZone == -1 || inclineZone == -1) {
            return;
        }
        boolean bl = flip = !this.isOblique() && (inclineZone == 0 || inclineZone == 7);
        if (this.cartesian) {
            int originZone = this.calculateCartesianOriginZone();
            this.reconfigureCartesianXAxis(azimuthZone, inclineZone, originZone);
            this.reconfigureCartesianYAxis(azimuthZone, inclineZone, originZone);
            this.reconfigureCartesianZAxis(azimuthZone, inclineZone, originZone);
        } else {
            this.reconfigureXAxis(azimuthZone, inclineZone, flip);
            this.reconfigureYAxis(azimuthZone, inclineZone, flip);
            this.reconfigureZAxis(azimuthZone, inclineZone, flip);
        }
        this.reconfigureBackGrid(azimuthZone, inclineZone);
        this.reconfigureSideGrid(azimuthZone, inclineZone);
        this.reconfigureFloorGrid(azimuthZone, inclineZone);
        if (this.isUsingDisplayList()) {
            this.networkRoot.build();
        }
        this.updateGUI(azimuthZone, inclineZone);
    }

    private int calculateCartesianOriginZone() {
        int zone = 0;
        double xVal = (this.cartesianOrigin.x - this.xMap.getOutputMin()) / (this.xMap.getOutputMax() - this.xMap.getOutputMin());
        double yVal = (this.cartesianOrigin.y - this.yMap.getOutputMin()) / (this.yMap.getOutputMax() - this.yMap.getOutputMin());
        double zVal = (this.cartesianOrigin.z - this.zMap.getOutputMin()) / (this.zMap.getOutputMax() - this.zMap.getOutputMin());
        if (xVal > 0.5) {
            zone |= 2;
        }
        if (yVal > 0.5) {
            zone |= 4;
        }
        if (zVal > 0.5) {
            zone |= 1;
        }
        return zone;
    }

    private void reconfigureCartesianXAxis(int azimuthZone, int inclineZone, int originZone) {
        if (this.xAxis == null) {
            return;
        }
        this.xAxis.transform.translateY.setValue(this.cartesianOrigin.y);
        this.xAxis.transform.translateZ.setValue(this.cartesianOrigin.z);
        boolean primary = (originZone & 4) == 0;
        boolean upsideDown = inclineZone == 0 || inclineZone == 1 || inclineZone == 6 || inclineZone == 7;
        int labelVJust = upsideDown ? 3 : 0;
        int labelHJust = 1;
        int titleVJust = 1;
        int titleHJust = 1;
        int pos = 0;
        switch (azimuthZone) {
            case 0: 
            case 7: {
                if ((originZone & 2) == 0) {
                    pos = 2;
                    titleHJust = 2;
                    break;
                }
                pos = 0;
                titleHJust = 0;
                break;
            }
            case 1: 
            case 2: {
                pos = upsideDown ? 2 : 0;
                if ((originZone & 1) == 0) {
                    titleHJust = 2;
                    break;
                }
                titleHJust = 0;
                break;
            }
            case 3: 
            case 4: {
                if ((originZone & 2) == 0) {
                    pos = 2;
                    titleHJust = 0;
                    break;
                }
                pos = 0;
                titleHJust = 2;
                break;
            }
            case 5: 
            case 6: {
                pos = upsideDown ? 0 : 2;
                titleHJust = (originZone & 1) == 0 ? 0 : 2;
            }
        }
        titleVJust = primary ? (upsideDown ? 3 : 0) : (upsideDown ? 0 : 3);
        this.xAxis.setPrimary(primary);
        this.xAxis.setTitlePosition(pos);
        this.xAxis.getStyle().getTitleStyle().setHorizontalJustification(titleHJust);
        this.xAxis.getStyle().getTitleStyle().setVerticalJustification(titleVJust);
        this.xAxis.getStyle().getLabelStyle().setHorizontalJustification(labelHJust);
        this.xAxis.getStyle().getLabelStyle().setVerticalJustification(labelVJust);
    }

    private void reconfigureCartesianYAxis(int azimuthZone, int inclineZone, int originZone) {
        if (this.yAxis == null) {
            return;
        }
        this.yAxis.transform.translateX.setValue(this.cartesianOrigin.x);
        this.yAxis.transform.translateZ.setValue(this.cartesianOrigin.z);
        boolean primary = true;
        int labelDir = 1;
        boolean upsideDown = inclineZone == 0 || inclineZone == 1 || inclineZone == 6 || inclineZone == 7;
        int labelVJust = 1;
        int labelHJust = 1;
        int titleVJust = 1;
        int titleHJust = 1;
        int pos = 2;
        switch (azimuthZone) {
            case 0: 
            case 7: {
                labelDir = 1;
                primary = (originZone & 2) == 0;
                labelHJust = 0;
                break;
            }
            case 1: 
            case 2: {
                labelDir = 3;
                primary = (originZone & 1) == 0;
                labelHJust = 2;
                break;
            }
            case 3: 
            case 4: {
                labelDir = 1;
                primary = (originZone & 2) == 0;
                labelHJust = 2;
                break;
            }
            case 5: 
            case 6: {
                labelDir = 3;
                primary = (originZone & 1) == 0;
                labelHJust = 0;
            }
        }
        if (upsideDown) {
            if ((originZone & 4) == 0) {
                pos = 2;
                titleVJust = 0;
            } else {
                pos = 0;
                titleVJust = 3;
            }
        } else if ((originZone & 4) == 0) {
            pos = 2;
            titleVJust = 3;
        } else {
            pos = 0;
            titleVJust = 0;
        }
        this.yAxis.setTitlePosition(pos);
        this.yAxis.setPrimary(primary);
        this.yAxis.setLabelOrientation(labelDir);
        this.yAxis.getStyle().getTitleStyle().setHorizontalJustification(titleHJust);
        this.yAxis.getStyle().getTitleStyle().setVerticalJustification(titleVJust);
        this.yAxis.getStyle().getLabelStyle().setHorizontalJustification(labelHJust);
        this.yAxis.getStyle().getLabelStyle().setVerticalJustification(labelVJust);
    }

    private void reconfigureCartesianZAxis(int azimuthZone, int inclineZone, int originZone) {
        if (this.zAxis == null) {
            return;
        }
        this.zAxis.transform.translateX.setValue(this.cartesianOrigin.x);
        this.zAxis.transform.translateY.setValue(this.cartesianOrigin.y);
        boolean primary = (originZone & 4) == 0;
        boolean upsideDown = inclineZone == 0 || inclineZone == 1 || inclineZone == 6 || inclineZone == 7;
        int labelVJust = upsideDown ? 3 : 0;
        int labelHJust = 1;
        int titleVJust = 1;
        int titleHJust = 1;
        int pos = 0;
        switch (azimuthZone) {
            case 0: 
            case 7: {
                pos = upsideDown ? 2 : 0;
                if ((originZone & 2) == 0) {
                    titleHJust = 0;
                    break;
                }
                titleHJust = 2;
                break;
            }
            case 1: 
            case 2: {
                if ((originZone & 1) == 0) {
                    pos = 2;
                    titleHJust = 0;
                    break;
                }
                pos = 0;
                titleHJust = 2;
                break;
            }
            case 3: 
            case 4: {
                pos = upsideDown ? 0 : 2;
                if ((originZone & 2) == 0) {
                    titleHJust = 2;
                    break;
                }
                titleHJust = 0;
                break;
            }
            case 5: 
            case 6: {
                if ((originZone & 1) == 0) {
                    pos = 2;
                    titleHJust = 2;
                    break;
                }
                pos = 0;
                titleHJust = 0;
            }
        }
        titleVJust = primary ? (upsideDown ? 3 : 0) : (upsideDown ? 0 : 3);
        this.zAxis.setPrimary(primary);
        this.zAxis.setTitlePosition(pos);
        this.zAxis.getStyle().getTitleStyle().setHorizontalJustification(titleHJust);
        this.zAxis.getStyle().getTitleStyle().setVerticalJustification(titleVJust);
        this.zAxis.getStyle().getLabelStyle().setHorizontalJustification(labelHJust);
        this.zAxis.getStyle().getLabelStyle().setVerticalJustification(labelVJust);
    }

    private void reconfigureXAxis(int azimuthZone, int inclineZone, boolean flip) {
        if (this.xAxis == null) {
            return;
        }
        this.reconfigure(this.xAxis, this.xZoneDataModel, azimuthZone, inclineZone);
        if (this.isOblique()) {
            this.xAxis.getStyle().setTitleSpace(0.25);
            if (this.x2Axis != null) {
                this.x2Axis.setPrimary(false);
                this.x2Axis.transform.translateY.setValue(this.size.y);
            }
        }
    }

    private void reconfigure(AAxis axis, ZoneDataModel zoneDataModel, int azimuthZone, int inclineZone) {
        zoneDataModel.setCurrentZones(azimuthZone, inclineZone);
        axis.transform.translateX.setValue(zoneDataModel.getTranslationX() * this.size.x);
        axis.transform.translateY.setValue(zoneDataModel.getTranslationY() * this.size.y);
        axis.transform.translateZ.setValue(zoneDataModel.getTranslationZ() * this.size.z);
        axis.getStyle().getLabelStyle().setVerticalJustification(zoneDataModel.getLabelVJust());
        axis.getStyle().getTitleStyle().setVerticalJustification(zoneDataModel.getTitleVJust());
        axis.getStyle().getLabelStyle().setHorizontalJustification(zoneDataModel.getLabelHJust());
        axis.getStyle().getTitleStyle().setHorizontalJustification(zoneDataModel.getTitleHJust());
        axis.setTitlePosition(zoneDataModel.getTitlePosition());
        axis.setPrimary(zoneDataModel.isPrimary());
        axis.setLabelOrientation(zoneDataModel.getLabelOrientation());
        if (!this.isOblique()) {
            axis.getStyle().setTitleSpace(this.getNonObliqueTitleSpace(axis.getOrientation()));
        }
    }

    private void reconfigureYAxis(int azimuthZone, int inclineZone, boolean flip) {
        boolean giveZAxisSpace;
        boolean bl = giveZAxisSpace = (this.isZAxisTitleOrLabelsShowing() || this.isDisplayZAxis()) && this.isOblique();
        if (this.yAxis == null) {
            return;
        }
        this.reconfigure(this.yAxis, this.yZoneDataModel, azimuthZone, inclineZone);
        if (!this.isOblique()) {
            this.yAxis.getStyle().getTitleStyle().setAngle(0.0);
            this.yAxis.getStyle().setTitleEndSpace(0.75);
        } else {
            double angle;
            this.yAxis.setTitlePosition(1);
            this.yAxis.getStyle().getTitleStyle().setVerticalJustification(1);
            if (giveZAxisSpace) {
                angle = 270.0;
                if (this.getObliqueAngle() >= 0.0 && this.getObliqueAngle() <= 90.0) {
                    angle = 90.0;
                }
            } else {
                angle = 90.0;
                if (this.getObliqueAngle() >= 0.0 && this.getObliqueAngle() <= 90.0) {
                    angle = 270.0;
                }
            }
            if (giveZAxisSpace) {
                double xOffset = this.yAxis.transform.translateX.getValue();
                double zOffset = this.yAxis.transform.translateZ.getValue();
                switch (azimuthZone) {
                    case 3: {
                        xOffset = this.size.x;
                        zOffset = this.size.z;
                        this.yAxis.setPrimary(false);
                        break;
                    }
                    case 4: {
                        xOffset = 0.0;
                        zOffset = this.size.z;
                        this.yAxis.setPrimary(true);
                        if (this.y2Axis == null) break;
                        this.y2Axis.setPrimary(false);
                        this.y2Axis.transform.translateX.setValue(this.size.x);
                    }
                }
                this.yAxis.transform.translateX.setValue(xOffset);
                this.yAxis.transform.translateZ.setValue(zOffset);
            } else {
                switch (azimuthZone) {
                    case 3: {
                        this.yAxis.getStyle().getTitleStyle().setHorizontalJustification(2);
                        break;
                    }
                    case 4: {
                        this.yAxis.getStyle().getTitleStyle().setHorizontalJustification(0);
                    }
                }
            }
            this.yAxis.getStyle().getTitleStyle().setAngle(angle);
            this.yAxis.getStyle().setTitleEndSpace(0.0);
            this.yAxis.getStyle().setTitleSpace(1.0);
        }
    }

    private void reconfigureZAxis(int azimuthZone, int inclineZone, boolean flip) {
        if (this.zAxis == null) {
            return;
        }
        this.reconfigure(this.zAxis, this.zZoneDataModel, azimuthZone, inclineZone);
        if (this.isOblique()) {
            this.zAxis.setTitlePosition(0);
            this.zAxis.getStyle().setTitleSpace(-2.5);
            this.zAxis.getStyle().setTitleEndSpace(1.0);
        }
    }

    private double getNonObliqueTitleSpace(int axisOrientation) {
        double result = 0.0;
        switch (axisOrientation) {
            case 1: 
            case 3: {
                Channel ch = ((NetworkRoot)this.networkRoot).getChannel();
                double[] vp = ch.glGetDoublev(0);
                double min = Math.min(vp[2], vp[3]);
                double denominator = 200.0;
                double norm = (min - 200.0) / denominator;
                result = 0.5 + 0.5 * norm;
                result = Math.min(result, 1.0);
                result = Math.max(result, 0.5);
                break;
            }
            case 2: {
                result = 0.0;
            }
        }
        return result;
    }

    private boolean isZAxisTitleOrLabelsShowing() {
        boolean showing = false;
        if (this.zAxis != null) {
            showing = this.zAxis.getStyle().isLabelsOn() || this.zAxis.getStyle().isTitleOn();
        }
        return showing;
    }

    private boolean isUpsideDown(int inclineZone) {
        return inclineZone == 0 || inclineZone == 1 || inclineZone == 6 || inclineZone == 7;
    }

    private void reconfigureSideGrid(int azimuthZone, int inclineZone) {
        if (this.sideGrid == null) {
            return;
        }
        boolean upsideDown = this.isUpsideDown(inclineZone);
        if (!upsideDown && azimuthZone < 4 || upsideDown && azimuthZone >= 4) {
            this.sideGrid.transform.translateX.setValue(this.size.x);
            this.sideGrid.setNormal(this.negativeXAxisNormal);
        } else {
            this.sideGrid.transform.translateX.setValue(0.0);
            this.sideGrid.setNormal(this.xAxisNormal);
        }
        if (this.isOblique() && this.sideGrid2 != null) {
            this.sideGrid2.transform.translateX.setValue(0.0);
            this.sideGrid2.setNormal(this.xAxisNormal);
        }
    }

    private void reconfigureBackGrid(int azimuthZone, int inclineZone) {
        if (this.backGrid == null) {
            return;
        }
        boolean upsideDown = this.isUpsideDown(inclineZone);
        if (!upsideDown && (azimuthZone < 2 || azimuthZone > 5) || upsideDown && azimuthZone >= 2 && azimuthZone <= 5) {
            this.backGrid.transform.translateZ.setValue(this.size.z);
            this.backGrid.setNormal(this.negativeZAxisNormal);
        } else {
            this.backGrid.transform.translateZ.setValue(0.0);
            this.backGrid.setNormal(this.zAxisNormal);
        }
        if (this.isOblique() && this.backGrid2 != null) {
            this.backGrid2.transform.translateZ.setValue(0.0);
            this.backGrid2.setNormal(this.zAxisNormal);
        }
    }

    private void reconfigureFloorGrid(int azimuthZone, int inclineZone) {
        if (this.floorGrid == null) {
            return;
        }
        if (inclineZone > 3) {
            this.floorGrid.transform.translateY.setValue(this.size.y);
            this.floorGrid.setNormal(this.negativeYAxisNormal);
        } else {
            this.floorGrid.transform.translateY.setValue(0.0);
            this.floorGrid.setNormal(this.yAxisNormal);
        }
        if (this.isOblique() && this.floorGrid2 != null) {
            this.floorGrid2.transform.translateY.setValue(0.0);
            this.floorGrid2.setNormal(this.yAxisNormal);
        }
    }

    public void setPerspective(boolean trueorfalse) {
        this.setProjection(trueorfalse ? 0 : 2);
    }

    protected boolean isOblique() {
        return this.getProjection() == 2;
    }

    public boolean isPerspective() {
        return this.getProjection() == 0;
    }

    public void setProjection(int projectionType) {
        switch (projectionType) {
            case 0: 
            case 1: 
            case 2: {
                this.projectionType = projectionType;
                this.updateView();
                this.reconfigure(this.prevAzimuthZone, this.prevInclineZone);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown projectionType.");
            }
        }
    }

    public int getProjection() {
        return this.projectionType;
    }

    public void setOrigin(double x, double y, double z) {
        this.origin.set(x, y, z);
        if (this.xAxis != null) {
            this.xAxis.setOrigin(x);
        }
        if (this.yAxis != null) {
            this.yAxis.setOrigin(y);
        }
        if (this.zAxis != null) {
            this.zAxis.setOrigin(z);
        }
    }

    public void setCartesianOrigin(double x, double y, double z) {
        this.cartesianOrigin.set(x, y, z);
        this.reconfigure(this.prevAzimuthZone, this.prevInclineZone);
    }

    public Vec3d getCartesianOrigin() {
        if (this.cartesianOrigin != null) {
            return new Vec3d(this.cartesianOrigin);
        }
        return null;
    }

    public void setTitleFont(Font font) {
        if (font != null) {
            this.titleFont = font;
        }
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setLabelFont(Font font) {
        if (font != null) {
            this.labelFont = font;
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public void setGridStyle(GridStyle gridStyle) {
        this.gridStyle = gridStyle;
    }

    public void setSize(double xSize, double ySize, double zSize) {
        this.size.set(xSize, ySize, zSize);
        this.sizeX.setValue(xSize);
        this.sizeY.setValue(ySize);
        this.sizeZ.setValue(zSize);
        this.halfSizeX.setValue(xSize / 2.0);
        this.halfSizeY.setValue(ySize / 2.0);
        this.halfSizeZ.setValue(zSize / 2.0);
        this.prevAzimuthZone = -1;
        this.prevInclineZone = -1;
    }

    public void setXMap(NumericMap xMap) {
        this.xMap = xMap;
        this.connectAxisAndGridPipes();
    }

    public void setYMap(NumericMap yMap) {
        this.yMap = yMap;
        this.connectAxisAndGridPipes();
    }

    public void setZMap(NumericMap zMap) {
        this.zMap = zMap;
        this.connectAxisAndGridPipes();
    }

    public void setX2Map(NumericMap x2Map) {
        this.x2Map = this.xMap;
        this.connectAxisAndGridPipes();
    }

    public void setY2Map(NumericMap y2Map) {
        this.y2Map = y2Map;
        this.connectAxisAndGridPipes();
    }

    public void setZ2Map(NumericMap z2Map) {
        this.z2Map = z2Map;
        this.connectAxisAndGridPipes();
    }

    public NumericMap getXMap() {
        return this.xMap;
    }

    public NumericMap getYMap() {
        return this.yMap;
    }

    public NumericMap getZMap() {
        return this.zMap;
    }

    public NumericMap getX2Map() {
        return this.x2Map;
    }

    public NumericMap getY2Map() {
        return this.y2Map;
    }

    public NumericMap getZ2Map() {
        return this.z2Map;
    }

    private void connectAxisAndGridPipes() {
        if (this.xAxis != null) {
            this.xAxis.labels.connectFrom(this.xMap.label);
            this.xAxis.labelOffset.connectFrom(this.xMap.uniqueValue);
            this.xAxis.length.connectFrom(this.sizeX);
            this.xAxis.getStyle().getMajorTickStyle().setColor(this.ticColorX);
        }
        if (this.yAxis != null) {
            this.yAxis.labels.connectFrom(this.yMap.label);
            this.yAxis.labelOffset.connectFrom(this.yMap.uniqueValue);
            this.yAxis.length.connectFrom(this.sizeY);
            this.yAxis.getStyle().getMajorTickStyle().setColor(this.ticColorY);
        }
        if (this.zAxis != null) {
            this.zAxis.labels.connectFrom(this.zMap.label);
            this.zAxis.labelOffset.connectFrom(this.zMap.uniqueValue);
            this.zAxis.length.connectFrom(this.sizeZ);
            this.zAxis.getStyle().getMajorTickStyle().setColor(this.ticColorZ);
        }
        if (this.x2Axis != null) {
            this.x2Axis.labels.connectFrom(this.x2Map.label);
            this.x2Axis.labelOffset.connectFrom(this.x2Map.uniqueValue);
            this.x2Axis.length.connectFrom(this.sizeX);
            this.x2Axis.getStyle().getMajorTickStyle().setColor(this.ticColorX);
        }
        if (this.y2Axis != null) {
            this.y2Axis.labels.connectFrom(this.y2Map.label);
            this.y2Axis.labelOffset.connectFrom(this.y2Map.uniqueValue);
            this.y2Axis.length.connectFrom(this.sizeY);
            this.y2Axis.getStyle().getMajorTickStyle().setColor(this.ticColorY);
        }
        if (this.z2Axis != null) {
            this.z2Axis.labels.connectFrom(this.z2Map.label);
            this.z2Axis.labelOffset.connectFrom(this.z2Map.uniqueValue);
            this.z2Axis.length.connectFrom(this.sizeZ);
            this.z2Axis.getStyle().getMajorTickStyle().setColor(this.ticColorZ);
        }
        if (this.floorGrid != null) {
            this.floorGrid.horizontalLineOffset.connectFrom(this.zMap.uniqueValue);
            this.floorGrid.verticalLineOffset.connectFrom(this.xMap.uniqueValue);
            this.floorGrid.width.connectFrom(this.sizeX);
            this.floorGrid.height.connectFrom(this.sizeZ);
            this.floorGrid.getStyle().getHorizontalMajorLineStyle().setColor(this.ticColorZ);
            this.floorGrid.getStyle().getVerticalMajorLineStyle().setColor(this.ticColorX);
        }
        if (this.sideGrid != null) {
            this.sideGrid.horizontalLineOffset.connectFrom(this.yMap.uniqueValue);
            this.sideGrid.verticalLineOffset.connectFrom(this.zMap.uniqueValue);
            this.sideGrid.width.connectFrom(this.sizeZ);
            this.sideGrid.height.connectFrom(this.sizeY);
            this.sideGrid.getStyle().getHorizontalMajorLineStyle().setColor(this.ticColorY);
            this.sideGrid.getStyle().getVerticalMajorLineStyle().setColor(this.ticColorZ);
        }
        if (this.backGrid != null) {
            this.backGrid.horizontalLineOffset.connectFrom(this.yMap.uniqueValue);
            this.backGrid.verticalLineOffset.connectFrom(this.xMap.uniqueValue);
            this.backGrid.width.connectFrom(this.sizeX);
            this.backGrid.height.connectFrom(this.sizeY);
            this.backGrid.getStyle().getHorizontalMajorLineStyle().setColor(this.ticColorY);
            this.backGrid.getStyle().getVerticalMajorLineStyle().setColor(this.ticColorX);
        }
        if (this.floorGrid2 != null) {
            this.floorGrid2.horizontalLineOffset.connectFrom(this.z2Map.uniqueValue);
            this.floorGrid2.verticalLineOffset.connectFrom(this.x2Map.uniqueValue);
            this.floorGrid2.width.connectFrom(this.sizeX);
            this.floorGrid2.height.connectFrom(this.sizeZ);
            this.floorGrid2.getStyle().getHorizontalMajorLineStyle().setColor(this.ticColorZ);
            this.floorGrid2.getStyle().getVerticalMajorLineStyle().setColor(this.ticColorX);
        }
        if (this.sideGrid2 != null) {
            this.sideGrid2.horizontalLineOffset.connectFrom(this.y2Map.uniqueValue);
            this.sideGrid2.verticalLineOffset.connectFrom(this.z2Map.uniqueValue);
            this.sideGrid2.width.connectFrom(this.sizeZ);
            this.sideGrid2.height.connectFrom(this.sizeY);
            this.sideGrid2.getStyle().getHorizontalMajorLineStyle().setColor(this.ticColorY);
            this.sideGrid2.getStyle().getVerticalMajorLineStyle().setColor(this.ticColorZ);
        }
        if (this.backGrid2 != null) {
            this.backGrid2.horizontalLineOffset.connectFrom(this.y2Map.uniqueValue);
            this.backGrid2.verticalLineOffset.connectFrom(this.x2Map.uniqueValue);
            this.backGrid2.width.connectFrom(this.sizeX);
            this.backGrid2.height.connectFrom(this.sizeY);
            this.backGrid2.getStyle().getHorizontalMajorLineStyle().setColor(this.ticColorY);
            this.backGrid2.getStyle().getVerticalMajorLineStyle().setColor(this.ticColorX);
        }
    }

    public Vec3d getSize() {
        return this.size;
    }

    protected double getGreatestDimension() {
        return Math.max(this.size.x, Math.max(this.size.y, this.size.z));
    }

    public boolean isUsingDisplayList() {
        return this.usingDisplayList;
    }

    public void setUsingDisplayList(boolean usingDisplayList) {
        this.usingDisplayList = usingDisplayList;
    }

    public void setObliqueFactor(double factor) {
        this.obliqueFactor = factor;
        this.updateView();
    }

    private void updateView() {
        if (this.getBoundingBox() != null) {
            switch (this.projectionType) {
                case 0: {
                    this.getNetworkRoot().setPerspectiveView(this.getBoundingBox(), 45.0, this.azimuth, this.incline);
                    break;
                }
                case 1: {
                    Vec3d c = this.getBoundingBox().getCenter();
                    Vec3d s = this.getBoundingBox().getSize();
                    s.scale(1.8);
                    double halfX = s.x / 2.0;
                    double halfY = s.y / 2.0;
                    double halfZ = s.z / 2.0;
                    Channel ch = ((NetworkRoot)this.getNetworkRoot()).getChannel();
                    ch.glOrtho(c.x - halfX, c.x + halfX, c.y - halfY, c.y + halfY, c.z - halfZ, c.z + halfZ);
                    break;
                }
                case 2: {
                    this.setViewOblique();
                    this.bbox = this.computeBoundingBox();
                    this.getNetworkRoot().setObliqueView(this.getBoundingBox(), this.obliqueFactor, this.obliqueAngle, 0.0, 0.0, this.getFocalPoint(), this.isFitScreen());
                    this.bbox = this.computeBoundingBox();
                    this.getNetworkRoot().setObliqueView(this.getBoundingBox(), this.obliqueFactor, this.obliqueAngle, 0.0, 0.0, this.getFocalPoint(), this.isFitScreen());
                }
            }
        }
    }

    public double getObliqueFactor() {
        return this.obliqueFactor;
    }

    public void setObliqueAngle(double angle) {
        this.obliqueAngle = angle;
        this.updateView();
    }

    public double getObliqueAngle() {
        return this.obliqueAngle;
    }

    public void setFocalPoint(Vec3d focal) {
        this.focalPoint.set(focal.x, focal.y, focal.z);
    }

    public Vec3d getFocalPoint() {
        return this.focalPoint;
    }

    public void setFitScreen(boolean b) {
        this.fitScreen = b;
    }

    public boolean isFitScreen() {
        return this.fitScreen;
    }

    public void setCartesian(boolean b) {
        if (this.cartesian == b) {
            return;
        }
        this.cartesian = b;
        if (this.prevAzimuthZone != -1 && this.prevInclineZone != -1) {
            this.reconfigure(this.prevAzimuthZone, this.prevInclineZone);
        }
    }

    public boolean getCartesian() {
        return this.cartesian;
    }

    protected BoundingBox computeBoundingBox() {
        Channel channel = ((NetworkRoot)this.getNetworkRoot()).getChannel();
        BoundingBox tempBbox = new BoundingBox();
        Vec3d minimum = tempBbox.getMinimum();
        Vec3d maximum = tempBbox.getMaximum();
        minimum.x = 0.0;
        minimum.y = 0.0;
        minimum.z = 0.0;
        maximum.x = this.getSize().x;
        maximum.y = this.getSize().y;
        maximum.z = this.getSize().z;
        if (this.xAxis != null && this.yAxis != null) {
            AxisMetrics amx = ((RectangularAxis)this.xAxis).getMetrics(channel);
            AxisMetrics amy = ((RectangularAxis)this.yAxis).getMetrics(channel);
            double titleHeight = this.getAxisTitleHeight(channel, this.yAxis);
            if (!this.isOblique()) {
                maximum.x += amy.getWidth();
                maximum.y += titleHeight;
                minimum.y -= amx.getHeight();
            } else {
                double te = this.getAxisTitleWidth(channel, this.zAxis);
                double le = this.getAxisLabelWidth(channel, this.zAxis);
                double titleLabelExtender = Math.max(te += titleHeight / 4.0, le);
                maximum.y += amy.getHighExtender();
                minimum.y -= Math.max(amx.getHeight(), amy.getLowExtender());
                if (this.getObliqueAngle() >= 0.0 && this.getObliqueAngle() <= 90.0) {
                    minimum.x -= Math.max(amy.getWidth(), amx.getLowExtender());
                    maximum.x += Math.max(Math.max(titleLabelExtender, amy.getWidth()), amx.getHighExtender());
                } else {
                    minimum.x -= Math.max(Math.max(titleLabelExtender, amy.getWidth()), amx.getLowExtender());
                    maximum.x += Math.max(amy.getWidth(), amx.getHighExtender());
                }
            }
        }
        return tempBbox;
    }

    private String findLongestLabel(AAxis axis) {
        String result = "";
        AInitAction ia = new AInitAction();
        axis.labels.init(ia);
        int n = ia.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                String l = axis.labels.getValue(i);
                if (l.length() <= result.length()) continue;
                result = l;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return result;
    }

    private double getAxisTitleWidth(Channel channel, AAxis axis) {
        AxisStyle style = axis.getStyle();
        String text = axis.title.getValue();
        if (!style.isTitleOn() || text == null || text.length() == 0) {
            return 0.0;
        }
        TextStyle tStyle = style.getTitleStyle();
        Bbox titleBox = new Bbox();
        channel.glSelect2DFont(tStyle.getFont());
        channel.glGetText2DBbox(text, 0.0, 0.0, 0.0, (int)tStyle.getAngle(), titleBox);
        return titleBox.xmax - titleBox.xmin;
    }

    private double getAxisLabelWidth(Channel channel, AAxis axis) {
        AxisStyle style = axis.getStyle();
        String text = this.findLongestLabel(axis);
        if (!style.isLabelsOn() || text == null || text.length() == 0) {
            return 0.0;
        }
        TextStyle labelStyle = style.getLabelStyle();
        Bbox tempBbox = new Bbox();
        channel.glSelect2DFont(labelStyle.getFont());
        channel.glGetText2DBbox(text, 0.0, 0.0, 1000.0, (int)labelStyle.getAngle(), tempBbox);
        return tempBbox.xmax - tempBbox.xmin;
    }

    private double getAxisTitleHeight(Channel channel, AAxis axis) {
        AxisStyle style = axis.getStyle();
        String text = axis.title.getValue();
        if (!style.isTitleOn() || text == null || text.length() == 0) {
            return 0.0;
        }
        TextStyle tStyle = style.getTitleStyle();
        Bbox titleBox = new Bbox();
        channel.glSelect2DFont(tStyle.getFont());
        channel.glGetText2DBbox(text, 0.0, 0.0, 0.0, (int)tStyle.getAngle(), titleBox);
        return titleBox.ymax - titleBox.ymin;
    }

    public Color getTicColorX() {
        return this.ticColorX;
    }

    public void setTicColorX(Color ticColorX) {
        this.ticColorX = ticColorX;
        this.connectAxisAndGridPipes();
    }

    public Color getTicColorY() {
        return this.ticColorY;
    }

    public void setTicColorY(Color ticColorY) {
        this.ticColorY = ticColorY;
        this.connectAxisAndGridPipes();
    }

    public Color getTicColorZ() {
        return this.ticColorZ;
    }

    public void setTicColorZ(Color ticColorZ) {
        this.ticColorZ = ticColorZ;
        this.connectAxisAndGridPipes();
    }

    public void updateGUI(int azimuthZone, int inclineZone) {
    }

    protected ZoneDataModel getXZoneDataModel() {
        return this.xZoneDataModel;
    }

    protected ZoneDataModel getYZoneDataModel() {
        return this.yZoneDataModel;
    }

    protected ZoneDataModel getZZoneDataModel() {
        return this.zZoneDataModel;
    }

    public String[] getAxisFittingAlgorithm() {
        return this.axisFittingAlgorithm;
    }

    public void setAxisFittingAlgorithm(String[] axisFittingAlgorithm) {
        this.axisFittingAlgorithm = axisFittingAlgorithm;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoomFactor) {
        this.zoom = zoomFactor;
    }

    public void setDisplayZAxis(boolean display) {
        this.displayZAxis = display;
    }

    public boolean isDisplayZAxis() {
        return this.displayZAxis;
    }

    protected static class XZoneDataModel
    extends ZoneDataModel {
        private static final long serialVersionUID = 1L;

        public XZoneDataModel() {
            Object[][] data = new Object[][]{{new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}};
            this.setDataVector(data, this.columnNames);
        }
    }

    protected static class ZoneDataModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        protected String[] columnNames = new String[]{"transX", "transY", "transZ", "labelVJust", "labelHJust", "titleHJust", "titleVJust", "titlePosition", "isPrimary", "labelOrientation"};
        private int currentRow;

        protected ZoneDataModel() {
        }

        public Class getColumnClass(int column) {
            return Double.class;
        }

        public void setCurrentZones(int azimuthZone, int inclineZone) {
            this.currentRow = this.computeZoneDataRow(azimuthZone, inclineZone);
        }

        public double getTranslationX() {
            return (Double)this.getValueAt(this.currentRow, 0);
        }

        public void setTranslationX(double d) {
            this.setValueAt(new Double(d), this.currentRow, 0);
        }

        public double getTranslationY() {
            return (Double)this.getValueAt(this.currentRow, 1);
        }

        public void setTranslationY(double d) {
            this.setValueAt(new Double(d), this.currentRow, 1);
        }

        public double getTranslationZ() {
            return (Double)this.getValueAt(this.currentRow, 2);
        }

        public void setTranslationZ(double d) {
            this.setValueAt(new Double(d), this.currentRow, 2);
        }

        public int getLabelVJust() {
            return ((Double)this.getValueAt(this.currentRow, 3)).intValue();
        }

        public void setLabelVJust(int d) {
            this.setValueAt(new Double(d), this.currentRow, 3);
        }

        public int getLabelHJust() {
            return ((Double)this.getValueAt(this.currentRow, 4)).intValue();
        }

        public void setLabelHJust(int d) {
            this.setValueAt(new Double(d), this.currentRow, 4);
        }

        public int getTitleHJust() {
            return ((Double)this.getValueAt(this.currentRow, 5)).intValue();
        }

        public void setTitleHJust(int d) {
            this.setValueAt(new Double(d), this.currentRow, 5);
        }

        public int getTitleVJust() {
            return ((Double)this.getValueAt(this.currentRow, 6)).intValue();
        }

        public void setTitleVJust(int d) {
            this.setValueAt(new Double(d), this.currentRow, 6);
        }

        public int getTitlePosition() {
            return ((Double)this.getValueAt(this.currentRow, 7)).intValue();
        }

        public void setTitlePosition(int d) {
            this.setValueAt(new Double(d), this.currentRow, 7);
        }

        public boolean isPrimary() {
            return (Double)this.getValueAt(this.currentRow, 8) > 0.0;
        }

        public void setPrimary(boolean b) {
            this.setValueAt(new Double(b ? 1.0 : 0.0), this.currentRow, 8);
        }

        public int getLabelOrientation() {
            return ((Double)this.getValueAt(this.currentRow, 9)).intValue();
        }

        public void setLabelOrientation(int labelOrientation) {
            this.setValueAt(new Double(labelOrientation), this.currentRow, 9);
        }

        public int computeZoneDataRow(int azimuthZone, int inclineZone) {
            return azimuthZone * 8 + inclineZone;
        }

        public String generateCode() {
            StringBuffer sb = new StringBuffer();
            sb.append("data=new Object[][]{\n");
            for (int row = 0; row < this.getRowCount(); ++row) {
                sb.append("{");
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    Double d = (Double)this.getValueAt(row, column);
                    sb.append("new Double(" + d + "),");
                }
                sb.append("},\n");
            }
            sb.append("};\n");
            return sb.toString();
        }

        public void load(TableModel tableModel) {
            if (this.getRowCount() != tableModel.getRowCount() || this.getColumnCount() != tableModel.getColumnCount()) {
                System.out.println("bad model");
                return;
            }
            for (int row = 0; row < this.getRowCount(); ++row) {
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    this.setValueAt(tableModel.getValueAt(row, column), row, column);
                }
            }
        }
    }

    protected static class YZoneDataModel
    extends ZoneDataModel {
        private static final long serialVersionUID = 1L;

        public YZoneDataModel() {
            Object[][] data = new Object[][]{{new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(1.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(3.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(3.0)}};
            this.setDataVector(data, this.columnNames);
        }
    }

    protected static class ZZoneDataModel
    extends ZoneDataModel {
        private static final long serialVersionUID = 1L;

        public ZZoneDataModel() {
            Object[][] data = new Object[][]{{new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(2.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(1.0), new Double(2.0), new Double(2.0), new Double(1.0), new Double(1.0), new Double(0.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(0.0), new Double(2.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(2.0), new Double(0.0), new Double(2.0)}, {new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(1.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(1.0), new Double(0.0), new Double(0.0), new Double(3.0), new Double(2.0), new Double(2.0), new Double(3.0), new Double(1.0), new Double(1.0), new Double(2.0)}, {new Double(0.0), new Double(1.0), new Double(0.0), new Double(3.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(2.0)}};
            this.setDataVector(data, this.columnNames);
        }
    }
}

