/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.util.UsageVersion;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataChangeManagementUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class RootPropertiesModel
extends AbstractPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(RootPropertiesModel.class);
    protected static final int ROOT_PROPERTIES_COUNT = 10;
    protected int m_iName;
    protected int m_iDescription;
    protected int m_iFolderLocation;
    protected int m_iCheckedOutBy;
    protected int m_iLastModifiedBy;
    protected int m_iDateUpdated;
    protected int m_iDateCreated;
    protected int m_iLogicalType;
    protected int m_iMetadataID;
    protected int m_iUsageVersion;
    protected Object[] m_aTempValues = new Object[this.getNumberOfProperties()];
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;

    public RootPropertiesModel(Root mdoObject) {
        super(mdoObject);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iLastModifiedBy = 4;
        this.m_iDateUpdated = 5;
        this.m_iDateCreated = 6;
        this.m_iLogicalType = 7;
        this.m_iMetadataID = 8;
        this.m_iUsageVersion = 9;
    }

    @Override
    protected void initializeProperties() {
        this.setProperty(this.m_iName, bundle.getString("RootPropertiesModel.Name.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDescription, bundle.getString("RootPropertiesModel.Description.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iFolderLocation, bundle.getString("RootPropertiesModel.FolderLocation.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iCheckedOutBy, bundle.getString("RootPropertiesModel.CheckedOutBy.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLastModifiedBy, bundle.getString("RootPropertiesModel.LastModifiedBy.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDateUpdated, bundle.getString("RootPropertiesModel.DateUpdated.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDateCreated, bundle.getString("RootPropertiesModel.DateCreated.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLogicalType, bundle.getString("RootPropertiesModel.LogicalType.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iMetadataID, bundle.getString("RootPropertiesModel.MetadataID.txt"), null, RootPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iUsageVersion, bundle.getString("RootPropertiesModel.UsageVersion.txt"), null, RootPropertiesModel.getDefaultRenderer());
    }

    @Override
    public int getNumberOfProperties() {
        return 10;
    }

    @Override
    public void populate() throws MdException, RemoteException {
        StringBuffer sbTemplate = new StringBuffer();
        sbTemplate.append("<Templates>");
        sbTemplate.append(this.getPopulateTemplate());
        sbTemplate.append("</Templates>");
        MdOMIUtil mou = Workspace.getMdFactory().getOMIUtil();
        mou.getMetadataAllDepths((CMetadata)this.m_mdoObject, null, this.getPopulateAttributes(), sbTemplate.toString(), 67133468);
    }

    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<PropertySet><Properties/></PropertySet>");
            template.append("<ResponsibleParty><Persons/></ResponsibleParty>");
            template.append("<Tree Name=\"\"><ParentTree/><SoftwareComponents/></Tree>");
            s_strTemplate = template.toString();
        }
        return s_strTemplate;
    }

    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.add("PropertySets");
            s_lAttributes.add("ResponsibleParties");
            s_lAttributes.add("Trees");
        }
        return s_lAttributes;
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        PrimaryType type;
        String publicType;
        this.m_aTempValues[this.m_iName] = this.m_mdoObject.getName();
        this.m_aTempValues[this.m_iDescription] = this.m_mdoObject.getDesc();
        this.m_aTempValues[this.m_iFolderLocation] = WsMetadataUtil.getFolderLocationForMetadata((Root)this.m_mdoObject);
        this.m_aTempValues[this.m_iCheckedOutBy] = this.m_mdoObject.isCheckedOut() ? WsMetadataChangeManagementUtil.getNameOfOwnerFor((String)this.m_mdoObject.getLockedBy()) : null;
        this.m_aTempValues[this.m_iLastModifiedBy] = WsMetadataUtil.getModifiedByUserFor((Root)this.m_mdoObject);
        String modifiedByProduct = WsMetadataUtil.getModifiedByProductFor((Root)this.m_mdoObject);
        this.m_aTempValues[this.m_iDateUpdated] = modifiedByProduct == null || modifiedByProduct.length() == 0 ? WsMetadataUtil.formatDate((String)this.m_mdoObject.getMetadataUpdated(), null) : bundle.formatString("RootPropertiesModel.DateUpdated.Time.fmt", (Object)WsMetadataUtil.formatDate((String)this.m_mdoObject.getMetadataUpdated(), null), (Object)modifiedByProduct);
        this.m_aTempValues[this.m_iDateCreated] = WsMetadataUtil.formatDate((String)this.m_mdoObject.getMetadataCreated(), null);
        this.m_aTempValues[this.m_iLogicalType] = this.m_mdoObject instanceof PrimaryType ? ((publicType = (type = (PrimaryType)this.m_mdoObject).getPublicType()) != null && publicType.length() > 0 ? Factory.getInstance().getTypeInterface(publicType).getDisplayType() : "") : "";
        this.m_aTempValues[this.m_iMetadataID] = this.m_mdoObject.getFQID();
        this.m_aTempValues[this.m_iUsageVersion] = UsageVersion.decode((double)this.m_mdoObject.getUsageVersion()).toString();
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            this.setPropertyValue(i, this.m_aTempValues[i]);
        }
    }

    @Override
    public void startUpdatePropertyThreads() {
        try {
            for (int i = 0; i < this.getNumberOfProperties(); ++i) {
                Thread t = this.m_aUpdatePropertyThreads[i];
                if (t == null) continue;
                t.start();
                t.join();
            }
        }
        catch (InterruptedException e) {
            if (this.isDisplayErrors()) {
                MessageUtil.displayMessage((String)e.getMessage(), (int)0);
            }
            Workspace.getDefaultLogger().error((Object)bundle.formatString("RootPropertiesModel.UpdatingProperties.InterruptedException.fmt", (Object)e.getLocalizedMessage()));
        }
    }

    protected String createDelimitedString(List values, String delimiter) {
        if (values == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int nValues = values.size();
        for (int i = 0; i < nValues; ++i) {
            sb.append(values.get(i));
            if (i >= nValues - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    protected String createCommaDelimitedString(List values) {
        return this.createDelimitedString(values, ", ");
    }
}

