/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.job.transforms.TeradataTableLoaderTransformModel;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.properties.BrowseExternalFilePropertiesModel;
import com.sas.wadmin.visuals.properties.BrowseGeneratedTransformPropertiesModel;
import com.sas.wadmin.visuals.properties.BrowseJobPropertiesModel;
import com.sas.wadmin.visuals.properties.BrowseLibraryPropertiesModel;
import com.sas.wadmin.visuals.properties.BrowseMessageQueuePropertiesModel;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.wadmin.visuals.properties.BrowseTablePropertiesModel;
import com.sas.wadmin.visuals.properties.ExternalTablePropertiesModel;
import com.sas.wadmin.visuals.properties.GeneratedTransformPropertiesModel;
import com.sas.wadmin.visuals.properties.JobPropertiesModel;
import com.sas.wadmin.visuals.properties.JobTransformPropertiesModel;
import com.sas.wadmin.visuals.properties.LibraryPropertiesModel;
import com.sas.wadmin.visuals.properties.PhysicalTablePropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesModel;
import com.sas.wadmin.visuals.properties.PrototypePropertiesModel;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.wadmin.visuals.properties.TeradataTableLoaderTransformPropertiesModel;
import com.sas.wadmin.visuals.properties.TransformPropertiesModel;
import com.sas.wadmin.visuals.properties.TransformationPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.EFIDataModel;
import com.sas.workspace.models.SimpleBrowseObject;
import java.rmi.RemoteException;

public class PropertiesModelFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(PropertiesModelFactory.class);

    private PropertiesModelFactory() {
    }

    public static PropertiesModel createModel(Object obj) {
        try {
            if (obj instanceof SimpleBrowseObject) {
                SimpleBrowseObject simpleObject = (SimpleBrowseObject)obj;
                String sPublicType = ((SimpleBrowseObject)obj).getPublicType();
                if ("Job".equals(sPublicType)) {
                    return new BrowseJobPropertiesModel(simpleObject);
                }
                if ("ExternalFile".equals(sPublicType)) {
                    return new BrowseExternalFilePropertiesModel(simpleObject);
                }
                if ("Table".equals(sPublicType)) {
                    return new BrowseTablePropertiesModel((SimpleBrowseObject)obj);
                }
                if ("GeneratedTransform".equals(sPublicType)) {
                    return new BrowseGeneratedTransformPropertiesModel(simpleObject);
                }
                if ("Library".equals(sPublicType)) {
                    return new BrowseLibraryPropertiesModel(simpleObject);
                }
                if ("MessageQueue".equals(sPublicType)) {
                    return new BrowseMessageQueuePropertiesModel(simpleObject);
                }
                return new BrowsePropertiesModel(simpleObject);
            }
            if (obj instanceof GeneratedTransformModel) {
                return new GeneratedTransformPropertiesModel((GeneratedTransformModel)obj);
            }
            if (obj instanceof TeradataTableLoaderTransformModel) {
                return new TeradataTableLoaderTransformPropertiesModel((TeradataTableLoaderTransformModel)obj);
            }
            if (obj instanceof ITransform) {
                return new JobTransformPropertiesModel((ITransform)obj);
            }
            if (obj instanceof Root) {
                String sType = ((Root)obj).getCMetadataType();
                if (sType.equals("Job")) {
                    return new JobPropertiesModel((Job)obj);
                }
                if ("PhysicalTable".equals(sType) || "WorkTable".equals(sType)) {
                    return new PhysicalTablePropertiesModel((PhysicalTable)obj);
                }
                if (sType.equals("WorkTable")) {
                    return new PhysicalTablePropertiesModel((PhysicalTable)obj);
                }
                if (sType.equals("ExternalTable")) {
                    try {
                        if (!EFIDataModel.isLegacyEFIObject((ExternalTable)((ExternalTable)obj))) {
                            return new ExternalTablePropertiesModel((ExternalTable)obj);
                        }
                    }
                    catch (MdException me) {
                        Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesModelFactory.OldEFICheck.MdException.fmt", (Object)me.getLocalizedMessage()));
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    return new RootPropertiesModel((Root)obj);
                }
                if (sType.equals("SASLibrary")) {
                    return new LibraryPropertiesModel((SASLibrary)obj);
                }
                if (sType.equals("Transformation")) {
                    return new TransformationPropertiesModel((Transformation)obj);
                }
                if (sType.equals("Prototype")) {
                    return new PrototypePropertiesModel((Prototype)obj);
                }
                return new RootPropertiesModel((Root)obj);
            }
            if (obj instanceof TransformInterface) {
                return new TransformPropertiesModel((TransformInterface)obj);
            }
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }
}

