/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.AbstractTransform;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdObjectStoreImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.jobeditor.diagram.ISASApplicationServerDiagramPanel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.properties.JobPropertiesModel;
import com.sas.wadmin.visuals.properties.PhysicalTablePropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesModel;
import com.sas.wadmin.visuals.properties.PropertiesModelFactory;
import com.sas.wadmin.visuals.properties.PropertiesTable;
import com.sas.wadmin.visuals.properties.PropertiesTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ProjectEventListener;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.connection.ConnectionChangeListener;
import com.sas.workspace.connection.ConnectionManager;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class PropertiesAdapter
implements WsSelectionChangedListener {
    private static WAdminResource bundle = WAdminResource.getBundle(PropertiesAdapter.class);
    private PropertiesTable m_tblProperties;
    private Object m_objActive;
    private WsSelectionProvider m_selectionProvider;
    private boolean m_bDisplayErrors;
    private MdFactoryListener m_lsrFactory;
    private ProjectEventListener m_lsrProject;
    private ConnectionChangeListener m_lsrConnection;

    public PropertiesAdapter(PropertiesTable tblProperties) {
        this(tblProperties, true);
    }

    public PropertiesAdapter(PropertiesTable tblProperties, boolean displayErrors) {
        this.m_tblProperties = tblProperties;
        this.m_bDisplayErrors = displayErrors;
        this.installListeners();
    }

    protected void updatePropertiesModelFor(Object obj) {
        cPopulateThread t = new cPopulateThread(obj);
        t.start();
    }

    public Object getActiveObject() {
        return this.m_objActive;
    }

    public void selectionChanged(WsSelectionChangedEvent e) {
        Object[] selectedObjects = null;
        if (this.m_selectionProvider != null) {
            selectedObjects = this.m_selectionProvider.getSelectedObjects();
        }
        if (selectedObjects == null || selectedObjects.length != 1) {
            this.m_objActive = null;
            this.resetPropertiesWindow();
        } else {
            this.m_objActive = selectedObjects[0];
            this.updatePropertiesModelFor(this.m_objActive);
        }
    }

    public void setSelectionProvider(WsSelectionProvider provider) {
        if (provider == this.m_selectionProvider) {
            return;
        }
        if (provider != null) {
            this.m_selectionProvider = provider;
            this.m_selectionProvider.addSelectionChangedListener((WsSelectionChangedListener)this);
            Object[] selectedObjects = this.m_selectionProvider.getSelectedObjects();
            if (selectedObjects != null && selectedObjects.length == 1 && this.m_objActive != selectedObjects[0]) {
                this.m_objActive = selectedObjects[0];
                this.updatePropertiesModelFor(this.m_objActive);
            }
        } else {
            this.m_selectionProvider.removeSelectionChangedListener((WsSelectionChangedListener)this);
            this.m_selectionProvider = null;
            this.m_objActive = null;
        }
    }

    public void resetPropertiesWindow() {
        this.m_tblProperties.setPropertiesModel(null);
        try {
            ((PropertiesTableModel)((Object)this.m_tblProperties.getModel())).moveDataToModel();
        }
        catch (MdException me) {
            if (this.m_bDisplayErrors) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Writing");
            } else {
                Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesAdapter.ClearingTable.MdException.fmt", (Object)me.getLocalizedMessage()));
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void refreshCurrentObject() {
        if (this.m_objActive != null) {
            this.updatePropertiesModelFor(this.m_objActive);
        }
    }

    private void clearPropertiesWindow() {
        this.m_objActive = null;
        this.resetPropertiesWindow();
    }

    protected MdFactoryListener createFactoryListener() {
        return new cFactoryListener();
    }

    protected ProjectEventListener createProjectListener() {
        return new cProjectListener();
    }

    protected ConnectionChangeListener createConnectionListener() {
        return new cConnectionListener();
    }

    protected void installListeners() {
        this.m_lsrFactory = this.createFactoryListener();
        this.m_lsrProject = this.createProjectListener();
        this.m_lsrConnection = this.createConnectionListener();
        Workspace.getWorkspace().getConnectionManager().addConnectionChangeListener(this.m_lsrConnection);
        ProjectUtil.addProjectEventListener((ProjectEventListener)this.m_lsrProject);
    }

    protected void uninstallListeners() {
        ProjectUtil.removeProjectEventListener((ProjectEventListener)this.m_lsrProject);
        this.m_lsrProject = null;
    }

    protected void updateForChangeEvent(List items) {
        if (this.m_objActive == null) {
            return;
        }
        String sObjectID = null;
        if (this.m_objActive instanceof SimpleObject) {
            sObjectID = ((SimpleObject)this.m_objActive).getID();
        } else if (this.m_objActive instanceof SimpleLogicalObjectInterface) {
            sObjectID = ((SimpleLogicalObjectInterface)this.m_objActive).getID();
        }
        if (sObjectID == null) {
            return;
        }
        if (items.contains(sObjectID) || this.isCurrentObjectInProjectEventList(items)) {
            this.updatePropertiesModelFor(this.m_objActive);
        }
    }

    protected boolean isCurrentObjectInProjectEventList(List items) {
        if (this.m_objActive == null || !(this.m_objActive instanceof LogicalObjectInterface)) {
            return false;
        }
        try {
            String currentFQID = ((LogicalObjectInterface)this.m_objActive).getID();
            for (int i = 0; i < items.size(); ++i) {
                Object obj = items.get(i);
                if (!(obj instanceof Root)) continue;
                Root root = (Root)obj;
                if (root.getChangeState().indexOf(currentFQID) >= 0) {
                    return true;
                }
                if (!root.getFQID().equals(currentFQID)) continue;
                return true;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    private class cPopulateThread
    extends Thread {
        Object m_object;
        MdObjectStore m_store;

        public cPopulateThread(Object obj) {
            super("basic properties populate thread for " + obj);
            this.m_object = obj;
            this.m_store = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.m_object == null) {
                    return;
                }
                PropertiesModel mdlProperties = null;
                if (this.m_object instanceof AbstractTransform) {
                    mdlProperties = PropertiesModelFactory.createModel(this.m_object);
                } else if (this.m_object instanceof SimpleBrowseObject) {
                    mdlProperties = PropertiesModelFactory.createModel(this.m_object);
                } else if (this.m_object instanceof SimpleObject) {
                    SimpleObject simpleObject = (SimpleObject)this.m_object;
                    MdFactory factory = Workspace.getMdFactory();
                    this.m_store = factory.createObjectStore(null, "PropertiesAdapter " + simpleObject.getName());
                    MdObjectStoreImpl currentStore = (MdObjectStoreImpl)this.m_store;
                    currentStore.getOwningStore().removeMdStoreListener((MdStoreListener)this.m_store);
                    currentStore.getOwningStore().removeChildStore((MdStore)this.m_store);
                    Root mdoReal = ObjectConverter.getInstance().convertToJOMAObject(this.m_store, simpleObject);
                    if (this.m_object instanceof IPhysicalTable) {
                        mdlProperties = new PhysicalTablePropertiesModel((PhysicalTable)mdoReal, (IPhysicalTable)this.m_object);
                    } else if (this.m_object instanceof IJob) {
                        mdlProperties = new JobPropertiesModel((Job)mdoReal, (IJob)this.m_object);
                    } else if (mdoReal != null) {
                        mdlProperties = PropertiesModelFactory.createModel(mdoReal);
                    }
                } else if (this.m_object instanceof TransformInterface) {
                    mdlProperties = PropertiesModelFactory.createModel(this.m_object);
                }
                if (mdlProperties instanceof PhysicalTablePropertiesModel && PropertiesAdapter.this.m_selectionProvider instanceof ISASApplicationServerDiagramPanel && this.m_object instanceof IWorkTable) {
                    WsAppServer server = ((ISASApplicationServerDiagramPanel)PropertiesAdapter.this.m_selectionProvider).getSASAppServer();
                    ((PhysicalTablePropertiesModel)mdlProperties).setAppServer(server);
                }
                if (mdlProperties != null) {
                    mdlProperties.setDisplayErrors(PropertiesAdapter.this.m_bDisplayErrors);
                    if (this.m_object.equals(PropertiesAdapter.this.m_objActive)) {
                        try {
                            mdlProperties.populate();
                            mdlProperties.loadPropertyValues();
                            SwingUtilities.invokeAndWait(new cUpdateTableRunnable(mdlProperties, this.m_object));
                            mdlProperties.startUpdatePropertyThreads();
                        }
                        catch (MdException me) {
                            if (PropertiesAdapter.this.m_bDisplayErrors) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                            } else {
                                Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesAdapter.LoadingProperties.MdException.fmt", (Object)me.getLocalizedMessage()));
                            }
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                        catch (InterruptedException ie) {
                            if (PropertiesAdapter.this.m_bDisplayErrors) {
                                MessageUtil.displayMessage((String)ie.getMessage(), (int)0);
                            } else {
                                Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesAdapter.LoadingProperties.InterruptedException.fmt", (Object)ie.getLocalizedMessage()));
                            }
                        }
                        catch (InvocationTargetException ite) {
                            if (PropertiesAdapter.this.m_bDisplayErrors) {
                                MessageUtil.displayMessage((String)ite.getMessage(), (int)0);
                            } else {
                                Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesAdapter.LoadingProperties.InvocationTargetException.fmt", (Object)ite.getLocalizedMessage()));
                                ite.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            if (PropertiesAdapter.this.m_bDisplayErrors) {
                                MessageUtil.displayMessage((String)e.getMessage(), (int)0);
                            } else {
                                Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesAdapter.LoadingProperties.InvocationTargetException.fmt", (Object)e.getLocalizedMessage()));
                            }
                        }
                        finally {
                            if (this.m_store != null) {
                                this.m_store.dispose();
                                this.m_store = null;
                            }
                        }
                    }
                }
                if (this.m_store != null) {
                    this.m_store.dispose();
                    this.m_store = null;
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private class cFactoryListener
    implements MdFactoryListener {
        private cFactoryListener() {
        }

        public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
        }

        public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
        }

        public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
            PropertiesAdapter.this.updateForChangeEvent(Arrays.asList(e.getObjectIDs()));
        }
    }

    private class cProjectListener
    implements ProjectEventListener {
        private cProjectListener() {
        }

        public void objectsCheckedOut(ChangeEvent e, Vector objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void objectsCheckedIn(ChangeEvent e, Vector objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void objectsDestroyed(ChangeEvent e, Vector object) {
        }

        public void objectsFetched(ChangeEvent e, Vector objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void objectsCopied(ChangeEvent e, Vector objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void objectsLocked(ChangeEvent e, Vector objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void objectsUnLocked(ChangeEvent e, Vector objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void objectsUndoCheckout(ChangeEvent e, Vector objects) {
        }

        public void objectsNewAdded(ChangeEvent e, ArrayList objects) {
            PropertiesAdapter.this.updateForChangeEvent(objects);
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    private class cConnectionListener
    implements ConnectionChangeListener {
        private cConnectionListener() {
        }

        public void connectionClosing(ConnectionManager connectionManager) {
            MdFactory factory = connectionManager.getMetadataFactory();
            if (factory != null) {
                try {
                    factory.removeMdFactoryListener(PropertiesAdapter.this.m_lsrFactory);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            PropertiesAdapter.this.clearPropertiesWindow();
        }

        public void connectionOpened(ConnectionManager connectionManager) {
            MdFactory factory = connectionManager.getMetadataFactory();
            if (factory != null) {
                try {
                    factory.addMdFactoryListener(PropertiesAdapter.this.m_lsrFactory);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    private class cUpdateTableRunnable
    implements Runnable {
        PropertiesModel m_mdlProperties;
        Object m_object;

        public cUpdateTableRunnable(PropertiesModel mdl, Object obj) {
            this.m_mdlProperties = mdl;
            this.m_object = obj;
        }

        @Override
        public void run() {
            if (this.m_object != null && this.m_object.equals(PropertiesAdapter.this.m_objActive)) {
                try {
                    this.m_mdlProperties.updatePropertyValues();
                    PropertiesAdapter.this.m_tblProperties.setPropertiesModel(this.m_mdlProperties);
                    ((PropertiesTableModel)((Object)PropertiesAdapter.this.m_tblProperties.getModel())).moveDataToModel();
                }
                catch (MdException me) {
                    if (PropertiesAdapter.this.m_bDisplayErrors) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    } else {
                        Workspace.getDefaultLogger().error((Object)bundle.formatString("PropertiesAdapter.UpdatingTable.MdException.fmt", (Object)me.getLocalizedMessage()));
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }
}

