/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class JobTransformPropertiesModel
extends AbstractPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(JobTransformPropertiesModel.class);
    private ITransform m_transform;
    protected static final int JOB_TRANSFORM_PROPERTIES_COUNT = 9;
    protected int m_iName;
    protected int m_iDescription;
    protected int m_iNodeType;
    protected int m_iUserWritten;
    protected int m_iDiagnostic;
    protected int m_iCheckpoint;
    protected int m_iRunAlways;
    protected int m_iControlOrder;
    protected int m_iID;

    public JobTransformPropertiesModel(ITransform transform) {
        this.m_transform = transform;
    }

    @Override
    public int getNumberOfProperties() {
        return 9;
    }

    @Override
    protected void initializeProperties() {
        this.setProperty(this.m_iName, bundle.getString("JobTransformPropertiesModel.Name.txt"), null, JobTransformPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDescription, bundle.getString("JobTransformPropertiesModel.Description.txt"), null, JobTransformPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNodeType, bundle.getString("JobTransformPropertiesModel.NodeType.txt"), null, JobTransformPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iUserWritten, bundle.getString("JobTransformPropertiesModel.UserWritten.txt"), null, JobTransformPropertiesModel.getDefaultBooleanRenderer());
        this.setProperty(this.m_iDiagnostic, bundle.getString("JobTransformPropertiesModel.DiagnosticMode.txt"), null, JobTransformPropertiesModel.getDefaultBooleanRenderer());
        this.setProperty(this.m_iCheckpoint, bundle.getString("JobTransformPropertiesModel.Checkpoint.txt"), null, JobTransformPropertiesModel.getDefaultBooleanRenderer());
        this.setProperty(this.m_iRunAlways, bundle.getString("JobTransformPropertiesModel.RunAlways.txt"), null, JobTransformPropertiesModel.getDefaultBooleanRenderer());
        this.setProperty(this.m_iControlOrder, bundle.getString("JobTransformPropertiesModel.ControlOrder.txt"), null, JobTransformPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iID, bundle.getString("RootPropertiesModel.MetadataID.txt"), null, JobTransformPropertiesModel.getDefaultRenderer());
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iNodeType = 2;
        this.m_iUserWritten = 3;
        this.m_iDiagnostic = 4;
        this.m_iCheckpoint = 5;
        this.m_iRunAlways = 6;
        this.m_iControlOrder = 7;
        this.m_iID = 8;
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException {
    }

    @Override
    public void populate() throws MdException, RemoteException {
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
        int controlFlowIndex;
        this.setPropertyValue(this.m_iName, this.m_transform.getName());
        this.setPropertyValue(this.m_iDescription, this.m_transform.getDescription());
        this.setPropertyValue(this.m_iNodeType, this.m_transform.getDisplayType());
        this.setPropertyValue(this.m_iUserWritten, this.m_transform.isUsingUserWrittenCode());
        this.setPropertyValue(this.m_iDiagnostic, this.m_transform.isCollectingDiagnostics());
        this.setPropertyValue(this.m_iCheckpoint, this.m_transform.isCheckpointEnabled());
        this.setPropertyValue(this.m_iRunAlways, this.m_transform.isRunAlways());
        IJob job = this.m_transform.getJob();
        int n = controlFlowIndex = null != job ? job.getControlOrderedTransformsList().indexOf(this.m_transform) : -1;
        if (controlFlowIndex < 0) {
            this.setPropertyValue(this.m_iControlOrder, "");
        } else {
            this.setPropertyValue(this.m_iControlOrder, String.valueOf(this.m_transform.getJob().getControlOrderedTransformsList().indexOf(this.m_transform) + 1));
        }
        this.setPropertyValue(this.m_iID, this.m_transform.getID());
    }
}

