/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdObjectStoreImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.properties.BrowseObjectUtil;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.metadata.WsMetadataPhysicalTableUtil;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class BrowseTablePropertiesModel
extends BrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowseTablePropertiesModel.class);
    protected static final int PHYSICALTABLE_PROPERTIES_COUNT = 17;
    protected int m_iTableName;
    protected int m_iLibrary;
    protected int m_iDBMS;
    protected int m_iNumberOfRows;
    protected int m_iNumberOfColumns;
    protected static int m_iRowCountThreadsRunning = 0;
    protected static final int MAX_ROW_COUNT_THREADS = 5;
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;

    public BrowseTablePropertiesModel(SimpleBrowseObject mdoObject) {
        super(mdoObject);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iTableName = 4;
        this.m_iLibrary = 5;
        this.m_iDBMS = 6;
        this.m_iNumberOfRows = 7;
        this.m_iNumberOfColumns = 8;
        this.m_iLastModifiedBy = 9;
        this.m_iDateUpdated = 10;
        this.m_iDateCreated = 11;
        this.m_iDateArchived = 12;
        this.m_iArchiveName = 13;
        this.m_iLogicalType = 14;
        this.m_iMetadataID = 15;
        this.m_iUsageVersion = 16;
    }

    @Override
    public int getNumberOfProperties() {
        return 17;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("TablePackage");
            s_lAttributes.add("Columns");
            s_lAttributes.add("Prompts");
        }
        return s_lAttributes;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<DataTable><Columns/><TablePackage/></DataTable>");
            template.append("<SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary>");
            template.append("<DatabaseSchema><DeployedComponents/><UsedByPackages/></DatabaseSchema>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    public void createUpdatePropertyThreads() {
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        boolean bRowCount = defaultsFile.getPropertyBoolean("QuickProperties.RowCount", false);
        if (bRowCount) {
            this.m_aUpdatePropertyThreads[this.m_iNumberOfRows] = this.createRowCountThread();
        }
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iTableName, bundle.getString("PhysicalTablePropertiesModel.TableName.txt"), null, BrowseTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLibrary, bundle.getString("PhysicalTablePropertiesModel.Library.txt"), null, BrowseTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDBMS, bundle.getString("PhysicalTablePropertiesModel.DBMS.txt"), null, BrowseTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNumberOfRows, bundle.getString("PhysicalTablePropertiesModel.NumberOfRows.txt"), null, BrowseTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNumberOfColumns, bundle.getString("PhysicalTablePropertiesModel.NumberOfColumns.txt"), null, BrowseTablePropertiesModel.getDefaultRenderer());
    }

    protected long getRowCountLong(PhysicalTable table) throws MdException, RemoteException, WsAppServerFailException, WsAppServerLibraryException, SQLException, WsAppServerCodeException {
        return WsMetadataPhysicalTableUtil.getRowCountLong((PhysicalTable)table);
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        String sType = this.m_browseObject.getMetadataType();
        if ("WorkTable".equals(sType)) {
            this.m_aTempValues[this.m_iCheckedOutBy] = bundle.getString("PhysicalTablePropertiesModel.CheckedOutBy.DoesntApplyForWorkTables.txt");
        }
        BrowseMetadataInterface browseTable = this.m_browseObject.getBrowseObject();
        this.m_aTempValues[this.m_iTableName] = browseTable.get("SASTableName");
        BrowseMetadataInterface library = BrowseObjectUtil.findLibraryForTable((List)browseTable.get("TablePackage"));
        if (library != null) {
            String libRef = BrowseObjectUtil.generateLibRef(library);
            this.m_aTempValues[this.m_iLibrary] = bundle.formatString("PhysicalTablePropertiesModel.Library.NameLibrefSchema.fmt", (Object)library.getName(), (Object)libRef);
        } else {
            this.m_aTempValues[this.m_iLibrary] = "WorkTable".equals(sType) ? bundle.getString("PhysicalTablePropertiesModel.WorkTableNoLibrary.txt") : "";
        }
        String dbms = BrowseObjectUtil.getDBMSProductName(browseTable);
        if (dbms == null && !"WorkTable".equals(sType)) {
            dbms = "SAS";
        }
        this.m_aTempValues[this.m_iDBMS] = dbms != null ? ("DATA".equals(browseTable.get("MemberType")) ? bundle.formatString("PhysicalTablePropertiesModel.DBMSTable.fmt", (Object)dbms) : bundle.formatString("PhysicalTablePropertiesModel.DBMSView.fmt", (Object)dbms)) : "";
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        boolean bRowCount = defaultsFile.getPropertyBoolean("QuickProperties.RowCount", false);
        this.m_aTempValues[this.m_iNumberOfRows] = bRowCount ? null : bundle.getString("PhysicalTablePropertiesModel.RowCountDisabled.txt");
        BrowseMetadataInterface table = this.m_browseObject.getBrowseObject();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        List columns = (List)table.get("Columns");
        if (columns != null) {
            String columnCount = nf.format(columns.size());
            this.m_aTempValues[this.m_iNumberOfColumns] = columnCount;
        } else {
            this.m_aTempValues[this.m_iNumberOfColumns] = bundle.getString("Common.Unknown.txt");
        }
    }

    protected Thread createRowCountThread() {
        return new cGetRowCountThread();
    }

    protected class cGetRowCountThread
    extends Thread {
        private String TEMPLATE_ROW_COUNT;

        public cGetRowCountThread() {
            super("basic properties row count for " + BrowseTablePropertiesModel.this.m_browseObject.getName());
            this.TEMPLATE_ROW_COUNT = "<Templates>   <PhysicalTable>      <TablePackage/>      <Prompts/>   </PhysicalTable>   <SASLibrary>      <UsedByPackages/>      <DeployedComponents/>   </SASLibrary>   <DatabaseSchema>      <UsedByPackages/>      <DeployedComponents/>   </DatabaseSchema>   <ServerContext>      <UsingComponents/>   </ServerContext></Templates>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (m_iRowCountThreadsRunning >= 5) {
                Workspace.getDefaultLogger().info((Object)bundle.formatString("PhysicalTablePropertiesModel.RowCount.TooMany.fmt", (Object)BrowseTablePropertiesModel.this.m_browseObject.getName()));
                BrowseTablePropertiesModel.this.m_aTempValues[BrowseTablePropertiesModel.this.m_iNumberOfRows] = bundle.getString("Common.Unknown.txt");
            } else {
                ++m_iRowCountThreadsRunning;
                MdFactory factory = Workspace.getMdFactory();
                MdObjectStore m_store = null;
                NumberFormat nf = NumberFormat.getIntegerInstance();
                long rowCount = -1L;
                try {
                    m_store = factory.createObjectStore(null, "BasicPropertiesGetRowCount " + BrowseTablePropertiesModel.this.m_browseObject.getName());
                    MdObjectStoreImpl currentStore = (MdObjectStoreImpl)m_store;
                    currentStore.getOwningStore().removeMdStoreListener((MdStoreListener)m_store);
                    currentStore.getOwningStore().removeChildStore((MdStore)m_store);
                    Root mdoReal = ObjectConverter.getInstance().convertToJOMAObject(m_store, (SimpleObject)BrowseTablePropertiesModel.this.m_browseObject, this.TEMPLATE_ROW_COUNT);
                    PhysicalTable table = (PhysicalTable)mdoReal;
                    rowCount = BrowseTablePropertiesModel.this.getRowCountLong(table);
                }
                catch (MdException me) {
                    if (BrowseTablePropertiesModel.this.isDisplayErrors()) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    } else {
                        Workspace.getDefaultLogger().error((Object)bundle.formatString("PhysicalTablePropertiesModel.RowCount.MdException.fmt", (Object)me.getLocalizedMessage()));
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (Exception e) {
                    if (BrowseTablePropertiesModel.this.isDisplayErrors()) {
                        MessageUtil.displayMessage((String)e.getMessage(), (int)0);
                    } else {
                        Workspace.getDefaultLogger().error((Object)bundle.formatString("PhysicalTablePropertiesModel.RowCount.Exception.fmt", (Object)e.getLocalizedMessage()));
                    }
                }
                finally {
                    if (m_store != null) {
                        try {
                            m_store.dispose();
                        }
                        catch (RemoteException e) {
                            Workspace.handleRemoteException((RemoteException)e);
                        }
                    }
                }
                if (rowCount == -1L) {
                    BrowseTablePropertiesModel.this.m_aTempValues[BrowseTablePropertiesModel.this.m_iNumberOfRows] = bundle.getString("Common.Unknown.txt");
                } else {
                    String rowCountString = nf.format(rowCount);
                    BrowseTablePropertiesModel.this.m_aTempValues[BrowseTablePropertiesModel.this.m_iNumberOfRows] = rowCountString;
                }
                --m_iRowCountThreadsRunning;
            }
            BrowseTablePropertiesModel.this.setPropertyValue(BrowseTablePropertiesModel.this.m_iNumberOfRows, BrowseTablePropertiesModel.this.m_aTempValues[BrowseTablePropertiesModel.this.m_iNumberOfRows]);
        }
    }
}

