/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import com.sas.workspace.Workspace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BrowsePropertyHandler {
    protected BrowseMetadataInterface m_meta = null;
    protected BrowseMetadataInterface m_propSet = null;
    protected String m_setRole = "";
    protected boolean m_usePropertySet = true;
    protected boolean m_useSetProperties = false;
    public static final String VALUE_TRUE = "YES";
    public static final String VALUE_FALSE = "NO";
    public static final String PROPERTY_NAME_SYSTEM_OPTIONS = "SystemOptions";
    public static final String PROPERTY_ROLE_SYSTEM_OPTIONS = "SYSTEM";

    public BrowsePropertyHandler() {
    }

    public BrowsePropertyHandler(BrowseMetadataInterface meta) {
        this.m_meta = meta;
    }

    public BrowsePropertyHandler(BrowseMetadataInterface meta, String setRole) throws MdException, RemoteException {
        this.m_meta = meta;
        this.m_setRole = setRole;
        this.m_propSet = this.getPropertySet();
    }

    public BrowsePropertyHandler(BrowseMetadataInterface meta, String setRole, boolean useSetProperties) throws MdException, RemoteException {
        this.m_meta = meta;
        this.m_setRole = setRole;
        this.m_useSetProperties = useSetProperties;
        this.m_propSet = this.getPropertySet();
    }

    public BrowsePropertyHandler(BrowseMetadataInterface meta, boolean usePropertySet) throws MdException, RemoteException {
        this.m_meta = meta;
        this.m_usePropertySet = usePropertySet;
        this.m_propSet = this.getPropertySet();
    }

    public void setParent(BrowseMetadataInterface meta) {
        this.m_meta = meta;
    }

    public BrowseMetadataInterface getParent() throws MdException, RemoteException {
        return this.m_meta;
    }

    public void setPropertySet(BrowseMetadataInterface set) {
        this.m_propSet = set;
    }

    public void setSetRole(String setRole) throws MdException, RemoteException {
        this.m_setRole = setRole;
        this.m_propSet = this.getPropertySet();
    }

    public String getSetRole() {
        return this.m_setRole;
    }

    public void setUsePropertySet(boolean usePropertySet) throws MdException, RemoteException {
        this.m_usePropertySet = usePropertySet;
    }

    public boolean getUsePropertySet() {
        return this.m_usePropertySet;
    }

    public void setUseSetProperties(boolean useSetProperties) throws MdException, RemoteException {
        this.m_useSetProperties = useSetProperties;
    }

    public boolean getUseSetProperties() {
        return this.m_useSetProperties;
    }

    public BrowseMetadataInterface getPropertySet() throws MdException, RemoteException {
        if (this.m_meta == null || !this.m_usePropertySet) {
            return null;
        }
        List lSets = (List)this.m_meta.get("PropertySets");
        BrowseMetadataInterface propSet = null;
        BrowseMetadataInterface mostRecentPropSet = null;
        if (lSets == null) {
            return propSet;
        }
        long updateDate = 0L;
        for (int i = 0; i < lSets.size(); ++i) {
            long currentObjDate;
            String setRole;
            BrowseMetadataInterface setObject = (BrowseMetadataInterface)lSets.get(i);
            if (setObject == null || (setRole = (String)setObject.get("SetRole")) == null || this.m_setRole.compareToIgnoreCase(setRole) != 0) continue;
            propSet = setObject;
            if (!setRole.equalsIgnoreCase("ModifiedByProductPropertySet")) break;
            if (!setRole.equalsIgnoreCase("ModifiedByProductPropertySet")) continue;
            if (i == 0 && lSets.size() == 1) break;
            List lProps = (List)propSet.get("Properties");
            BrowseMetadataInterface iProperty = null;
            if (lProps == null) continue;
            for (int k = 0; k < lProps.size(); ++k) {
                BrowseMetadataInterface iProp = (BrowseMetadataInterface)lProps.get(k);
                String propName = (String)iProp.get("PropertyName");
                if (propName.compareToIgnoreCase("ModifiedByProduct") != 0) continue;
                iProperty = iProp;
                break;
            }
            if (i == 0 && iProperty != null) {
                updateDate = iProperty.getModifyDate();
                mostRecentPropSet = propSet;
                continue;
            }
            if (iProperty == null || (currentObjDate = iProperty.getModifyDate()) <= updateDate) continue;
            updateDate = currentObjDate;
            mostRecentPropSet = propSet;
        }
        if (mostRecentPropSet != null) {
            propSet = mostRecentPropSet;
        }
        return propSet;
    }

    public List getPropertyList() throws MdException, RemoteException {
        if ((this.m_useSetProperties || this.m_usePropertySet) && this.m_propSet == null) {
            return null;
        }
        List lProps = this.m_useSetProperties ? (List)this.m_propSet.get("SetProperties") : (this.m_usePropertySet ? (List)this.m_propSet.get("Properties") : (List)this.m_meta.get("Properties"));
        return lProps;
    }

    public BrowseMetadataInterface getPropertyGroup(String groupName) throws MdException, RemoteException {
        if (this.m_meta == null || this.m_propSet == null) {
            return null;
        }
        List lGroups = (List)this.m_propSet.get("Groups");
        BrowseMetadataInterface propGroup = null;
        if (lGroups == null) {
            return propGroup;
        }
        for (int i = 0; i < lGroups.size(); ++i) {
            BrowseMetadataInterface propGp = (BrowseMetadataInterface)lGroups.get(i);
            if (propGp == null || propGp.getName().compareToIgnoreCase(groupName) != 0) continue;
            propGroup = propGp;
            break;
        }
        return propGroup;
    }

    public BrowseMetadataInterface getHandlerPropertySet() {
        return this.m_propSet;
    }

    public String getOptionsString() throws MdException, RemoteException {
        return this.getOptionsString("");
    }

    public String getOptionsString(String propertyRole) throws MdException, RemoteException {
        List lProps;
        if (this.m_propSet == null && this.m_usePropertySet) {
            this.m_propSet = this.getPropertySet();
            if (this.m_propSet == null) {
                return "";
            }
        }
        if ((lProps = this.getPropertyList()) == null) {
            return "";
        }
        StringBuffer propList = new StringBuffer();
        int stringLength = 50;
        for (int i = 0; i < lProps.size(); ++i) {
            String useValueOnly;
            String defaultValue;
            BrowseMetadataInterface iProp = (BrowseMetadataInterface)lProps.get(i);
            String iPropRole = (String)iProp.get("PropertyRole");
            if (iPropRole == null || iPropRole.compareToIgnoreCase(propertyRole) != 0 && propertyRole.trim().compareTo("") != 0 || (defaultValue = this.getDefaultValue(iProp)).trim().compareToIgnoreCase("") == 0 || defaultValue.toUpperCase().startsWith("DEFAULT")) continue;
            if (propList.length() > stringLength) {
                propList.append("\n   ");
                stringLength = 50;
            }
            if (!"0".equals(useValueOnly = (String)iProp.get("UseValueOnly"))) {
                propList.append(" ").append(defaultValue);
                continue;
            }
            if (!"0".equals(useValueOnly)) continue;
            String delim = (String)iProp.get("Delimiter");
            if (delim.trim().compareTo("") == 0) {
                delim = "=";
            }
            String propertyName = (String)iProp.get("PropertyName");
            propList.append(" ").append(propertyName).append(delim).append(defaultValue);
        }
        if (propList.length() > 0) {
            return propList.substring(1);
        }
        return "";
    }

    public String getSpecificOptionValue(String propertyName) throws MdException, RemoteException {
        return this.getSpecificOptionValue(propertyName, null);
    }

    public String getSpecificOptionValue(String propertyName, String defaultValue) throws MdException, RemoteException {
        BrowseMetadataInterface iProp = this.getSpecificProperty(propertyName);
        String returnValue = "";
        if (iProp != null) {
            returnValue = this.getDefaultValue(iProp);
        } else if (defaultValue != null) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    protected String getDefaultValue(BrowseMetadataInterface iProp) {
        String returnValue = "";
        String propertyDefaultValue = (String)iProp.get("DefaultValue");
        PromptDefinitionReference defReference = null;
        try {
            defReference = (PromptDefinitionReference)BrowsePropertyHandler.getObjectForXML(propertyDefaultValue);
            Object value = defReference.getValue();
            if (value != null) {
                returnValue = value.toString();
            }
        }
        catch (Exception exc) {
            Workspace.getDefaultLogger().warn((Object)exc.getLocalizedMessage());
            returnValue = propertyDefaultValue.trim();
        }
        return returnValue;
    }

    public BrowseMetadataInterface getSpecificProperty(String propertyName) throws MdException, RemoteException {
        if (this.m_propSet == null && this.m_usePropertySet) {
            this.m_propSet = this.getPropertySet();
            if (this.m_propSet == null) {
                return null;
            }
        }
        List lProps = this.getPropertyList();
        BrowseMetadataInterface iProperty = null;
        if (lProps != null) {
            for (int i = 0; i < lProps.size(); ++i) {
                BrowseMetadataInterface iProp = (BrowseMetadataInterface)lProps.get(i);
                String propName = (String)iProp.get("PropertyName");
                if (propName.compareToIgnoreCase(propertyName) != 0) continue;
                iProperty = iProp;
                break;
            }
        }
        return iProperty;
    }

    public boolean stringToBoolean(String value) {
        return this.stringToBoolean(value, false);
    }

    public boolean stringToBoolean(String value, boolean defaultValue) {
        if (value.compareToIgnoreCase(VALUE_FALSE) == 0) {
            return false;
        }
        if (value.compareToIgnoreCase(VALUE_TRUE) == 0) {
            return true;
        }
        return defaultValue;
    }

    public String booleanToString(boolean value) {
        return this.booleanToString(value, VALUE_FALSE);
    }

    public String booleanToString(boolean value, String defaultValue) {
        if (value) {
            return VALUE_TRUE;
        }
        if (!value) {
            return VALUE_FALSE;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectForXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        String encoding = "UTF-8";
        PersistenceInterface obj = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            Log4JFactory2 loggerFactory = new Log4JFactory2();
            PromptsReadingContext rc = PersistenceFactory.newReadingContext((LoggerFactoryInterface)loggerFactory);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            PromptContentHandler handler = PromptContentHandler.newHandler2((LoggerFactoryInterface)loggerFactory, (PromptsReadingContext)rc);
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
            InputSource source = new InputSource(reader);
            parser.parse(source, (DefaultHandler)handler);
            ((InputStream)stream).reset();
            reader = new InputStreamReader((InputStream)stream, "UTF-8");
            obj = PromptUtil.newObjectFromXML((Reader)reader, null, (PromptsReadingContext)rc);
        }
        return obj;
    }
}

