/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.util.UsageVersion;
import com.sas.wadmin.visuals.properties.AbstractBrowsePropertiesModel;
import com.sas.wadmin.visuals.properties.BrowsePropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataChangeManagementUtil;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BrowsePropertiesModel
extends AbstractBrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowsePropertiesModel.class);
    protected static final int ROOT_PROPERTIES_COUNT = 12;
    protected int m_iName;
    protected int m_iDescription;
    protected int m_iFolderLocation;
    protected int m_iCheckedOutBy;
    protected int m_iLastModifiedBy;
    protected int m_iDateUpdated;
    protected int m_iDateCreated;
    protected int m_iLogicalType;
    protected int m_iMetadataID;
    protected int m_iUsageVersion;
    protected int m_iDateArchived;
    protected int m_iArchiveName;
    protected Object[] m_aTempValues = new Object[this.getNumberOfProperties()];
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;
    private static final String MODIFIED_BY_PRODUCT = "ModifiedByProduct";
    private static final String MODIFIED_BY_PRODUCT_PROPERTY_SET = "ModifiedByProductPropertySet";

    public BrowsePropertiesModel(SimpleBrowseObject mdoObject) {
        super(mdoObject);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iLastModifiedBy = 4;
        this.m_iDateUpdated = 5;
        this.m_iDateCreated = 6;
        this.m_iDateArchived = 7;
        this.m_iArchiveName = 8;
        this.m_iLogicalType = 9;
        this.m_iMetadataID = 10;
        this.m_iUsageVersion = 11;
    }

    @Override
    protected void initializeProperties() {
        this.setProperty(this.m_iName, bundle.getString("RootPropertiesModel.Name.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDescription, bundle.getString("RootPropertiesModel.Description.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iFolderLocation, bundle.getString("RootPropertiesModel.FolderLocation.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iCheckedOutBy, bundle.getString("RootPropertiesModel.CheckedOutBy.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLastModifiedBy, bundle.getString("RootPropertiesModel.LastModifiedBy.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDateUpdated, bundle.getString("RootPropertiesModel.DateUpdated.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDateCreated, bundle.getString("RootPropertiesModel.DateCreated.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDateArchived, bundle.getString("RootPropertiesModel.DateArchived.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iArchiveName, bundle.getString("RootPropertiesModel.ArchiveName.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLogicalType, bundle.getString("RootPropertiesModel.LogicalType.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iMetadataID, bundle.getString("RootPropertiesModel.MetadataID.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iUsageVersion, bundle.getString("RootPropertiesModel.UsageVersion.txt"), null, BrowsePropertiesModel.getDefaultRenderer());
    }

    @Override
    public int getNumberOfProperties() {
        return 12;
    }

    @Override
    public void populate() throws MdException, RemoteException {
        StringBuffer sbTemplate = new StringBuffer();
        sbTemplate.append("<Templates>");
        String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(this.m_browseObject.getMetadataType(), this.m_browseObject.getID(), null, this.getPopulateAttributes());
        if (!this.isBasicStructuredObject(this.m_browseObject)) {
            sbTemplate.append(objectXML);
        }
        sbTemplate.append(this.getPopulateTemplate());
        sbTemplate.append("</Templates>");
        String template = sbTemplate.toString();
        int mdFlags = -2080350180;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            Filter filter = new Filter();
            filter.setExplicitSearchString("", objectXML);
            filter.setOMRTemplate(template);
            filter.setOMRFlags(mdFlags);
            String sKey = this.m_browseObject.getID() + "/" + this.m_browseObject.getMetadataType();
            BrowseMetadataInterface root = server.browseFetch(sKey, (FilterInterface)filter);
            this.m_browseObject = new SimpleBrowseObjectImpl(root);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
    }

    private boolean isBasicStructuredObject(SimpleBrowseObject browseObject) {
        boolean returnValue = false;
        if (browseObject != null) {
            String type = browseObject.getMetadataType();
            if ("Tree".equals(type)) {
                returnValue = true;
            } else if ("PropertySet".equals(type)) {
                returnValue = true;
            } else if ("ResponsibleParty".equals(type)) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<PropertySet><Properties/><SetProperties/></PropertySet>");
            template.append("<ResponsibleParty><Persons/></ResponsibleParty>");
            template.append("<Tree Name=\"\"><ParentTree/><ResponsibleParties/><SoftwareComponents/><PropertySets/></Tree>");
            s_strTemplate = template.toString();
        }
        return s_strTemplate;
    }

    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.add("PropertySets");
            s_lAttributes.add("ResponsibleParties");
            s_lAttributes.add("Trees");
        }
        return s_lAttributes;
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        TypeDescriptorInterface typeInterface;
        BrowseMetadataInterface browse = this.m_browseObject.getBrowseObject();
        this.m_aTempValues[this.m_iName] = this.m_browseObject.getName();
        this.m_aTempValues[this.m_iDescription] = browse.getDescription();
        this.m_aTempValues[this.m_iFolderLocation] = this.getFolderLocation(this.m_browseObject);
        this.m_aTempValues[this.m_iUsageVersion] = this.getUsageVersion(browse).toString();
        this.m_aTempValues[this.m_iCheckedOutBy] = this.isCheckedOut(this.m_browseObject.getBrowseObject()) ? WsMetadataChangeManagementUtil.getNameOfOwnerFor((String)this.getLockedBy(browse)) : null;
        this.m_aTempValues[this.m_iLastModifiedBy] = BrowsePropertiesModel.getModifiedByUserFor(browse);
        String modifiedByProduct = BrowsePropertiesModel.getModifiedByProductFor(browse);
        this.m_aTempValues[this.m_iDateUpdated] = modifiedByProduct == null || modifiedByProduct.length() == 0 ? this.getFormatedModifiedDateString(browse) : bundle.formatString("RootPropertiesModel.DateUpdated.Time.fmt", (Object)this.getFormatedModifiedDateString(browse), (Object)modifiedByProduct);
        this.m_aTempValues[this.m_iDateCreated] = this.getFormatedCreateDateString(browse);
        String publicType = this.m_browseObject.getPublicType();
        this.m_aTempValues[this.m_iLogicalType] = publicType != null && publicType.length() > 0 ? ((typeInterface = Workspace.getWorkspace().getUserContext().getAuthServer().getTypeDescriptor(publicType)) != null ? typeInterface.getType() : "") : "";
        this.m_aTempValues[this.m_iMetadataID] = this.m_browseObject.getID();
        this.m_aTempValues[this.m_iDateArchived] = BrowsePropertiesModel.getFormattedArchivedDateString(browse);
        this.m_aTempValues[this.m_iArchiveName] = BrowsePropertiesModel.getArchiveName(browse);
    }

    protected UsageVersion getUsageVersion(BrowseMetadataInterface browse) {
        UsageVersion version = null;
        String sUsageVersion = (String)browse.get("UsageVersion");
        if (sUsageVersion != null && sUsageVersion.length() > 0) {
            double dVersion = Double.parseDouble(sUsageVersion);
            version = UsageVersion.decode((double)dVersion);
        } else {
            version = UsageVersion.decode((double)0.0);
        }
        return version;
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            this.setPropertyValue(i, this.m_aTempValues[i]);
        }
    }

    @Override
    public void startUpdatePropertyThreads() {
        try {
            for (int i = 0; i < this.getNumberOfProperties(); ++i) {
                Thread t = this.m_aUpdatePropertyThreads[i];
                if (t == null) continue;
                t.start();
                t.join();
            }
        }
        catch (InterruptedException e) {
            if (this.isDisplayErrors()) {
                MessageUtil.displayMessage((String)e.getMessage(), (int)0);
            }
            Workspace.getDefaultLogger().error((Object)bundle.formatString("RootPropertiesModel.UpdatingProperties.InterruptedException.fmt", (Object)e.getLocalizedMessage()));
        }
    }

    protected String createDelimitedString(List values, String delimiter) {
        if (values == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int nValues = values.size();
        for (int i = 0; i < nValues; ++i) {
            sb.append(values.get(i));
            if (i >= nValues - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    protected String createCommaDelimitedString(List values) {
        return this.createDelimitedString(values, ", ");
    }

    protected String getFolderLocation(SimpleBrowseObject browse) {
        BrowseMetadataInterface browseObject = browse.getBrowseObject();
        BrowseMetadataInterface parentFolder = null;
        List parents = browseObject.getParents();
        int pathSeparator = 47;
        if (parents == null || parents.size() <= 0) {
            if (browseObject.isAFolder()) {
                return "/";
            }
            return "";
        }
        parentFolder = (BrowseMetadataInterface)parents.get(0);
        StringBuffer path = new StringBuffer();
        while (parentFolder != null) {
            path.insert(0, '/' + parentFolder.getName());
            List parentList = parentFolder.getParents();
            if (parentList != null && parentList.size() > 0) {
                parentFolder = (BrowseMetadataInterface)parentList.get(0);
                continue;
            }
            parentFolder = null;
        }
        return path.toString();
    }

    protected String getFormatedCreateDateString(BrowseMetadataInterface browseObject) {
        String returnValue = "";
        Date date = browseObject.getCreateDateAsDate();
        if (date != null) {
            DateFormat fmtDefault = DateFormat.getDateTimeInstance(2, 2);
            returnValue = fmtDefault.format(date);
        }
        return returnValue;
    }

    protected String getFormatedModifiedDateString(BrowseMetadataInterface browseObject) {
        String returnValue = "";
        Date date = browseObject.getModifyDateAsDate();
        if (date != null) {
            DateFormat fmtDefault = DateFormat.getDateTimeInstance(2, 2);
            returnValue = fmtDefault.format(date);
        }
        return returnValue;
    }

    public boolean isCheckedOut(BrowseMetadataInterface browseObject) throws RemoteException {
        String strChangeState = (String)browseObject.get("ChangeState");
        String strLockedBy = this.getLockedBy(browseObject);
        return strChangeState.length() > 0 && strLockedBy.indexOf(".") > -1 || strChangeState.indexOf("Check") > -1;
    }

    public String getLockedBy(BrowseMetadataInterface browseObject) {
        return (String)browseObject.get("LockedBy");
    }

    private static BrowseMetadataInterface getModifiedByResponsiblePartyFor(BrowseMetadataInterface browse) throws MdException, RemoteException {
        if (browse == null) {
            return null;
        }
        List parties = (List)browse.get("ResponsibleParties");
        if (parties != null && parties.size() > 0) {
            for (BrowseMetadataInterface brParty : parties) {
                if (!"Modified By".equals(brParty.get("Role"))) continue;
                return brParty;
            }
        }
        return null;
    }

    private static BrowseMetadataInterface getArchiveInfo(BrowseMetadataInterface browse) throws MdException, RemoteException {
        if (browse == null) {
            return null;
        }
        List sets = (List)browse.get("PropertySets");
        if (sets != null) {
            for (BrowseMetadataInterface set : sets) {
                if (!"Archive".equals(set.get("PropertySetName"))) continue;
                return set;
            }
        }
        return null;
    }

    private static String getFormattedArchivedDateString(BrowseMetadataInterface browse) throws MdException, RemoteException {
        BrowseMetadataInterface set = BrowsePropertiesModel.getArchiveInfo(browse);
        if (set == null) {
            return "";
        }
        List properties = (List)set.get("SetProperties");
        if (properties != null) {
            for (BrowseMetadataInterface property : properties) {
                if (!"DateArchived".equals(property.get("PropertyName"))) continue;
                String value = (String)property.get("DefaultValue");
                Date date = new Date(Long.parseLong(value));
                DateFormat fmtDefault = DateFormat.getDateTimeInstance(2, 2);
                return fmtDefault.format(date);
            }
        }
        return "";
    }

    private static String getArchiveName(BrowseMetadataInterface browse) throws MdException, RemoteException {
        BrowseMetadataInterface set = BrowsePropertiesModel.getArchiveInfo(browse);
        if (set == null) {
            return "";
        }
        List properties = (List)set.get("SetProperties");
        if (properties != null) {
            for (BrowseMetadataInterface property : properties) {
                if (!"ArchiveName".equals(property.get("PropertyName"))) continue;
                return (String)property.get("DefaultValue");
            }
        }
        return "";
    }

    public static String getModifiedByUserFor(BrowseMetadataInterface browse) throws MdException, RemoteException {
        BrowseMetadataInterface p;
        List persons;
        BrowseMetadataInterface rp = BrowsePropertiesModel.getModifiedByResponsiblePartyFor(browse);
        if (rp != null && (persons = (List)rp.get("Persons")) != null && persons.size() > 0 && (p = (BrowseMetadataInterface)persons.get(0)) != null) {
            return p.getName();
        }
        return null;
    }

    public static String getModifiedByProductFor(BrowseMetadataInterface r) throws MdException, RemoteException {
        BrowsePropertyHandler handler = new BrowsePropertyHandler(r, MODIFIED_BY_PRODUCT_PROPERTY_SET);
        return handler.getSpecificOptionValue(MODIFIED_BY_PRODUCT);
    }
}

