/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleBrowseObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BrowseJobPropertiesModel
extends BrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowseJobPropertiesModel.class);
    protected static final int JOB_PROPERTIES_COUNT = 13;
    protected int m_iTablesLoaded;
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;

    public BrowseJobPropertiesModel(SimpleBrowseObject job) {
        super(job);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iTablesLoaded = 4;
        this.m_iLastModifiedBy = 5;
        this.m_iDateUpdated = 6;
        this.m_iDateCreated = 7;
        this.m_iDateArchived = 8;
        this.m_iArchiveName = 9;
        this.m_iLogicalType = 10;
        this.m_iMetadataID = 11;
        this.m_iUsageVersion = 12;
    }

    @Override
    public int getNumberOfProperties() {
        return 13;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<ClassifierMap><ClassifierTargets/></ClassifierMap>");
            template.append("<Select><ClassifierTargets/></Select>");
            template.append("<SyncStep><Transformations/></SyncStep>");
            template.append("<TransformationActivity><Steps/></TransformationActivity>");
            template.append("<TransformationStep><Transformations/></TransformationStep>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("JobActivities");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iTablesLoaded, bundle.getString("JobPropertiesModel.TablesLoaded.txt"), null, BrowseJobPropertiesModel.getDefaultRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        BrowseMetadataInterface browse = this.m_browseObject.getBrowseObject();
        List alActivities = (List)browse.get("JobActivities");
        ArrayList<String> tableNames = new ArrayList<String>();
        if (alActivities != null) {
            for (int i = 0; i < alActivities.size(); ++i) {
                List alSteps;
                BrowseMetadataInterface activity = (BrowseMetadataInterface)alActivities.get(i);
                if (activity == null || (alSteps = (List)activity.get("Steps")) == null) continue;
                for (int j = 0; j < alSteps.size(); ++j) {
                    List alTransformations;
                    BrowseMetadataInterface step = (BrowseMetadataInterface)alSteps.get(j);
                    if (step == null || (alTransformations = (List)step.get("Transformations")) == null) continue;
                    for (int k = 0; k < alTransformations.size(); ++k) {
                        List alTargets;
                        BrowseMetadataInterface cmap = (BrowseMetadataInterface)alTransformations.get(k);
                        if (!"ClassifierMap".equals(cmap.getNativeType()) || (alTargets = (List)cmap.get("ClassifierTargets")) == null) continue;
                        for (int m = 0; m < alTargets.size(); ++m) {
                            BrowseMetadataInterface cm = (BrowseMetadataInterface)alTargets.get(m);
                            if (cm == null || !cm.getNativeType().equals("PhysicalTable") && !cm.getNativeType().equals("ExternalTable")) continue;
                            tableNames.add(cm.getName());
                        }
                    }
                }
            }
        }
        this.m_aTempValues[this.m_iTablesLoaded] = this.createCommaDelimitedString(tableNames);
    }
}

