/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;

public class FindHelper {
    private JEditorPane pane;
    private String findString;
    private String replaceString;
    private boolean isForward;
    private boolean isCaseSensitive;
    private boolean isWholeWord;

    protected FindHelper(JEditorPane pane) {
        this.pane = pane;
        this.isForward = true;
    }

    public String getFindString() {
        return this.findString;
    }

    public void setFindString(String findString) {
        this.findString = findString;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String replaceString) {
        this.replaceString = replaceString;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean isForward) {
        this.isForward = isForward;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isWholeWord() {
        return this.isWholeWord;
    }

    public void setWholeWord(boolean isWholeWord) {
        this.isWholeWord = isWholeWord;
    }

    public boolean findNext() {
        int index = this.locateString();
        if (index != -1) {
            this.selectionText(index, index + this.findString.length());
            return true;
        }
        return false;
    }

    public boolean replace() {
        int index = this.locateString();
        if (index != -1) {
            EnhancedDocument doc = (EnhancedDocument)this.pane.getDocument();
            if (doc != null) {
                try {
                    doc.replace(index, this.findString.length(), this.replaceString, null);
                    this.selectionText(index, index + this.replaceString.length());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public void replaceAll() {
        this.pane.setCaretPosition(0);
        while (this.replace()) {
        }
    }

    private int locateString() {
        int index = -1;
        int offset = this.isForward ? Math.max(this.pane.getSelectionStart(), this.pane.getSelectionEnd()) : Math.max(Math.min(this.pane.getSelectionStart(), this.pane.getSelectionEnd()) - 1, 0);
        EnhancedDocument doc = (EnhancedDocument)this.pane.getDocument();
        int currentLineIndex = EditorUtils.getLineIndex(doc, offset);
        int lineStartIndex = offset - EditorUtils.getStartOffsetForLine(doc, currentLineIndex);
        int n = EditorUtils.getLineCount(this.pane);
        while (currentLineIndex < n && currentLineIndex >= 0) {
            int lineIndex = this.locateStringInLine(currentLineIndex, EditorUtils.getString(doc, currentLineIndex), lineStartIndex);
            if (lineIndex != -1) {
                index = EditorUtils.getStartOffsetForLine(doc, currentLineIndex);
                index += lineIndex;
                break;
            }
            currentLineIndex = this.isForward ? ++currentLineIndex : --currentLineIndex;
            lineStartIndex = -1;
        }
        return index;
    }

    private int locateStringInLine(int currentLineIndex, String lineText, int fromIndex) {
        int index = -1;
        String str = this.findString;
        if (!this.isCaseSensitive) {
            lineText = lineText.toUpperCase();
            str = str.toUpperCase();
        }
        if (this.isWholeWord) {
            // empty if block
        }
        index = this.isForward ? (fromIndex == -1 ? lineText.indexOf(str) : lineText.indexOf(str, fromIndex)) : (fromIndex == -1 ? lineText.lastIndexOf(str) : lineText.lastIndexOf(str, fromIndex));
        return index;
    }

    private void selectionText(int index, int endIndex) {
        this.pane.requestFocus();
        this.pane.setSelectionStart(index);
        this.pane.setSelectionEnd(endIndex);
    }
}

