/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorDocumentEvent;
import java.text.Collator;
import java.util.Locale;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class EnhancedEditorUndoManager
extends UndoManager {
    private boolean m_bIgnoreUpdates = false;
    private Segment workingSegment;
    protected UndoableEdit markedUndoEdit = null;
    protected Collator coll = Collator.getInstance(Locale.getDefault());

    public EnhancedEditorUndoManager() {
        this.workingSegment = new Segment();
    }

    @Override
    public boolean addEdit(UndoableEdit e) {
        if (!this.IsIgnoring()) {
            return super.addEdit(e);
        }
        return false;
    }

    public boolean IsIgnoring() {
        return this.m_bIgnoreUpdates;
    }

    public void ClearUndoStack() {
        this.discardAllEdits();
        this.MarkUndoStack();
    }

    public void MarkUndoStack() {
        this.markedUndoEdit = this.editToBeUndone();
    }

    public boolean isDocumentModified() {
        return this.markedUndoEdit != this.editToBeUndone();
    }

    public int doUndo() {
        int resultOffset = -1;
        char UndoChar = ' ';
        boolean firstTimeThroughLoop = true;
        this.m_bIgnoreUpdates = true;
        while (this.canUndo()) {
            EnhancedEditorDocumentEvent nextUndone;
            boolean previousAddition;
            EnhancedEditorDocumentEvent justUndone = (EnhancedEditorDocumentEvent)this.editToBeUndone();
            int changeLength = justUndone.getLength();
            boolean previousDeleted = justUndone.getType() == DocumentEvent.EventType.REMOVE;
            boolean bl = previousAddition = justUndone.getType() == DocumentEvent.EventType.INSERT;
            if (previousAddition) {
                try {
                    justUndone.getDocument().getText(justUndone.getOffset(), justUndone.getLength(), this.workingSegment);
                    UndoChar = this.workingSegment.setIndex(this.workingSegment.getBeginIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.undo();
            resultOffset = justUndone.getOffset();
            if (previousDeleted) {
                resultOffset += justUndone.getLength();
            }
            if (!this.isDocumentModified()) break;
            if (previousDeleted) {
                try {
                    justUndone.getDocument().getText(justUndone.getOffset(), justUndone.getLength(), this.workingSegment);
                    UndoChar = this.workingSegment.setIndex(this.workingSegment.getBeginIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if ((nextUndone = (EnhancedEditorDocumentEvent)this.editToBeUndone()) == null) break;
            if (justUndone.getMassReplaceCode() > 0L && justUndone.getMassReplaceCode() == nextUndone.getMassReplaceCode()) continue;
            if (justUndone.getMassReplaceCode() != nextUndone.getMassReplaceCode() || changeLength > 1 || (!previousDeleted || justUndone.getOffset() + 1 != nextUndone.getOffset()) && (!previousAddition || justUndone.getOffset() - 1 != nextUndone.getOffset())) break;
            if (this.isStoppableCharacter(UndoChar) && !firstTimeThroughLoop) {
                this.redo();
                break;
            }
            firstTimeThroughLoop = false;
            if (justUndone.getType() == nextUndone.getType()) continue;
            break;
        }
        this.m_bIgnoreUpdates = false;
        return resultOffset;
    }

    public int doRedo() {
        int resultOffset = -1;
        char RedoChar = ' ';
        this.m_bIgnoreUpdates = true;
        while (this.canRedo()) {
            EnhancedEditorDocumentEvent nextRedone;
            boolean previousAddition;
            EnhancedEditorDocumentEvent justRedone = (EnhancedEditorDocumentEvent)this.editToBeRedone();
            int changeLength = justRedone.getLength();
            boolean previousDeleted = justRedone.getType() == DocumentEvent.EventType.REMOVE;
            boolean bl = previousAddition = justRedone.getType() == DocumentEvent.EventType.INSERT;
            if (previousDeleted) {
                try {
                    justRedone.getDocument().getText(justRedone.getOffset(), justRedone.getLength(), this.workingSegment);
                    RedoChar = this.workingSegment.setIndex(this.workingSegment.getBeginIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.redo();
            resultOffset = justRedone.getOffset();
            if (previousAddition) {
                resultOffset += justRedone.getLength();
            }
            if (!this.isDocumentModified() || (nextRedone = (EnhancedEditorDocumentEvent)this.editToBeRedone()) == null) break;
            if (previousAddition) {
                try {
                    justRedone.getDocument().getText(justRedone.getOffset(), justRedone.getLength(), this.workingSegment);
                    RedoChar = this.workingSegment.setIndex(this.workingSegment.getBeginIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (justRedone.getMassReplaceCode() > 0L && justRedone.getMassReplaceCode() == nextRedone.getMassReplaceCode() || justRedone.getMassReplaceCode() == nextRedone.getMassReplaceCode() && changeLength <= 1 && Math.abs(justRedone.getOffset() - nextRedone.getOffset()) <= 1 && !this.isStoppableCharacter(RedoChar) && justRedone.getType() == nextRedone.getType()) continue;
            break;
        }
        this.m_bIgnoreUpdates = false;
        return resultOffset;
    }

    protected boolean isStoppableCharacter(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }
}

