/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.actions.ActionUtils;
import com.sas.wadmin.visuals.common.enhancededitor.component.RowHeaderPanel;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import com.sas.wadmin.visuals.common.enhancededitor.impl.FindHelper;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class EnhancedEditorPane
extends JEditorPane {
    private FindHelper findHelper;
    private String m_Filename;
    private RowHeaderPanel rowHeaderPanel;

    public EnhancedEditorPane() {
        ActionUtils.addActions(this);
        this.setFont(new Font("Monospaced", 0, 12));
        this.findHelper = new FindHelper(this);
    }

    public void pack() {
        this.rowHeaderPanel = new RowHeaderPanel();
        this.rowHeaderPanel.install(this);
    }

    public FindHelper getFindHelper() {
        return this.findHelper;
    }

    public void gotoLine(int lineIndex) {
        Document doc = this.getDocument();
        lineIndex = Math.min(lineIndex, EditorUtils.getLineCount(this) - 1);
        lineIndex = Math.max(0, lineIndex);
        Element ele = doc.getDefaultRootElement().getElement(lineIndex);
        this.setSelectionStart(ele.getStartOffset());
        this.setSelectionEnd(ele.getEndOffset() - 1);
    }

    public void setLineNumberVisible(boolean isVisable) {
        this.rowHeaderPanel.setLineNumberVisible(isVisable);
    }

    public boolean openFile(String strFile) throws FileNotFoundException {
        File fname = new File(strFile);
        StringBuffer sb = new StringBuffer((int)Math.min(Integer.MAX_VALUE, fname.length()));
        int bufferLength = 20000;
        char[] buffer = new char[bufferLength];
        int bytesRead = 0;
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader(new FileInputStream(fname)));
            do {
                if ((bytesRead = d.read(buffer, 0, bufferLength)) <= 0) continue;
                for (int i = 0; i < bytesRead; ++i) {
                    char character = buffer[i];
                    if (character == '\r') continue;
                    sb.append(character);
                }
            } while (bytesRead > 0);
            this.clear();
            this.setText(sb.substring(0, sb.length()));
        }
        catch (FileNotFoundException fileEx) {
            throw fileEx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.clearUndoStack();
        this.m_Filename = strFile;
        return true;
    }

    private void clearUndoStack() {
        if (this != null && (EnhancedDocument)this.getDocument() != null) {
            ((EnhancedDocument)this.getDocument()).getUndoManager().ClearUndoStack();
        }
    }

    public void clear() {
        this.setText("");
    }
}

