/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class EditorUtils {
    public static int getLineCount(JEditorPane editor) {
        Document doc = editor.getDocument();
        return doc.getDefaultRootElement().getElementCount();
    }

    public static String getString(EnhancedDocument doc, int lineIndex) {
        Element line = doc.getDefaultRootElement().getElement(lineIndex);
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset();
        Segment seg = new Segment();
        try {
            doc.getText(p0, p1 - p0, seg);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return seg.toString();
    }

    public static int getLineNumber(JEditorPane editor, int caretPosition) {
        return EditorUtils.getLineIndex(editor.getDocument(), caretPosition);
    }

    public static int getLineIndex(Document doc, int caretPosition) {
        return doc.getDefaultRootElement().getElementIndex(caretPosition);
    }

    public static int getCurrentLineStartOffset(EnhancedDocument doc, int offset) {
        int line = EditorUtils.getLineIndex(doc, offset);
        Element pg = doc.getDefaultRootElement().getElement(line);
        return pg.getStartOffset();
    }

    public static int getLineLength(EnhancedDocument doc, int line) {
        Element l = doc.getDefaultRootElement().getElement(line);
        return l.getEndOffset() - l.getStartOffset();
    }

    public static int getStartOffsetForLine(EnhancedDocument doc, int line) {
        Element myLine = doc.getDefaultRootElement().getElement(line);
        if (myLine == null) {
            return -1;
        }
        return myLine.getStartOffset();
    }

    public static int getEndOffsetOfLine(EnhancedDocument doc, int lineIndex) {
        Element myLine = doc.getDefaultRootElement().getElement(lineIndex);
        if (myLine == null) {
            return -1;
        }
        return myLine.getEndOffset();
    }
}

