/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.Section;
import com.sas.wadmin.visuals.common.enhancededitor.SectionsParser;
import com.sas.wadmin.visuals.common.enhancededitor.Token;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public abstract class AbstractSectionsParser
implements SectionsParser {
    protected EnhancedDocument doc;
    protected Stack<Token> startTokens = new Stack();
    protected Stack<List<Section>> subSections = new Stack();

    @Override
    public void setDocument(EnhancedDocument enhancedDocument) {
        this.doc = enhancedDocument;
    }

    @Override
    public boolean parseSections(List<Token> tokens, List<Section> sections) {
        boolean sectionParseAborted = false;
        this.startTokens.clear();
        this.subSections.clear();
        this.subSections.push(sections);
        for (Token token : tokens) {
            if (!this.isSectionToken(token)) continue;
            SectionWordStatus startType = this.getWordStatus(token);
            if (startType == SectionWordStatus.WHOLE_SECTION) {
                this.popStactToPopSections(this.startTokens.size(), token);
                continue;
            }
            if (startType == SectionWordStatus.START_MATCH) {
                this.popStactToPopSections(token);
                continue;
            }
            if (startType == SectionWordStatus.IGNORE_START) continue;
            if (startType == SectionWordStatus.SECTION_START && !this.startTokens.isEmpty()) {
                this.popStactToPopSections(token.lineIndex - 1);
            }
            this.startTokens.push(token);
            this.subSections.push(new ArrayList());
        }
        if (!this.startTokens.isEmpty()) {
            Token endToken = tokens.get(tokens.size() - 1);
            while (!this.startTokens.isEmpty()) {
                this.popStactToPopSections(endToken);
            }
        }
        sections.addAll((Collection<Section>)this.subSections.peek());
        return sectionParseAborted;
    }

    protected abstract SectionWordStatus getWordStatus(Token var1);

    protected abstract boolean isSectionToken(Token var1);

    private void popStactToPopSections(int size, Token token) {
        Section item = this.populateSection(this.startTokens.size(), token.startIndex, token.lineIndex, token.end(), EditorUtils.getLineIndex(this.doc, token.end() - 1));
        if (item != null) {
            this.subSections.peek().add(item);
        }
    }

    private void popStactToPopSections(int endLineIndex) {
        this.popStactToPopSections(EditorUtils.getEndOffsetOfLine(this.doc, endLineIndex), endLineIndex);
    }

    private void popStactToPopSections(Token endToken) {
        this.popStactToPopSections(endToken.end(), endToken.lineIndex);
    }

    private void popStactToPopSections(int endIndex, int endLineIndex) {
        Token startToken = this.startTokens.pop();
        Section item = this.populateSection(this.startTokens.size(), startToken.startIndex, startToken.lineIndex, endIndex, endLineIndex);
        if (item != null) {
            item.subSection = this.subSections.pop();
            this.subSections.peek().add(item);
        }
    }

    private Section populateSection(int level, int startIndex, int startLine, int endIndex, int endLine) {
        if (startLine == endLine) {
            return null;
        }
        Section sec = new Section();
        sec.classfication = level;
        sec.startLine = startLine;
        sec.endLine = endLine;
        sec.startIndex = startIndex;
        sec.endIndex = endIndex;
        sec.id = startLine;
        return sec;
    }

    public static enum SectionWordStatus {
        WHOLE_SECTION,
        START_MATCH,
        IGNORE_START,
        SECTION_START,
        SUBSECTION_START;

    }
}

