/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.component.EhancedComponent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionUpdateListener;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionUpdatedEvent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionsInfo;
import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class RowHeaderComponent
extends EhancedComponent
implements SectionUpdateListener,
CaretListener {
    protected SectionsInfo sectionsInfo;
    protected int lastHeight;

    public RowHeaderComponent() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void install(JEditorPane editor) {
        super.install(editor);
        this.sectionsInfo = this.doc.getSectionsInfo();
        this.sectionsInfo.addSectionUpdatedListener(this);
        this.editor.addCaretListener(this);
    }

    @Override
    public void deinstall() {
        super.deinstall();
        this.sectionsInfo.removeSectionUpdatedListener(this);
        this.editor.removeCaretListener(this);
    }

    @Override
    public void sectionUpdated(SectionUpdatedEvent event) {
        this.repaint();
    }

    @Override
    public void sectionChanged() {
        this.repaint();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
    }

    protected void installDocument(EnhancedDocument doc) {
        super.installDocument(doc);
        this.setPreferredWidth();
        this.repaint();
    }

    @Override
    protected void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int preferredHeight = RowHeaderComponent.this.editor.getPreferredSize().height;
                if (RowHeaderComponent.this.lastHeight != preferredHeight) {
                    RowHeaderComponent.this.setPreferredWidth();
                    RowHeaderComponent.this.updateComponent();
                    RowHeaderComponent.this.repaint();
                    RowHeaderComponent.this.lastHeight = preferredHeight;
                }
            }
        });
    }

    protected void updateComponent() {
    }
}

