/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.Section;
import com.sas.wadmin.visuals.common.enhancededitor.component.FoldingButton;
import com.sas.wadmin.visuals.common.enhancededitor.component.RowMarkerComponent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EditorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.event.CaretEvent;

public class FoldingMarkerPanel
extends RowMarkerComponent {
    public FoldingMarkerPanel() {
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawSectionLines(g, this.sectionsInfo.getTopSections());
    }

    private void drawSectionLines(Graphics g, List<Section> sectionItems) {
        if (sectionItems == null) {
            return;
        }
        g.setColor(Color.LIGHT_GRAY);
        int lh = this.getRowHeight();
        for (Section section : sectionItems) {
            if (section.isCollapse) continue;
            int x = this.getWidth() / 2;
            int startY = this.sectionsInfo.getViewLineNumber(section.startLine) * lh + lh / 2 + 6;
            int endY = startY + this.sectionsInfo.getVisableLineCount(section) * lh - lh;
            g.drawLine(x += section.classfication * 2, startY, x, endY);
            g.drawLine(x, endY, this.getWidth() * 3 / 4, endY);
            this.drawSectionLines(g, section.subSection);
        }
    }

    @Override
    protected void createMarkers(List<Component> markerItems) {
        this.createMarkersImpl(this.sectionsInfo.getTopSections(), markerItems);
    }

    private void createMarkersImpl(List<Section> sectionItems, List<Component> markerItems) {
        if (sectionItems != null) {
            for (Section section : sectionItems) {
                markerItems.add(new FoldingButton(this.doc, section));
                this.createMarkersImpl(section.subSection, markerItems);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int currentLine = EditorUtils.getLineIndex(this.doc, this.editor.getCaretPosition());
        if (this.sectionsInfo.isLineInCollpase(currentLine)) {
            int sectionid = this.sectionsInfo.getPreviousTopLevelLine(currentLine, 1);
            this.sectionsInfo.setSectionCollapse(sectionid, false);
        }
    }
}

