/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.CompletionInfo;
import com.sas.wadmin.visuals.common.enhancededitor.CompletionInfoProvider;
import com.sas.wadmin.visuals.common.enhancededitor.component.EhancedComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.text.Document;

public class CompletionComponent
extends EhancedComponent {
    private JDialog dialog;
    private JList completionList;
    private CompletionInfoListModel listModel = new CompletionInfoListModel();

    public CompletionComponent() {
        this.completionList = new JList(this.listModel);
        this.completionList.setSelectionMode(0);
        this.completionList.setFocusable(false);
        this.completionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CompletionComponent.this.onLstItemsMouseClicked(evt);
            }
        });
        this.initialLayout();
    }

    private void initialLayout() {
        this.setPreferredSize(new Dimension(220, 150));
        this.setLayout(new BorderLayout());
        this.add(this.completionList);
        this.dialog = new JDialog();
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(this);
        this.dialog.getContentPane().add((Component)scrollPane1, "Center");
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setResizable(false);
        this.dialog.setUndecorated(true);
        this.dialog.pack();
    }

    @Override
    protected void installDocument(Document doc) {
        super.installDocument(doc);
        if (this.doc != null) {
            CompletionInfoProvider provider = this.doc.getInfoProvider();
            this.listModel.setInfoProvider(provider);
        }
    }

    public void show(Point location, int offset) {
        this.listModel.updateToOffset(offset);
        this.dialog.setLocation(location);
        this.dialog.setVisible(true);
    }

    private void onLstItemsMouseClicked(MouseEvent evt) {
        CompletionInfo info;
        if (evt.getClickCount() == 2 && (info = (CompletionInfo)this.completionList.getSelectedValue()) != null) {
            this.editor.replaceSelection(info.code);
            this.dialog.setVisible(false);
        }
    }

    public class CompletionInfoListModel
    extends AbstractListModel {
        private CompletionInfoProvider provider;
        private List<CompletionInfo> completions = new ArrayList<CompletionInfo>();

        @Override
        public int getSize() {
            return this.completions.size();
        }

        public void updateToOffset(int offset) {
            this.completions.clear();
            this.completions.addAll(this.provider.getCompletionInfos(CompletionComponent.this.doc, offset));
        }

        public void setInfoProvider(CompletionInfoProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object getElementAt(int index) {
            return this.completions.get(index);
        }
    }
}

