/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor;

import com.sas.wadmin.visuals.common.enhancededitor.hive.HiveEditorKit;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorPane;
import com.sas.wadmin.visuals.common.enhancededitor.pig.PigEditorKit;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class EnhancedEditorTester {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setTitle("EnhancedEditor Tester");
        frame.setSize(1000, 1000);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        boolean enableFunctions = false;
        JScrollPane scrollerPIG = EnhancedEditorTester.createPIGPane(enableFunctions);
        JScrollPane scrollerHIVE = EnhancedEditorTester.createHIVEPane(enableFunctions);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("PIG", scrollerPIG);
        tabbedPane.addTab("HIVE", scrollerHIVE);
        frame.setContentPane(tabbedPane);
        frame.pack();
        frame.setSize(1400, 800);
        frame.setVisible(true);
    }

    private static JScrollPane createPIGPane(boolean enableFunction) {
        EnhancedEditorPane editor = new EnhancedEditorPane();
        PigEditorKit kit = new PigEditorKit();
        editor.setEditorKitForContentType("text/pig", kit);
        editor.setContentType("text/pig");
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(editor);
        editor.setFont(new Font("Courier New", 0, 12));
        editor.pack();
        String pigSampleTxt = "";
        InputStream is = EnhancedEditorTester.class.getResourceAsStream("pig/sample.pig");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String tempString = "";
        try {
            while ((tempString = br.readLine()) != null) {
                pigSampleTxt = pigSampleTxt + tempString + "\n";
            }
            if (null == pigSampleTxt || "".equals(pigSampleTxt.trim())) {
                pigSampleTxt = "UNLOADED";
            }
            editor.setText(pigSampleTxt);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        editor.setLineNumberVisible(false);
        return scroller;
    }

    private static JScrollPane createHIVEPane(boolean enableFunction) {
        EnhancedEditorPane editor = new EnhancedEditorPane();
        HiveEditorKit kit = new HiveEditorKit();
        editor.setEditorKitForContentType("text/hive", kit);
        editor.setContentType("text/hive");
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(editor);
        editor.setFont(new Font("Courier New", 0, 16));
        editor.pack();
        String hiveSampleTxt = "";
        InputStream is = EnhancedEditorTester.class.getResourceAsStream("hive/sample.q");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String tempString = "";
        try {
            while ((tempString = br.readLine()) != null) {
                hiveSampleTxt = hiveSampleTxt + tempString + "\n";
            }
            if (null == hiveSampleTxt || "".equals(hiveSampleTxt.trim())) {
                hiveSampleTxt = "UNLOADED";
            }
            editor.setText(hiveSampleTxt);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        editor.setText(hiveSampleTxt);
        editor.setLineNumberVisible(true);
        return scroller;
    }
}

