/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IColumn;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.TablesPaletteTree;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class TablesPaletteTreePanel
extends WAPanel {
    protected TablesPaletteTree m_treeTables;
    protected JScrollPane m_scrTablesTree;
    protected TablesPaletteTreeModel m_mdlTablesPalette;
    protected JCheckBox m_ckbSortColumns;
    private boolean m_bUseLongName;
    private static WAdminResource bundle = WAdminResource.getBundle(TablesPaletteTreePanel.class);

    public TablesPaletteTreePanel(TablesPaletteTreeModel mdlTree) {
        this.m_mdlTablesPalette = mdlTree;
        this.m_bUseLongName = true;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("select_column_win");
    }

    protected void initialize() {
        this.m_treeTables = this.createTablesTree();
        this.m_scrTablesTree = new JScrollPane((Component)((Object)this.m_treeTables));
        this.m_treeTables.getSelectionModel().setSelectionMode(1);
        this.m_ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"TablesPaletteTreePanel.Checkbox.SortColumns");
        this.m_ckbSortColumns.addActionListener(new cSortColumnsListener());
    }

    public void saveSettingsAndCleanUp() {
        this.dispose();
        super.saveSettingsAndCleanUp();
    }

    public void dispose() {
        this.m_treeTables.dispose();
    }

    public void allowMultipleSelection() {
        this.m_treeTables.getSelectionModel().setSelectionMode(4);
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add(this.m_scrTablesTree, "Center");
        this.add(this.m_ckbSortColumns, "South");
    }

    protected TablesPaletteTree createTablesTree() {
        TablesPaletteTree treeTables = new TablesPaletteTree((ITreeModel)this.m_mdlTablesPalette);
        treeTables.setScrollsOnExpand(true);
        treeTables.setEditable(false);
        treeTables.setRootVisible(false);
        return treeTables;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlTablesPalette.removeAllChildren((ITreeNode)this.m_mdlTablesPalette.getRoot());
        this.m_mdlTablesPalette.moveDataToModel();
        this.m_treeTables.expandRoot();
    }

    public void setDefaultAction(Action actDefault) {
        super.setDefaultAction(actDefault);
        this.m_treeTables.setUserDefaultAction(actDefault);
    }

    public void expand() {
        this.m_treeTables.expandRoot();
    }

    public void setUseLongName(boolean bUseLongName) {
        this.m_bUseLongName = bUseLongName;
    }

    public IColumn getSelectedColumn() {
        IColumn selobj = (IColumn)((IDataTreeNode)this.m_treeTables.getSelectedNode()).getData();
        return selobj;
    }

    public IColumn[] getSelectedColumns() {
        IDataTreeNode[] aNodes = (IDataTreeNode[])this.m_treeTables.getSelectedNodes();
        IColumn[] columns = new IColumn[aNodes.length];
        for (int i = 0; i < aNodes.length; ++i) {
            IColumn oColumn;
            columns[i] = oColumn = (IColumn)aNodes[i].getData();
        }
        return columns;
    }

    public String getSelectedTableColumnName() {
        return this.getNodeColumnName(this.m_treeTables.getSelectedNode());
    }

    public ITreeNode getSelectedNode() {
        return this.m_treeTables.getSelectedNode();
    }

    public void setSelectedNode(ITreeNode nodeSelected) {
    }

    public String[] getSelectedTableColumnNames() {
        ITreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        String[] s_tableAndColumnNames = new String[aNodes.length];
        for (int i = 0; i < aNodes.length; ++i) {
            s_tableAndColumnNames[i] = this.getNodeColumnName(aNodes[i]);
        }
        return s_tableAndColumnNames;
    }

    private String getNodeColumnName(ITreeNode node) {
        IColumn oColumn = (IColumn)((IDataTreeNode)node).getData();
        if (this.m_bUseLongName) {
            return oColumn.getFullColumnName(false);
        }
        return oColumn.getColumnName(false);
    }

    public boolean validateData() {
        String sErrorMessage = null;
        ITreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        if (aNodes.length == 0) {
            sErrorMessage = bundle.getString("TablesPaletteTreePanel.NoColumnSelected.txt");
        } else {
            for (int i = 0; i < aNodes.length; ++i) {
                if (!(aNodes[i] instanceof IDataTreeNode)) {
                    sErrorMessage = bundle.getString("TablesPaletteTreePanel.OnlyColumns.txt");
                    break;
                }
                if (((IDataTreeNode)aNodes[i]).getData() instanceof IColumn) continue;
                sErrorMessage = bundle.getString("TablesPaletteTreePanel.OnlyColumns.txt");
                break;
            }
        }
        if (sErrorMessage != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), sErrorMessage, bundle.getString("TablesPaletteTreePanel.Title.ErrorMessage.txt"), 0);
            return false;
        }
        return true;
    }

    public boolean isValidNode() {
        ITreeNode[] aNodes = this.m_treeTables.getSelectedNodes();
        if (aNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < aNodes.length; ++i) {
            if (((IDataTreeNode)aNodes[i]).getData() instanceof IColumn) continue;
            return false;
        }
        return true;
    }

    public void addTreeSelectionListener(WsSelectionChangedListener listener) {
        this.m_treeTables.addSelectionChangedListener(listener);
    }

    public void removeTreeSelectionListener(WsSelectionChangedListener listener) {
        this.m_treeTables.removeSelectionChangedListener(listener);
    }

    protected class cSortColumnsListener
    implements ActionListener {
        protected cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablesPaletteTreePanel.this.m_mdlTablesPalette.setSortColumns(TablesPaletteTreePanel.this.m_ckbSortColumns.isSelected());
        }
    }
}

