/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.OptionsCollectionPane;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TableOptionsTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(TableOptionsTab.class);
    private IPhysicalTable m_table;
    private OptionsCollectionPane m_optionsPane;

    public TableOptionsTab(IPhysicalTable table) {
        this.m_table = table;
        this.initialize();
        this.setName(bundle.getString("TableOptionsTab.Name.txt"));
    }

    protected void initialize() {
        this.m_optionsPane = new OptionsCollectionPane(false);
        this.listenForDataChangesTo(this.m_optionsPane);
        this.m_optionsPane.setWAUndoManager(this.getWAUndoManager());
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_optionsPane), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_optionsPane.setEditable(editable);
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        try {
            this.m_optionsPane.setPromptModel(this.m_table.getTableOptionCollectionForTableOnly());
        }
        catch (FileNotFoundException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServerException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        this.m_optionsPane.moveDataToView();
        this.setListeningForChanges(true);
    }

    public String getHelpTopic() {
        return this.m_optionsPane.getHelpTopic();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_optionsPane.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        return this.m_optionsPane.validateData();
    }
}

