/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.wadmin.visuals.common.TableUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SourceColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SourceColumnsTableModel.class);
    private static final int VISIBLE_COLUMNS = 9;
    private static final int INVISIBLE_COLUMNS = 2;
    public static final int COLUMNNAME_COLUMN = 0;
    public static final int COLUMNDESCR_COLUMN = 1;
    public static final int TABLENAME_COLUMN = 2;
    public static final int TABLEDESCR_COLUMN = 3;
    public static final int TYPE_COLUMN = 4;
    public static final int LENGTH_COLUMN = 5;
    public static final int INFORMAT_COLUMN = 6;
    public static final int FORMAT_COLUMN = 7;
    public static final int IS_NULLABLE_COLUMN = 8;
    private static final int COLUMN_COLUMN = 9;
    private static final int TABLE_COLUMN = 10;
    private static final int TABLENAME_WIDTH = 100;
    private static final int TABLEDESCR_WIDTH = 110;
    private static final int COLUMNNAME_WIDTH = 100;
    private static final int COLUMNDESCR_WIDTH = 110;
    private static final int TYPE_WIDTH = 75;
    private static final int LENGTH_WIDTH = 50;
    private static final int INFORMAT_WIDTH = 75;
    private static final int FORMAT_WIDTH = 75;
    private static final int IS_NULLABLE_WIDTH = 100;
    private IMappingsContainer m_container;
    private List m_lTables;
    protected ITable m_tblSelected;
    private IModelListener m_lsnrModel;

    public SourceColumnsTableModel(IMappingsContainer container) {
        this.m_container = container;
        this.m_lTables = new ArrayList();
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        String[] saTypes = ColumnUIUtilities.getViewTypes();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("SourceColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("SourceColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("SourceColumnsTableModel.Table.txt"), 100);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("SourceColumnsTableModel.TableDescr.txt"), 110);
        this.m_aColumns[4] = new WsEnumeratedTableColumn(4, bundle.getString("SourceColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[5] = new LengthTableColumn();
        this.m_aColumns[6] = new InformatTableColumn();
        this.m_aColumns[7] = new FormatTableColumn();
        this.m_aColumns[8] = new WsBooleanTableColumn(8, bundle.getString("SourceColumnsTableModel.IsNullable.txt"), 100);
        this.m_aColumns[9] = new WsObjectTableColumn();
        this.m_aColumns[10] = new WsObjectTableColumn();
        this.m_aColumns[0].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3].setEditable(false);
    }

    public int getColumnCount() {
        return 9;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public void setValueAt(Object obj, int iRow, int iColumn) {
        IColumn col = (IColumn)this.getValueAt(iRow, 9);
        if (iColumn == 0) {
            col.setName((String)obj);
        } else if (iColumn == 1) {
            col.setDescription((String)obj);
        } else if (iColumn == 4) {
            col.setType(ColumnUIUtilities.getModelType((String)obj));
        } else if (iColumn == 5) {
            col.setLength(((Integer)obj).intValue());
        } else if (iColumn == 6) {
            col.setInformat(ColumnUIUtilities.getModelInformat((String)obj));
        } else if (iColumn == 7) {
            col.setFormat(ColumnUIUtilities.getModelFormat((String)obj));
        } else if (iColumn == 8) {
            col.setNullable(((Boolean)obj).booleanValue());
        }
    }

    public void moveDataToModel() {
        this.clear();
        this.m_lTables.clear();
        ITable[] aTables = this.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (this.m_tblSelected != null && this.m_tblSelected != aTables[iTable]) continue;
            this.m_lTables.add(aTables[iTable]);
            IColumn[] aColumns = aTables[iTable].getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.m_lData.add(this.createRowValues(aColumns[iColumn]));
            }
        }
        this.fireTableModelPopulated();
    }

    protected ITable[] getSourceTables() {
        return this.m_container.getSourceTables();
    }

    public void moveDataToStore() {
    }

    public void populateStore() {
    }

    private List createRowValues(IColumn col) {
        ArrayList<Object> lValues = new ArrayList<Object>(11);
        lValues.add(col.getName());
        lValues.add(col.getDescription());
        lValues.add(TableUIUtilities.getViewName(col.getTable()));
        lValues.add(col.getTable().getDescription());
        lValues.add(ColumnUIUtilities.getViewType(col.getType()));
        lValues.add(new Integer(col.getLength()));
        lValues.add(ColumnUIUtilities.getViewInformat(col.getInformat()));
        lValues.add(ColumnUIUtilities.getViewFormat(col.getFormat()));
        lValues.add(col.isNullable());
        lValues.add(col);
        lValues.add(col.getTable());
        return lValues;
    }

    public IColumn getSourceColumn(int iRow) {
        return (IColumn)this.getValueAt(iRow, 9);
    }

    public int getRowIndex(IColumn col) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(9) != col) continue;
            return iRow;
        }
        return -1;
    }

    public String createUniqueNameForNewColumn() {
        WsUniqueNameTableColumn colName = (WsUniqueNameTableColumn)this.m_aColumns[0];
        return (String)colName.createDefaultValue();
    }

    public void setSelectedTable(ITable tbl) {
        if (this.m_tblSelected == tbl) {
            return;
        }
        this.m_tblSelected = tbl;
        this.moveDataToModel();
    }

    public ITable getSelectedTable() {
        return this.m_tblSelected;
    }

    private void addTable(ITable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (!this.m_lTables.contains(tbl)) {
            this.m_lTables.add(tbl);
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.insertRow(this.getRowCount() - 1, this.createRowValues(aColumns[iColumn]));
            }
        }
    }

    private void removeTable(ITable tbl) {
        if (this.m_tblSelected != null && this.m_tblSelected != tbl) {
            return;
        }
        if (this.m_lTables.contains(tbl)) {
            this.m_lTables.remove(tbl);
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                int iRow = this.getRowIndex(aColumns[iColumn]);
                if (iRow <= -1) continue;
                this.deleteRow(this.getRowIndex(aColumns[iColumn]));
            }
        }
    }

    private void refreshTableName(ITable tbl) {
        String sName = TableUIUtilities.getViewName(tbl);
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getValueAt(iRow, 10) != tbl) continue;
            super.setValueAt((Object)sName, iRow, 2);
        }
    }

    private void refreshTableDescription(ITable tbl) {
        String sDescription = tbl.getDescription();
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getValueAt(iRow, 10) != tbl) continue;
            super.setValueAt((Object)sDescription, iRow, 3);
        }
    }

    private void addColumn(ITable tbl, IColumn col) {
        ITable table;
        int iRow = tbl.indexOfColumn(col);
        for (int iTable = 0; iTable < this.m_lTables.size() && (table = (ITable)this.m_lTables.get(iTable)) != tbl; ++iTable) {
            iRow += table.getColumnCount();
        }
        this.insertRow(iRow - 1, this.createRowValues(col));
    }

    private void removeColumn(IColumn col) {
        int index = this.getRowIndex(col);
        if (index > -1) {
            this.deleteRow(index);
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                SourceColumnsTableModel.this.moveDataToModel();
            } else if (obj == SourceColumnsTableModel.this.m_container) {
                Object data;
                if (sType == "DataTransform.DataSourceAdded") {
                    Object data2 = ev.getData();
                    if (data2 instanceof ITable) {
                        SourceColumnsTableModel.this.addTable((ITable)data2);
                    }
                } else if (sType == "DataTransform.DataSourceRemoved" && (data = ev.getData()) instanceof ITable) {
                    SourceColumnsTableModel.this.removeTable((ITable)data);
                }
            } else if (SourceColumnsTableModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)SourceColumnsTableModel.this.m_container).getParentQuery() == obj) {
                Object data;
                if (sType == "SQLObject:QueryTableAdded") {
                    Object data3 = ev.getData();
                    if (data3 instanceof ITable) {
                        SourceColumnsTableModel.this.addTable((ITable)data3);
                    }
                } else if (sType == "SQLObject:QueryTableRemoved") {
                    Object data4 = ev.getData();
                    if (data4 instanceof ITable) {
                        SourceColumnsTableModel.this.removeTable((ITable)data4);
                    }
                } else if (sType == "BaseQuery:SubqueryAdded") {
                    Object data5 = ev.getData();
                    if (data5 instanceof ISubquery) {
                        IAliasTable table = ((ISubquery)data5).getAliasTable();
                        SourceColumnsTableModel.this.addTable((ITable)table);
                    }
                } else if (sType == "BaseQuery:SubqueryRemoved" && (data = ev.getData()) instanceof ISubquery) {
                    IAliasTable table = ((ISubquery)data).getAliasTable();
                    SourceColumnsTableModel.this.removeTable((ITable)table);
                }
            } else if (obj instanceof ITable) {
                ITable tbl = (ITable)obj;
                if (SourceColumnsTableModel.this.m_lTables.contains(tbl)) {
                    if (sType == "Object:NameChanged") {
                        SourceColumnsTableModel.this.refreshTableName(tbl);
                    } else if (sType == "PhysicalTable:SASTableNameChanged") {
                        SourceColumnsTableModel.this.refreshTableName(tbl);
                    } else if (sType == "Object:DescriptionChanged") {
                        SourceColumnsTableModel.this.refreshTableDescription(tbl);
                    } else if (sType == "Table:ColumnAdded") {
                        SourceColumnsTableModel.this.addColumn(tbl, (IColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        SourceColumnsTableModel.this.removeColumn((IColumn)ev.getData());
                        SourceColumnsTableModel.this.addColumn(tbl, (IColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        SourceColumnsTableModel.this.removeColumn((IColumn)ev.getData());
                    }
                }
            } else if (obj instanceof IColumn) {
                IColumn col = (IColumn)obj;
                int iRowIndex = SourceColumnsTableModel.this.getRowIndex(col);
                if (iRowIndex == -1) {
                    return;
                }
                if (sType == "Object:NameChanged") {
                    SourceColumnsTableModel.super.setValueAt(col.getName(), iRowIndex, 0);
                } else if (sType == "Object:DescriptionChanged") {
                    SourceColumnsTableModel.super.setValueAt(col.getDescription(), iRowIndex, 1);
                } else if (sType == "Column:LengthChanged") {
                    SourceColumnsTableModel.super.setValueAt(new Integer(col.getLength()), iRowIndex, 5);
                } else if (sType == "Column:TypeChanged") {
                    SourceColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewType(col.getType()), iRowIndex, 4);
                    SourceColumnsTableModel.this.fireTableCellUpdated(iRowIndex, 0);
                } else if (sType == "Column:InformatChanged") {
                    SourceColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewInformat(col.getInformat()), iRowIndex, 6);
                } else if (sType == "Column:FormatChanged") {
                    SourceColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewFormat(col.getFormat()), iRowIndex, 7);
                } else if (sType == "Column:NullableChanged") {
                    SourceColumnsTableModel.super.setValueAt(col.isNullable(), iRowIndex, 8);
                }
            }
        }
    }

    private class LengthTableColumn
    extends WsIntegerTableColumn {
        public LengthTableColumn() {
            super(5, bundle.getString("SourceColumnsTableModel.Length.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (oValue.equals(this.getMissingValue())) {
                return true;
            }
            int iValue = (Integer)oValue;
            int eType = SourceColumnsTableModel.this.getSourceColumn(iRow).getType();
            if (eType == 1) {
                if (iValue < 3 || iValue > 8) {
                    String sMessage = bundle.formatString("SourceColumnsTableModel.Error.NumericInvalidLength.fmt.txt", (Object)new Integer(3), (Object)new Integer(8));
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
                return true;
            }
            if (eType == 0 && (iValue < 1 || iValue > Short.MAX_VALUE)) {
                String sMessage = bundle.formatString("SourceColumnsTableModel.Error.CharacterInvalidLength.fmt.txt", (Object)new Integer(1), (Object)new Integer(Short.MAX_VALUE));
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    private class InformatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public InformatTableColumn() {
            super(6, bundle.getString("SourceColumnsTableModel.Informat.txt"), 75);
            this.setEditorEditable(true);
            this.setMaximumCharacters(32);
        }

        public void populate(JTable tbl, int row, int col) {
            IColumn column = SourceColumnsTableModel.this.getSourceColumn(row = ((WsTable)tbl).convertRowIndexToModel(row));
            if (column.getType() == 0) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }

    private class FormatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public FormatTableColumn() {
            super(7, bundle.getString("SourceColumnsTableModel.Format.txt"), 75);
            this.setEditorEditable(true);
            this.setMaximumCharacters(32);
        }

        public void populate(JTable tbl, int row, int col) {
            IColumn column = SourceColumnsTableModel.this.getSourceColumn(row = ((WsTable)tbl).convertRowIndexToModel(row));
            if (column.getType() == 0) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            IColumn col = SourceColumnsTableModel.this.getSourceColumn(iRow);
            WsCompoundIcon icon = new WsCompoundIcon();
            icon.addIcon(ColumnUIUtilities.getUsageIcon(col));
            icon.addIcon(ColumnUIUtilities.getTypeIcon(col));
            this.setIcon((Icon)icon);
            return this;
        }
    }
}

