/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ICodeFragment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JSeparator;

public class PrePostCodeTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(PrePostCodeTab.class);
    private static final String PRECODE_KEY = ".Precode";
    private static final String POSTCODE_KEY = ".Postcode";
    private JCheckBox m_ckbPreCode;
    private JCheckBox m_ckbPostCode;
    private CodePane m_pnlPreCode;
    private CodePane m_pnlPostCode;
    private WsAbstractToggleAction m_actPreCode;
    private WsAbstractToggleAction m_actPostCode;
    private IPrePostCode m_object;
    private IModelListener m_lsrModel;

    public PrePostCodeTab(IPrePostCode obj) {
        this.setName(bundle.getString("PrePostCodeTab.Name.txt"));
        this.m_object = obj;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("job_prop_prepost");
    }

    protected void initialize() {
        this.m_pnlPreCode = new CodePane(this.m_object.getPreProcessCode(), null, PRECODE_KEY);
        this.m_pnlPostCode = new CodePane(this.m_object.getPostProcessCode(), null, POSTCODE_KEY);
        this.m_actPreCode = this.createPreCodeAction();
        this.m_actPostCode = this.createPostCodeAction();
        this.m_ckbPreCode = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actPreCode);
        this.m_ckbPostCode = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actPostCode);
        this.m_lsrModel = new cModelListener();
        this.m_object.getModel().addModelListener(this.m_lsrModel);
        this.listenForDataChangesTo(this.m_ckbPreCode);
        this.listenForDataChangesTo(this.m_ckbPostCode);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_ckbPreCode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlPreCode), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JSeparator(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_ckbPostCode, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlPostCode), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    public boolean hasDataChanged() {
        return super.hasDataChanged() || this.m_pnlPreCode.hasDataChanged() || this.m_pnlPostCode.hasDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        try {
            String code;
            boolean bPreCode = this.m_object.isUsingPreProcessCode();
            boolean bPostCode = this.m_object.isUsingPostProcessCode();
            this.m_actPreCode.setSelected(bPreCode);
            this.m_pnlPreCode.setEditable(bPreCode);
            this.m_actPostCode.setSelected(bPostCode);
            this.m_pnlPostCode.setEditable(bPostCode);
            IUserWrittenCodeContainer preSource = this.m_object.getPreProcessCode();
            IUserWrittenCodeContainer postSource = this.m_object.getPostProcessCode();
            this.m_pnlPreCode.setCodeSource(preSource);
            if (preSource != null) {
                try {
                    code = preSource.getCode();
                    if (code != null) {
                        this.m_pnlPreCode.setText(code);
                    }
                }
                catch (ServerException e) {
                    throw new MdException((Throwable)e);
                }
            }
            this.m_pnlPostCode.setCodeSource(postSource);
            if (postSource != null) {
                try {
                    code = postSource.getCode();
                    if (code != null) {
                        this.m_pnlPostCode.setText(code);
                    }
                }
                catch (ServerException e) {
                    throw new MdException((Throwable)e);
                }
            }
            this.m_pnlPreCode.setDataChanged(false);
            this.m_pnlPostCode.setDataChanged(false);
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        boolean bPreCode = this.m_ckbPreCode.isSelected();
        boolean bPostCode = this.m_ckbPostCode.isSelected();
        this.m_object.setUsePreProcessCode(bPreCode);
        this.m_object.setUsePostProcessCode(bPostCode);
        if (bPreCode) {
            ICodeSource preCode = this.m_object.getPreProcessCode().getUserWrittenSourceCode();
            if (preCode != null) {
                try {
                    preCode.setCode(this.m_pnlPreCode.getText());
                }
                catch (ServerException e) {
                    throw new MdException((Throwable)e);
                }
            }
            preCode = this.createNewCodeSource();
            try {
                preCode.setCode(this.m_pnlPreCode.getText());
            }
            catch (ServerException e) {
                throw new MdException((Throwable)e);
            }
            this.m_object.setPreProcessCode(preCode);
        } else {
            this.m_object.setPreProcessCode(null);
        }
        if (bPostCode) {
            ICodeSource postCode = this.m_object.getPostProcessCode().getUserWrittenSourceCode();
            if (postCode != null) {
                try {
                    postCode.setCode(this.m_pnlPostCode.getText());
                }
                catch (ServerException e) {
                    throw new MdException((Throwable)e);
                }
            }
            postCode = this.createNewCodeSource();
            try {
                postCode.setCode(this.m_pnlPostCode.getText());
            }
            catch (ServerException e) {
                throw new MdException((Throwable)e);
            }
            this.m_object.setPostProcessCode(postCode);
        } else {
            this.m_object.setPostProcessCode(null);
        }
        this.setDataChanged(false);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_ckbPreCode.setEnabled(bEditable && this.m_object.isPreProcessEnabled());
        this.m_ckbPostCode.setEnabled(bEditable && this.m_object.isPostProcessEnabled());
        this.m_pnlPreCode.setEditable(bEditable && this.m_object.isPreProcessEnabled());
        this.m_pnlPostCode.setEditable(bEditable && this.m_object.isPostProcessEnabled());
    }

    public boolean validateData() {
        boolean leftPreCode = false;
        boolean leftPostCode = false;
        if (this.m_ckbPreCode.isSelected()) {
            if (!this.m_pnlPreCode.validateData()) {
                return false;
            }
        } else if (this.m_pnlPreCode.getText().trim().length() != 0) {
            leftPreCode = true;
        }
        if (this.m_ckbPostCode.isSelected()) {
            if (!this.m_pnlPostCode.validateData()) {
                return false;
            }
        } else if (this.m_pnlPostCode.getText().trim().length() != 0) {
            leftPostCode = true;
        }
        if (leftPreCode || leftPostCode) {
            int showMessage;
            String warningMsg = null;
            if (leftPreCode && !leftPostCode) {
                warningMsg = bundle.getString("PrePostCodeTab.LostCodePreMsg.txt");
            }
            if (!leftPreCode && leftPostCode) {
                warningMsg = bundle.getString("PrePostCodeTab.LostCodePostMsg.txt");
            }
            if (leftPreCode && leftPostCode) {
                warningMsg = bundle.getString("PrePostCodeTab.LostCodePrePostMsg.txt");
            }
            if ((showMessage = MessageUtil.displayMessage((String)warningMsg, (String)bundle.getString("PrePostCodeTab.LostCodeWarnning.Title.txt"), (int)2, (int)1)) != 0) {
                return false;
            }
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlPreCode.saveSettingsAndCleanUp();
        this.m_pnlPostCode.saveSettingsAndCleanUp();
        this.m_object.getModel().removeModelListener(this.m_lsrModel);
    }

    protected WsAbstractToggleAction createPreCodeAction() {
        return new cPreCodeToggleAction();
    }

    protected WsAbstractToggleAction createPostCodeAction() {
        return new cPostCodeToggleAction();
    }

    public void setPreCodeSource(String sourceCode) throws ServerException {
        if (!this.m_object.isUsingPreProcessCode()) {
            ICodeSource preSource = this.createNewCodeSource();
            preSource.setCode(sourceCode);
            this.m_object.setPreProcessCode(preSource);
        }
    }

    private ICodeSource createNewCodeSource() {
        IModel model = this.m_object.getModel();
        String sID = model.createIDForNewObject(this.m_object.getID());
        ICodeFragment codeSource = model.getObjectFactory().createCodeFragment(sID);
        codeSource.setName(bundle.getString("SaveAsDialog.MetadataNameDefault.txt"));
        return codeSource;
    }

    private class cModelListener
    implements IModelListener {
        private cModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            if (PrePostCodeTab.this.m_object == ev.getModelObject()) {
                String eventType = ev.getType();
                PrePostCodeTab.this.setListeningForChanges(false);
                try {
                    if ("IPrePostCode:UsePreProcessCodeChanged".equals(eventType)) {
                        boolean bPreCode = PrePostCodeTab.this.m_object.isUsingPreProcessCode();
                        PrePostCodeTab.this.m_ckbPreCode.setSelected(bPreCode);
                        PrePostCodeTab.this.m_pnlPreCode.setEditable(bPreCode);
                    } else if ("IPrePostCode:UsePostProcessCodeChanged".equals(eventType)) {
                        boolean bPostCode = PrePostCodeTab.this.m_object.isUsingPostProcessCode();
                        PrePostCodeTab.this.m_ckbPostCode.setSelected(bPostCode);
                        PrePostCodeTab.this.m_pnlPostCode.setEditable(bPostCode);
                    } else if ("IPrePostCode:PostProcessEnabledChanged".equals(eventType)) {
                        PrePostCodeTab.this.setEditable(PrePostCodeTab.this.isEditable());
                    } else if ("IPrePostCode:PreProcessEnabledChanged".equals(eventType)) {
                        PrePostCodeTab.this.setEditable(PrePostCodeTab.this.isEditable());
                    }
                }
                finally {
                    PrePostCodeTab.this.setListeningForChanges(true);
                }
            }
        }
    }

    private class cPreCodeToggleAction
    extends WsAbstractToggleAction {
        public cPreCodeToggleAction() {
            super(bundle, "PrePostCodeTab.PreCode", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PrePostCodeTab.this.m_object.setUsePreProcessCode(PrePostCodeTab.this.m_ckbPreCode.isSelected());
        }
    }

    private class cPostCodeToggleAction
    extends WsAbstractToggleAction {
        public cPostCodeToggleAction() {
            super(bundle, "PrePostCodeTab.PostCode", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PrePostCodeTab.this.m_object.setUsePostProcessCode(PrePostCodeTab.this.m_ckbPostCode.isSelected());
        }
    }
}

