/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.impl.TableUtil;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractBrowsableTextField;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.undo.AbstractUndoableEdit;

public class PhysicalStorageTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(PhysicalStorageTab.class);
    private static final String USE_JOB_DEFAULT_LOCATION_NAME = bundle.getString("PhysicalStorageTab.Location.UseJobDefault.txt");
    private static final String TEMPORARY_LOCATION_NAME = bundle.getString("PhysicalStorageTab.Location.Temporary.txt");
    private static final String REDIRECT_TO_DIFFERENT_LIBRARY_LOCATION_NAME = bundle.getString("PhysicalStorageTab.Location.RedirectToADifferentLibrary.txt");
    private IPhysicalTable m_table;
    private WATextField m_txtDBMS;
    private WsAbstractBrowsableTextField m_txtLibrary;
    private WATextField m_txtName;
    private WATextField m_txtSchema;
    private JCheckBox m_ckbCaseSensitive;
    private JCheckBox m_ckbSpecialCharacters;
    private JCheckBox m_ckbCreateAsView;
    private JButton m_btnNewLibrary;
    private JButton m_btnEditLibrary;
    private JButton m_btnGenerateName;
    private JPanel m_pnlFiller;
    private WAComboBox m_cmbLocation;
    private JLabel m_lblLocation;
    private ActionListener m_lsrLocation;
    private String m_sLocation;
    private JLabel m_lblDBMS;
    private JLabel m_lblLibrary;
    private JLabel m_lblName;
    private JLabel m_lblSchema;
    private WsAbstractAction m_actNewLibrary;
    private WsAbstractAction m_actEditLibrary;
    private WsAbstractAction m_actGenerateName;
    private WsAbstractToggleAction m_actCaseSensitive;
    private WsAbstractToggleAction m_actSpecialCharacters;
    private WsAbstractToggleAction m_actCreateAsView;
    private OMRAdapter m_omrAdapter;
    private static List m_lDBMSTypes;
    private static List m_lProductNames;
    private IModelListener m_lsrModel;
    private static final int MAX_TABLE_NAME_LENGTH = 32;
    private ActionListener m_actionListener;
    private FocusListener m_focusListener;

    public PhysicalStorageTab(IPhysicalTable table) {
        this.m_table = table;
        this.setName(bundle.getString("PhysicalStorageTab.Name.txt"));
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("physical_storage_tab");
    }

    protected void initialize() {
        this.loadDBMSTypes();
        this.m_txtDBMS = new WATextField();
        this.m_txtDBMS.setEditable(false);
        this.m_lblDBMS = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtDBMS, (String)bundle.getString("PhysicalStorageTab.DBMSLabel.txt"));
        this.m_txtDBMS.setToolTipText(bundle.getString("PhysicalStorageTab.DBMSLabel.ToolTip.txt"));
        this.m_txtLibrary = new cLibraryTextField();
        this.m_txtLibrary.getBrowseButton().setToolTipText(bundle.getString("PhysicalStorageTab.cLibraryTextField.Browse.tip"));
        this.m_lblLibrary = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtLibrary, (WAdminResource)bundle, (String)"PhysicalStorageTab.LibraryLabel");
        this.m_actNewLibrary = this.createNewLibraryAction();
        this.m_actEditLibrary = this.createEditLibraryAction();
        this.m_actGenerateName = this.createGenerateNameAction();
        this.m_actCaseSensitive = this.createCaseSensitiveAction();
        this.m_actSpecialCharacters = this.createSpecialCharactersAction();
        this.m_actCreateAsView = this.createCreateAsViewAction();
        this.m_btnNewLibrary = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewLibrary);
        this.m_btnEditLibrary = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actEditLibrary);
        this.m_btnGenerateName = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actGenerateName);
        this.m_txtName = new WATextField();
        this.m_txtName.setMaxCharacters(32);
        this.m_lblName = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtName, (WAdminResource)bundle, (String)"PhysicalStorageTab.NameLabel");
        this.m_txtSchema = new WATextField();
        this.m_lblSchema = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtSchema, (String)bundle.getString("PhysicalStorageTab.SchemaLabel.txt"));
        this.m_txtSchema.setEditable(false);
        this.m_ckbCaseSensitive = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actCaseSensitive);
        this.m_ckbSpecialCharacters = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actSpecialCharacters);
        this.m_ckbCreateAsView = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actCreateAsView);
        this.m_pnlFiller = new JPanel();
        this.m_lsrModel = new cModelListener();
        if (this.m_table != null) {
            this.m_table.getModel().addModelListener(this.m_lsrModel);
        }
        try {
            if (this.m_table != null) {
                this.m_omrAdapter = new OMRAdapter(this.m_table.getModel(), Workspace.getMdFactory(), "PhysicalStorageTab." + this.m_table.getName());
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        this.m_cmbLocation = new WAComboBox();
        this.m_cmbLocation.addItem((Object)USE_JOB_DEFAULT_LOCATION_NAME);
        this.m_cmbLocation.addItem((Object)TEMPORARY_LOCATION_NAME);
        this.m_cmbLocation.addItem((Object)REDIRECT_TO_DIFFERENT_LIBRARY_LOCATION_NAME);
        this.m_lblLocation = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbLocation, (String)bundle.getString("PhysicalStorageTab.Location.txt"));
        this.m_lsrLocation = new cLocationListener();
        this.m_cmbLocation.addActionListener(this.m_lsrLocation);
        if (this.m_table instanceof IWorkTable) {
            this.listenForDataChangesTo((JComboBox)this.m_cmbLocation);
        } else {
            this.m_lblLocation.setVisible(false);
            this.m_cmbLocation.setVisible(false);
        }
        this.m_actionListener = new TextFieldActionListener();
        this.m_txtName.addActionListener(this.m_actionListener);
        this.m_focusListener = new TextFieldFocusListener();
        this.m_txtName.addFocusListener(this.m_focusListener);
    }

    private void handleTableAdded(IPhysicalTable table) throws MdException, RemoteException {
        if (table == null) {
            return;
        }
        this.m_table = table;
        this.m_table.getModel().addModelListener(this.m_lsrModel);
        this.m_omrAdapter = new OMRAdapter(this.m_table.getModel(), Workspace.getMdFactory(), "PhysicalStorageTab." + this.m_table.getName());
        this.moveDataToView();
    }

    private void handleTableRemoved(IPhysicalTable table) throws MdException, RemoteException {
        this.m_table.getModel().removeModelListener(this.m_lsrModel);
        this.m_omrAdapter = null;
        this.m_table = null;
        this.moveDataToView();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_btnGenerateName, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add(this.m_ckbCaseSensitive, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbSpecialCharacters, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbCreateAsView, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_lblLocation, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbLocation, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_lblLibrary, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.m_txtLibrary, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_btnNewLibrary, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_btnEditLibrary, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add(this.m_lblDBMS, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.m_txtDBMS, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_lblSchema, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.m_txtSchema, new GridBagConstraints(0, 12, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_pnlFiller, new GridBagConstraints(0, 13, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (this.m_omrAdapter != null) {
            this.m_omrAdapter.dispose();
        }
    }

    private void loadDBMSTypes() {
        if (m_lDBMSTypes == null) {
            m_lDBMSTypes = new ArrayList();
            m_lProductNames = new ArrayList();
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.DB2UNXPC.notrans"));
            m_lProductNames.add("DB2UNXPC");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.DB2OS390.notrans"));
            m_lProductNames.add("DB2OS390");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.BIGQUERY.notrans"));
            m_lProductNames.add("BIGQUERY");
            m_lDBMSTypes.add(bundle.getString("PhysicalStoragePane.Informix.notrans"));
            m_lProductNames.add("INFORMIX");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.EXCEL.notrans"));
            m_lProductNames.add("EXCEL");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.SQLSVR.notrans"));
            m_lProductNames.add("SQLSVR");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.MYSQL.notrans"));
            m_lProductNames.add("MYSQL");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCDB2UNXPC.notrans"));
            m_lProductNames.add("ODBCDB2UNXPC");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCDB2OS390.notrans"));
            m_lProductNames.add("ODBCDB2OS390");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCINFORMIX.notrans"));
            m_lProductNames.add("ODBCINFORMIX");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCACCESS.notrans"));
            m_lProductNames.add("ODBCACCESS");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCEXCEL.notrans"));
            m_lProductNames.add("ODBCEXCEL");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCSQLSVRPC.notrans"));
            m_lProductNames.add("ODBCSQLSVRPC");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCORACLE.notrans"));
            m_lProductNames.add("ODBCORACLE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCOTHER.notrans"));
            m_lProductNames.add("ODBCOTHER");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCSYBASE.notrans"));
            m_lProductNames.add("ODBCSYBASE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.ODBCTERADATA.notrans"));
            m_lProductNames.add("ODBCTERADATA");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBDB2UNXPC.notrans"));
            m_lProductNames.add("OLEDBDB2UNXPC");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBDB2OS390.notrans"));
            m_lProductNames.add("OLEDBDB2OS390");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBINFORMIX.notrans"));
            m_lProductNames.add("OLEDBINFORMIX");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBACCESS.notrans"));
            m_lProductNames.add("OLEDBACCESS");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBEXCEL.notrans"));
            m_lProductNames.add("OLEDBEXCEL");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBSQLSVRPC.notrans"));
            m_lProductNames.add("OLEDBSQLSVRPC");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBORACLE.notrans"));
            m_lProductNames.add("OLEDBORACLE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBOTHER.notrans"));
            m_lProductNames.add("OLEDBOTHER");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBSYBASE.notrans"));
            m_lProductNames.add("OLEDBSYBASE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.OLEDBTERADATA.notrans"));
            m_lProductNames.add("OLEDBTERADATA");
            m_lDBMSTypes.add(bundle.getString("PhysicalStoragePane.Oracle.notrans"));
            m_lProductNames.add("ORACLE");
            m_lDBMSTypes.add(bundle.getString("PhysicalStoragePane.SAP.notrans"));
            m_lProductNames.add("SAPR3");
            m_lDBMSTypes.add("SAS");
            m_lProductNames.add("SAS");
            m_lDBMSTypes.add(bundle.getString("PhysicalStorageTab.SASInformationMapLibrary.Name.txt"));
            m_lProductNames.add("SASIOIME");
            m_lDBMSTypes.add(bundle.getString("PhysicalStorageTab.SASTableServerLibrary.Name.txt"));
            m_lProductNames.add("SASTS");
            m_lDBMSTypes.add(bundle.getString("PhysicalStoragePane.SASShare.notrans"));
            m_lProductNames.add("REMOTE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.SALESFORCE.notrans"));
            m_lProductNames.add("SALESFORCE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.SNOWFLAKE.notrans"));
            m_lProductNames.add("SNOWFLAKE");
            m_lDBMSTypes.add(bundle.getString("SPDEImporter.Name.SPDE.notrans"));
            m_lProductNames.add("SPDE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.SASSPDS.notrans"));
            m_lProductNames.add("SASSPDS");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.SYBASE.notrans"));
            m_lProductNames.add("SYBASE");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.MONGODB.notrans"));
            m_lProductNames.add("MONGO");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.SPARK.notrans"));
            m_lProductNames.add("SPARK");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.YELLOWBRICK.notrans"));
            m_lProductNames.add("YELLOWBRICK");
            m_lDBMSTypes.add(bundle.getString("DBMSImporter.Name.TERADATA.notrans"));
            m_lProductNames.add("TERADATA");
            m_lDBMSTypes.add(bundle.getString("XMLImporter.Name.XMLALL.txt"));
            m_lProductNames.add(bundle.getString("XMLImporter.description.XMLALL.notrans"));
            m_lDBMSTypes.add(bundle.getString("XMLImporter.Name.XMLCDISC.txt"));
            m_lProductNames.add(bundle.getString("XMLImporter.description.XMLCDISC.notrans"));
            m_lDBMSTypes.add(bundle.getString("XMLImporter.Name.XMLACCESS.txt"));
            m_lProductNames.add(bundle.getString("XMLImporter.description.XMLACCESS.notrans"));
            m_lDBMSTypes.add(bundle.getString("XMLImporter.Name.XMLORACLE.txt"));
            m_lProductNames.add(bundle.getString("XMLImporter.description.XMLORACLE.notrans"));
            m_lDBMSTypes.add(bundle.getString("XMLImporter.Name.XMLV2ALL.txt"));
            m_lProductNames.add(bundle.getString("XMLImporter.description.XMLV2ALL.notrans"));
            m_lDBMSTypes.add(bundle.getString("XMLImporter.Name.XMLV2XMLMAP.txt"));
            m_lProductNames.add(bundle.getString("XMLImporter.description.XMLV2XMLMAP.notrans"));
            m_lDBMSTypes.add(bundle.getString("JSONImporter.Name.JSON.txt"));
            m_lProductNames.add(bundle.getString("JSONImporter.description.JSON.notrans"));
            m_lDBMSTypes.add("SASHDAT");
            m_lProductNames.add("SASHDAT");
            m_lDBMSTypes.add("SASIOIMP");
            m_lProductNames.add("SASIOIMP");
            m_lDBMSTypes.add("SASIOPI");
            m_lProductNames.add("SASIOPI");
            m_lDBMSTypes.add("SASIOHWQ");
            m_lProductNames.add("SASIOHWQ");
            m_lDBMSTypes.add("SASIORST");
            m_lProductNames.add("SASIORST");
            m_lDBMSTypes.add("SASIOJDB");
            m_lProductNames.add("SASIOJBD");
        }
    }

    protected WsAbstractAction createNewLibraryAction() {
        return new cNewLibraryAction();
    }

    protected WsAbstractAction createEditLibraryAction() {
        return new cEditLibraryAction();
    }

    protected WsAbstractAction createGenerateNameAction() {
        return new cGenerateNameAction();
    }

    protected WsAbstractToggleAction createCaseSensitiveAction() {
        return new cCaseSensitiveAction();
    }

    protected WsAbstractToggleAction createSpecialCharactersAction() {
        return new cSpecialCharactersAction();
    }

    protected WsAbstractToggleAction createCreateAsViewAction() {
        return new cCreateAsView();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.updateVisuals();
        if (this.m_table != null) {
            this.m_txtName.setText(this.m_table.getSASTableName());
            boolean bSpecialCharacters = this.m_table.isSpecialCharacters();
            this.m_actSpecialCharacters.setSelected(bSpecialCharacters);
            this.m_actCaseSensitive.setSelected(this.m_table.isCaseSensitive());
            this.m_actCaseSensitive.setEnabled(this.isEditable() && !bSpecialCharacters);
            this.m_actCreateAsView.setSelected(this.m_table.isView());
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public boolean validateData() {
        String trimmedName = this.m_txtName.getText().trim();
        if (trimmedName.length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("PhysicalStorageTab.BlankTableName.txt"), (String)bundle.getString("PhysicalStorageTab.BlankTableName.title.txt"), (int)0);
            return false;
        }
        if (this.m_table != null && !this.m_table.isCaseSensitive() && !this.m_table.isSpecialCharacters()) {
            char[] aName = trimmedName.toCharArray();
            for (int i = 0; i < aName.length; ++i) {
                if (!Character.isWhitespace(aName[i])) continue;
                MessageUtil.displayMessage((String)bundle.getString("PhysicalStorageTab.SpacesInTableName.txt"), (String)bundle.getString("PhysicalStorageTab.SpacesInTableName.title.txt"), (int)2);
                break;
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_txtLibrary.setEditable(bEditable);
        this.m_txtName.setEditable(bEditable);
        this.m_actCreateAsView.setEnabled(bEditable);
        this.m_actNewLibrary.setEnabled(bEditable);
        this.m_actEditLibrary.setEnabled(bEditable);
        this.m_cmbLocation.setEnabled(bEditable);
        this.m_actCaseSensitive.setEnabled(bEditable);
        this.m_actSpecialCharacters.setEnabled(bEditable);
        this.m_actGenerateName.setEnabled(bEditable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLibraryForTable(String sID) {
        IModel mdl = this.m_table.getModel();
        boolean oldUndo = mdl.isUndoSupported();
        ILibrary iLib = (ILibrary)mdl.getObject(sID);
        if (iLib == null) {
            iLib = mdl.getObjectFactory().createLibrary(sID);
        }
        mdl.setUndoSupported(false);
        try {
            if (this.m_omrAdapter != null) {
                this.m_omrAdapter.populateFor((IOMRPersistable)iLib);
                iLib.loadFromOMR(this.m_omrAdapter);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            mdl.setUndoSupported(oldUndo);
        }
        if (!"JobAlternate".equals(this.m_table.getLocationType())) {
            this.m_table.setLibrary(iLib);
        } else {
            this.updateVisualsForLibrary();
        }
    }

    private void updateVisuals() {
        if (this.m_table instanceof IWorkTable) {
            if (this.m_table.getLocationType().equals("JobAlternate")) {
                this.m_cmbLocation.setSelectedItem((Object)USE_JOB_DEFAULT_LOCATION_NAME);
            } else if (this.m_table.getLocationType().equals("None")) {
                this.m_cmbLocation.setSelectedItem((Object)TEMPORARY_LOCATION_NAME);
            } else if (this.m_table.getLocationType().equals("Physical")) {
                this.m_cmbLocation.setSelectedItem((Object)REDIRECT_TO_DIFFERENT_LIBRARY_LOCATION_NAME);
            }
        }
        this.updateVisualsForLibrary();
    }

    private ILibrary getTableLibrary() {
        ILibrary tableLibrary = null;
        if ("JobAlternate".equals(this.m_table.getLocationType())) {
            tableLibrary = this.m_table.getLibraryForUseInJob();
        } else if ("Physical".equals(this.m_table.getLocationType())) {
            tableLibrary = this.m_table.getLibrary();
        }
        return tableLibrary;
    }

    private void updateVisualsForLibrary() {
        ILibrary tableLibrary = this.getTableLibrary();
        if ("JobAlternate".equals(this.m_table.getLocationType())) {
            this.m_actNewLibrary.setEnabled(false);
            this.m_txtLibrary.getBrowseButton().setEnabled(false);
        } else if ("Physical".equals(this.m_table.getLocationType())) {
            this.m_actNewLibrary.setEnabled(this.isEditable());
            this.m_txtLibrary.getBrowseButton().setEnabled(this.isEditable());
        } else {
            this.m_actEditLibrary.setEnabled(false);
            this.m_actNewLibrary.setEnabled(this.isEditable());
            this.m_txtLibrary.getBrowseButton().setEnabled(this.isEditable());
        }
        if (tableLibrary == null) {
            this.m_txtDBMS.setText("SAS");
            this.m_txtLibrary.setText(bundle.getString("PhysicalStorageTab.NoLibrary.txt"));
            this.m_txtSchema.setText("");
            this.m_actEditLibrary.setEnabled(false);
        } else {
            this.m_actEditLibrary.setEnabled(true);
            this.m_txtLibrary.setText(tableLibrary.getName());
            IDatabaseSchema schema = tableLibrary.getDatabaseSchema();
            if (schema != null) {
                this.m_txtSchema.setText(schema.getSchemaName());
            } else {
                this.m_txtSchema.setText("");
            }
            try {
                String engineName = tableLibrary.getEngine();
                String productName = tableLibrary.getDBMSProductName();
                int iProductName = "SASIOIME".equals(engineName) ? m_lProductNames.indexOf(engineName) : ("SASHDAT".equalsIgnoreCase(engineName) ? m_lProductNames.indexOf(engineName) : m_lProductNames.indexOf(productName));
                if ("XML".equalsIgnoreCase(engineName) || "XMLV2".equalsIgnoreCase(engineName)) {
                    IProperty iProperty = tableLibrary.findOption("XMLTYPE");
                    iProductName = iProperty != null && !"GENERIC".equalsIgnoreCase(iProperty.getDefaultValue()) ? m_lProductNames.indexOf(engineName + iProperty.getDefaultValue()) : m_lProductNames.indexOf(engineName);
                }
                if (iProductName == -1) {
                    this.m_txtDBMS.setText(productName);
                } else {
                    this.m_txtDBMS.setText((String)m_lDBMSTypes.get(iProductName));
                }
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class cLibraryTextField
    extends WsAbstractBrowsableTextField {
        private cLibraryTextField() {
        }

        public void setEnabled(boolean bEnabled) {
            this.m_txt.setEnabled(false);
            this.m_btn.setEnabled(bEnabled && this.isEditable());
        }

        public boolean isEnabled() {
            return this.m_btn.isEnabled();
        }

        public void setEditable(boolean bEditable) {
            this.m_txt.setEditable(false);
            this.m_btn.setEnabled(bEditable && this.isEnabled());
        }

        public boolean isEditable() {
            return this.m_btn.isEnabled();
        }

        protected Border createTextFieldBorder() {
            if (WsUIUtilities.isXPThemeActive()) {
                return new EmptyBorder(1, 5, 1, 0);
            }
            return new EmptyBorder(1, 1, 1, 0);
        }

        protected void showDialog() {
            if (PhysicalStorageTab.this.m_table == null) {
                return;
            }
            ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 2);
            pnl.setSelectedObject((SimpleObject)PhysicalStorageTab.this.m_table.getLibrary());
            pnl.setSelectionOptional(true);
            pnl.setHelpProduct("shared");
            pnl.setHelpTopic("select_library_win");
            String sTitle = bundle.getString("PhysicalStorageTab.cLibraryTextField.LibrarySelector.title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject lib = pnl.getSelectedObject();
                if (lib != null) {
                    PhysicalStorageTab.this.setLibraryForTable(lib.getID());
                } else {
                    PhysicalStorageTab.this.m_table.setLibrary(null);
                }
            }
        }
    }

    private class cModelListener
    implements IModelListener {
        private cModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() == PhysicalStorageTab.this.m_table) {
                PhysicalStorageTab.this.setListeningForChanges(false);
                try {
                    String sType = ev.getType();
                    if ("PhysicalTable:LibraryChanged".equals(sType)) {
                        PhysicalStorageTab.this.updateVisuals();
                        return;
                    }
                    if ("PhysicalTable:SASTableNameChanged".equals(sType)) {
                        PhysicalStorageTab.this.m_txtName.setText(PhysicalStorageTab.this.m_table.getSASTableName());
                        return;
                    }
                    if ("Table:CaseChanged".equals(sType)) {
                        PhysicalStorageTab.this.m_actCaseSensitive.setSelected(PhysicalStorageTab.this.m_table.isCaseSensitive());
                        return;
                    }
                    if ("Table:SpecialCharsChanged".equals(sType)) {
                        boolean bSpecialCharacters = PhysicalStorageTab.this.m_table.isSpecialCharacters();
                        PhysicalStorageTab.this.m_actSpecialCharacters.setSelected(bSpecialCharacters);
                        PhysicalStorageTab.this.m_actCaseSensitive.setEnabled(!bSpecialCharacters);
                        return;
                    }
                    if ("PhysicalTable:LocationTypeChanged".equals(sType)) {
                        PhysicalStorageTab.this.updateVisuals();
                        return;
                    }
                    if (!"Table:ViewChanged".equals(sType)) return;
                    PhysicalStorageTab.this.m_actCreateAsView.setSelected(PhysicalStorageTab.this.m_table.isView());
                    return;
                }
                finally {
                    PhysicalStorageTab.this.setListeningForChanges(true);
                }
            }
            if (!(ev.getModelObject() instanceof IPhysicalTable)) return;
            try {
                String sType = ev.getType();
                if ("DataTransform.DataTargetAdded".equals(sType)) {
                    PhysicalStorageTab.this.handleTableAdded((IPhysicalTable)ev.getModelObject());
                    PhysicalStorageTab.this.updateVisuals();
                    return;
                } else {
                    if (!"DataTransform.DataTargetRemoved".equals(sType)) return;
                    PhysicalStorageTab.this.handleTableRemoved((IPhysicalTable)ev.getModelObject());
                    PhysicalStorageTab.this.updateVisuals();
                }
                return;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                return;
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
                return;
            }
            finally {
                PhysicalStorageTab.this.setListeningForChanges(true);
            }
        }
    }

    private class cLocationListener
    implements ActionListener {
        private cLocationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String sMode = (String)PhysicalStorageTab.this.m_cmbLocation.getSelectedItem();
            if (sMode.equals(PhysicalStorageTab.this.m_sLocation) || !(PhysicalStorageTab.this.m_table instanceof IWorkTable)) {
                return;
            }
            PhysicalStorageTab.this.m_sLocation = sMode;
            if (sMode.equals(USE_JOB_DEFAULT_LOCATION_NAME)) {
                PhysicalStorageTab.this.m_table.setLocationType("JobAlternate");
            } else if (sMode.equals(TEMPORARY_LOCATION_NAME)) {
                PhysicalStorageTab.this.m_table.setLocationType("None");
            } else if (sMode.equals(REDIRECT_TO_DIFFERENT_LIBRARY_LOCATION_NAME)) {
                PhysicalStorageTab.this.m_table.setLocationType("Physical");
            }
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == PhysicalStorageTab.this.m_actGenerateName) {
                PhysicalStorageTab.this.m_table.setSASTableName(PhysicalStorageTab.this.m_txtName.getText());
            }
        }
    }

    private class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            String newName;
            String oldName;
            if (event.getComponent() == PhysicalStorageTab.this.m_txtName && !(oldName = PhysicalStorageTab.this.m_table.getSASTableName()).equals(newName = PhysicalStorageTab.this.m_txtName.getText())) {
                PhysicalStorageTab.this.m_table.setSASTableName(newName);
            }
        }
    }

    private class cNewLibraryAction
    extends WsAbstractAction {
        public cNewLibraryAction() {
            super(bundle, "PhysicalStorageTab.cNewLibraryAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SimpleObject lib;
            IFolder folder;
            SimpleObjectImpl simpleFolder = null;
            if (PhysicalStorageTab.this.m_table != null && (folder = PhysicalStorageTab.this.m_table.getFolder()) != null) {
                simpleFolder = new SimpleObjectImpl(folder.getName(), folder.getID(), folder.getOMRType(), "Folder");
            }
            if ((lib = AppDialogFactory.getInstance().showNewLibraryDialog((JFrame)Workspace.getWorkspace(), (SimpleObject)simpleFolder)) != null) {
                PhysicalStorageTab.this.setLibraryForTable(lib.getID());
            }
        }
    }

    private class cEditLibraryAction
    extends WsAbstractAction {
        public cEditLibraryAction() {
            super(bundle, "PhysicalStorageTab.cEditLibraryAction", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (PhysicalStorageTab.this.m_table != null) {
                ILibrary lib = PhysicalStorageTab.this.getTableLibrary();
                AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)lib);
                boolean bUndo = PhysicalStorageTab.this.m_table.getModel().isUndoSupported();
                try {
                    PhysicalStorageTab.this.m_table.getModel().setUndoSupported(false);
                    PhysicalStorageTab.this.setLibraryForTable(lib.getID());
                }
                finally {
                    PhysicalStorageTab.this.m_table.getModel().setUndoSupported(bUndo);
                }
            }
        }
    }

    private class cGenerateNameAction
    extends WsAbstractAction {
        public cGenerateNameAction() {
            super(bundle, "PhysicalStorageTab.cGenerateNameAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            String newName = TableUtil.createUniqueTableName((int)0);
            PhysicalStorageTab.this.m_txtName.setText(newName);
            PhysicalStorageTab.this.m_table.setSASTableName(newName);
        }
    }

    private class cCaseSensitiveAction
    extends WsAbstractToggleAction {
        public cCaseSensitiveAction() {
            super(bundle, "PhysicalStorageTab.cCaseSensitiveAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalStorageTab.this.m_table.setCaseSensitive(this.isSelected());
        }
    }

    private class cSpecialCharactersAction
    extends WsAbstractToggleAction {
        public cSpecialCharactersAction() {
            super(bundle, "PhysicalStorageTab.cSpecialCharactersAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalStorageTab.this.m_table.setSpecialCharacters(this.isSelected());
        }
    }

    private class cCreateAsView
    extends WsAbstractToggleAction {
        public cCreateAsView() {
            super(bundle, "PhysicalStorageTab.CreateAsViewAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalStorageTab.this.m_table.setView(this.isSelected());
        }
    }

    private class SetTextUndoable
    extends AbstractUndoableEdit {
        private String m_sOldText;
        private String m_sNewText;

        public SetTextUndoable(String sOldText, String sNewText) {
            this.m_sOldText = sOldText;
            this.m_sNewText = sNewText;
        }

        @Override
        public void undo() {
            super.undo();
            PhysicalStorageTab.this.m_txtName.setText(this.m_sOldText);
        }

        @Override
        public void redo() {
            super.redo();
            PhysicalStorageTab.this.m_txtName.setText(this.m_sNewText);
        }
    }
}

